/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.google.gson.stream.JsonToken;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public final class SourceMapFileType
extends LanguageFileType {
    public static final SourceMapFileType INSTANCE = new SourceMapFileType();
    public static final String DOT_DEFAULT_EXTENSION = ".map";

    public SourceMapFileType() {
        super((Language)JsonLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("SourceMap" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/sourcemap/SourceMapFileType", "getName"));
        }
        return "SourceMap";
    }

    @NotNull
    public String getDescription() {
        if ("SourceMap files" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/sourcemap/SourceMapFileType", "getDescription"));
        }
        return "SourceMap files";
    }

    @NotNull
    public String getDefaultExtension() {
        if ("map" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/sourcemap/SourceMapFileType", "getDefaultExtension"));
        }
        return "map";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Json;
    }

    static final class MyFileTypeDetector
    implements FileTypeRegistry.FileTypeDetector {
        MyFileTypeDetector() {
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/sourcemap/SourceMapFileType$MyFileTypeDetector", "detect"));
            }
            if (firstBytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstBytes", "com/intellij/javascript/debugger/sourcemap/SourceMapFileType$MyFileTypeDetector", "detect"));
            }
            if (!file.getName().endsWith(SourceMapFileType.DOT_DEFAULT_EXTENSION) || firstCharsIfText == null) {
                return null;
            }
            try {
                JsonReaderEx jsonReader = new JsonReaderEx(firstCharsIfText);
                if (jsonReader.peek() != JsonToken.BEGIN_OBJECT) {
                    return null;
                }
                jsonReader.beginObject();
                String firstName = jsonReader.nextName();
                return firstName.equals("version") && jsonReader.peek() == JsonToken.NUMBER || firstName.equals("names") && jsonReader.peek() == JsonToken.BEGIN_ARRAY ? INSTANCE : null;
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public int getVersion() {
            return 1;
        }
    }

    static final class MyFileTypeFactory
    extends FileTypeFactory {
        MyFileTypeFactory() {
        }

        public void createFileTypes(@NotNull FileTypeConsumer consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/debugger/sourcemap/SourceMapFileType$MyFileTypeFactory", "createFileTypes"));
            }
            consumer.consume((FileType)INSTANCE, (String)null);
        }
    }
}

