/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.primitives.UnsignedInts;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.AsarKt;
import com.intellij.util.io.DirectoryItem;
import com.intellij.util.io.FileItem;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.Item;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0013J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/io/AsarFileSystem;", "", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "root", "", "", "Lcom/intellij/util/io/Item;", "vfsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVfsRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setVfsRoot", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getDir", "Lcom/intellij/util/io/DirectoryItem;", "path", "getFile", "Lcom/intellij/util/io/FileItem;", "loadBytes", "", "item", "loadText", "", "openFileChannel", "Ljava/nio/channels/SeekableByteChannel;", "kotlin.jvm.PlatformType", "JavaScriptDebugger"})
public final class AsarFileSystem {
    private final Map<String, Item> root;
    @Nullable
    private VirtualFile vfsRoot;
    private final Path file;

    @Nullable
    public final VirtualFile getVfsRoot() {
        return this.vfsRoot;
    }

    public final void setVfsRoot(@Nullable VirtualFile virtualFile) {
        this.vfsRoot = virtualFile;
    }

    @Nullable
    public final CharSequence loadText(@NotNull String path) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileItem fileItem = this.getFile(path);
        if (fileItem != null) {
            FileItem fileItem2;
            FileItem it = fileItem2 = fileItem;
            charSequence = this.loadText(it);
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CharSequence loadText(@NotNull FileItem item) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Closeable closeable = Files.newByteChannel(this.file, new OpenOption[0]);
        boolean bl = false;
        try {
            CharSequence charSequence2;
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            it.position(item.getOffset());
            Closeable closeable2 = Channels.newInputStream(it);
            boolean bl2 = false;
            try {
                InputStream it2;
                InputStream inputStream = it2 = (InputStream)closeable2;
                Charset charset = null;
                boolean bl3 = true;
                Object var11_17 = null;
                if (bl3 & true) {
                    charset = Charsets.UTF_8;
                }
                charSequence2 = IoKt.readCharSequence((InputStreamReader)new InputStreamReader(inputStream, charset), (int)item.getSize());
            }
            catch (Exception exception) {
                bl2 = true;
                try {
                    Closeable closeable3 = closeable2;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl2) {
                    Closeable closeable4 = closeable2;
                    if (closeable4 != null) {
                        closeable4.close();
                    }
                }
            }
            charSequence = charSequence2;
        }
        catch (Exception exception) {
            bl = true;
            try {
                Closeable closeable5 = closeable;
                if (closeable5 != null) {
                    closeable5.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                Closeable closeable6 = closeable;
                if (closeable6 != null) {
                    closeable6.close();
                }
            }
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] loadBytes(@NotNull FileItem item) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Closeable closeable = Files.newByteChannel(this.file, new OpenOption[0]);
        boolean bl = false;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            it.position(item.getOffset());
            ByteBuffer buffer = ByteBuffer.allocate(item.getSize());
            do {
                it.read(buffer);
            } while (buffer.remaining() > 0);
            byte[] byArray2 = buffer.array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"buffer.array()");
            byArray = byArray2;
        }
        catch (Exception exception) {
            bl = true;
            try {
                Closeable closeable2 = closeable;
                if (closeable2 != null) {
                    closeable2.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                Closeable closeable3 = closeable;
                if (closeable3 != null) {
                    closeable3.close();
                }
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.newByteChannel(fil\u2026     buffer.array()\n    }");
        return byArray;
    }

    @Nullable
    public final FileItem getFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Item item = AsarKt.access$getItem(path, this.root);
        if (!(item instanceof FileItem)) {
            item = null;
        }
        return (FileItem)item;
    }

    @Nullable
    public final DirectoryItem getDir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Item item = AsarKt.access$getItem(path, this.root);
        if (!(item instanceof DirectoryItem)) {
            item = null;
        }
        return (DirectoryItem)item;
    }

    public final SeekableByteChannel openFileChannel() {
        return Files.newByteChannel(this.file, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public AsarFileSystem(@NotNull Path file) {
        void root;
        LittleEndianDataInputStream littleEndianDataInputStream;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Closeable closeable = Files.newInputStream(this.file, new OpenOption[0]);
        int n = 0;
        boolean bl = true;
        Object var6_9 = null;
        LittleEndianDataInputStream littleEndianDataInputStream2 = littleEndianDataInputStream;
        LittleEndianDataInputStream littleEndianDataInputStream3 = littleEndianDataInputStream;
        if (bl & true) {
            n = 8192;
        }
        BufferedInputStream bufferedInputStream = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        littleEndianDataInputStream2((InputStream)bufferedInputStream);
        closeable = (Closeable)littleEndianDataInputStream3;
        n = 0;
        try {
            JsonReader jsonReader;
            LittleEndianDataInputStream it = (LittleEndianDataInputStream)closeable;
            if (it.readInt() != 4) {
                throw (Throwable)new IOException("Incorrect header");
            }
            int headerSize = (int)UnsignedInts.toLong((int)it.readInt()) + 8;
            if (Files.size(this.file) < (long)headerSize) {
                throw (Throwable)new IOException("File size is less than specified header size");
            }
            it.readLong();
            InputStream inputStream = (InputStream)it;
            Charset charset = null;
            boolean bl2 = true;
            Object var10_18 = null;
            JsonReader jsonReader2 = jsonReader;
            JsonReader jsonReader3 = jsonReader;
            void var13_21 = root;
            if (bl2 & true) {
                charset = Charsets.UTF_8;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
            jsonReader2((Reader)inputStreamReader);
            var13_21.element = AsarKt.access$readItem(jsonReader3, headerSize);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            n = 1;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (n == 0) {
                closeable.close();
            }
        }
        THashMap tHashMap = (THashMap)root.element;
        if (tHashMap == null) {
            Intrinsics.throwNpe();
        }
        this.root = (Map)tHashMap;
        objectRef = null;
    }
}

