/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config;

import com.intellij.javascript.nodejs.util.JSLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.PathHolder;
import com.intellij.lang.javascript.linter.SharedConfigurationPaths;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintInspection;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TsLintConfiguration", storages={@Storage(value="jsLinters/tslint.xml")})
public class TsLintConfiguration
extends JSLinterConfiguration<TsLintState> {
    public static final String TSLINT_JSON = "tslint.json";
    public static final String LOG_CATEGORY = "#com.intellij.lang.javascript.linter.tslint.TsLint";
    private static final String TSLINT_ELEMENT_NAME = "tslint";
    private static final String IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-custom-config-file";
    private static final String CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME = "custom-config-file-path";
    private static final String RULES = "rules";
    private static final String ALLOW_JS = "allowJs";
    private final PathHolder myPathHolder;
    private final JSLinterPackage myPackage;
    private TsLintState DEFAULT_STATE;

    public TsLintConfiguration(@NotNull Project project, @NotNull SharedConfigurationPaths paths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "<init>"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "<init>"));
        }
        super(project);
        this.myPathHolder = paths.createPathHolder(new Runnable(){

            @Override
            public void run() {
                ExtendedLinterState state = TsLintConfiguration.this.getExtendedState();
                ((TsLintState)state.getState()).setCustomConfigFilePath(TsLintConfiguration.this.myPathHolder.getPath());
                TsLintConfiguration.this.setExtendedState(state);
            }
        });
        this.myPackage = new JSLinterPackage(project, TSLINT_ELEMENT_NAME);
    }

    @NotNull
    public static TsLintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "getInstance"));
        }
        TsLintConfiguration tsLintConfiguration = (TsLintConfiguration)JSLinterConfiguration.getInstance((Project)project, TsLintConfiguration.class);
        if (tsLintConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "getInstance"));
        }
        return tsLintConfiguration;
    }

    protected void savePrivateSettings(@NotNull TsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "savePrivateSettings"));
        }
        this.myPathHolder.setPath(StringUtil.notNullize((String)state.getCustomConfigFilePath()));
        this.storeLinterLocalPaths(state);
    }

    @NotNull
    protected TsLintState loadPrivateSettings(@NotNull TsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "loadPrivateSettings"));
        }
        this.myPathHolder.setPath(StringUtil.notNullize((String)state.getCustomConfigFilePath()));
        TsLintState.Builder builder = new TsLintState.Builder(state);
        this.restoreLinterLocalPaths(builder);
        TsLintState tsLintState = builder.build();
        if (tsLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "loadPrivateSettings"));
        }
        return tsLintState;
    }

    public boolean isAllowJs() {
        return ((TsLintState)this.getMyStateWithoutPrivateSettings()).isAllowJs();
    }

    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (TsLintInspection.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "getInspectionClass"));
        }
        return TsLintInspection.class;
    }

    @Nullable
    protected Element toXml(@NotNull TsLintState state) {
        String rulesDirectory;
        String customConfigFilePath;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "toXml"));
        }
        Element root = new Element(TSLINT_ELEMENT_NAME);
        if (state.isCustomConfigFileUsed()) {
            root.setAttribute(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME, Boolean.TRUE.toString());
        }
        if (!StringUtil.isEmptyOrSpaces((String)(customConfigFilePath = state.getCustomConfigFilePath()))) {
            root.setAttribute(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME, FileUtil.toSystemIndependentName((String)customConfigFilePath));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(rulesDirectory = state.getRulesDirectory()))) {
            root.setAttribute(RULES, FileUtil.toSystemIndependentName((String)rulesDirectory));
        }
        if (state.isAllowJs()) {
            root.setAttribute(ALLOW_JS, String.valueOf(true));
        }
        this.storeLinterLocalPaths(state);
        return root;
    }

    @NotNull
    protected TsLintState fromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "fromXml"));
        }
        TsLintState.Builder builder = new TsLintState.Builder();
        builder.setCustomConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        String customConfigFilePath = StringUtil.notNullize((String)element.getAttributeValue(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME));
        builder.setCustomConfigFilePath(FileUtil.toSystemDependentName((String)customConfigFilePath));
        String rulesDirectory = element.getAttributeValue(RULES);
        if (!StringUtil.isEmptyOrSpaces((String)rulesDirectory)) {
            builder.setRulesDirectory(rulesDirectory);
        }
        builder.setAllowJs(Boolean.parseBoolean(element.getAttributeValue(ALLOW_JS)));
        this.restoreLinterLocalPaths(builder);
        TsLintState tsLintState = builder.build();
        if (tsLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "fromXml"));
        }
        return tsLintState;
    }

    private void restoreLinterLocalPaths(TsLintState.Builder builder) {
        this.myPackage.readOrDetect();
        builder.setNodePath(this.myPackage.getInterpreter());
        builder.setPackagePath(StringUtil.notNullize((String)this.myPackage.getPackagePath()));
    }

    private void storeLinterLocalPaths(TsLintState state) {
        this.myPackage.force(state.getInterpreterRef(), state.getPackagePath());
    }

    @NotNull
    protected TsLintState getDefaultState() {
        TsLintState state = this.DEFAULT_STATE;
        if (state != null) {
            TsLintState tsLintState = state;
            if (tsLintState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "getDefaultState"));
            }
            return tsLintState;
        }
        TsLintState.Builder builder = new TsLintState.Builder();
        builder.setCustomConfigFileUsed(false);
        this.DEFAULT_STATE = state = builder.build();
        TsLintState tsLintState = state;
        if (tsLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration", "getDefaultState"));
        }
        return tsLintState;
    }
}

