/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.execution;

import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintConfigFileSearcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLint");

    public String validate(@NotNull TsLintState state) {
        String configFilePath;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/execution/TsLintConfigFileSearcher", "validate"));
        }
        if (state.isCustomConfigFileUsed() && StringUtil.isEmptyOrSpaces((String)(configFilePath = state.getCustomConfigFilePath()))) {
            return "Configuration file for TSLint is not specified";
        }
        return null;
    }

    public VirtualFile getConfig(@NotNull TsLintState state, @NotNull VirtualFile virtualFile) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/execution/TsLintConfigFileSearcher", "getConfig"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/linter/tslint/execution/TsLintConfigFileSearcher", "getConfig"));
        }
        if (state.isCustomConfigFileUsed()) {
            String configFilePath = state.getCustomConfigFilePath();
            if (StringUtil.isEmptyOrSpaces((String)configFilePath)) {
                return null;
            }
            File configFile = new File(configFilePath);
            return VfsUtil.findFileByIoFile((File)configFile, (boolean)false);
        }
        return TsLintConfigFileSearcher.lookupParentConfig(virtualFile);
    }

    @Nullable
    private static VirtualFile lookupParentConfig(@NotNull VirtualFile vf) {
        VirtualFile virtualFile;
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/lang/javascript/linter/tslint/execution/TsLintConfigFileSearcher", "lookupParentConfig"));
        }
        for (VirtualFile current = vf.getParent(); current != null; current = current.getParent()) {
            VirtualFile child = current.findChild("tslint.json");
            if (child == null) continue;
            return child;
        }
        File file = new File(SystemProperties.getUserHome());
        if (file.exists() && (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)) == null) {
            LOG.debug("Could not find virtual file for config file, though config file exists: " + file.getAbsolutePath());
        }
        return null;
    }
}

