/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.fix;

import com.intellij.history.LocalHistory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class TsLintFileFixAction
extends JSLinterFixAction {
    public TsLintFileFixAction() {
        super(TsLintBundle.message("tslint.framework.title", new Object[0]), TsLintBundle.message("tslint.action.fix.all.problem.title", new Object[0]), null);
    }

    @NotNull
    protected JSLinterConfiguration getConfiguration(Project project) {
        TsLintConfiguration tsLintConfiguration = TsLintConfiguration.getInstance(project);
        if (tsLintConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction", "getConfiguration"));
        }
        return tsLintConfiguration;
    }

    protected Task createTask(final @NotNull Project project, final @NotNull Collection<VirtualFile> filesToProcess, final @NotNull Runnable completeCallback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction", "createTask"));
        }
        if (filesToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToProcess", "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction", "createTask"));
        }
        if (completeCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completeCallback", "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction", "createTask"));
        }
        LocalHistory.getInstance().putSystemLabel(project, JSBundle.message((String)"javascript.linter.action.fix.problems.name.start", (Object[])new Object[]{TsLintBundle.message("tslint.framework.title", new Object[0])}));
        return new Task.Backgroundable(project, TsLintBundle.message("tslint.action.background.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction$1", "run"));
                }
                TsLintLanguageService service = TsLintLanguageService.getService(project);
                TsLintState state = (TsLintState)TsLintConfiguration.getInstance(project).getExtendedState().getState();
                for (VirtualFile file : filesToProcess) {
                    indicator.setText("Processing file " + file.getCanonicalPath());
                    Future future = (Future)ReadAction.compute(() -> service.highlightAndFix(file, state));
                    JSLanguageServiceUtil.awaitFuture((Future)future, (long)JSLanguageServiceUtil.TIMEOUT_MILLS, (long)10L, (ProgressIndicator)indicator);
                }
                completeCallback.run();
            }
        };
    }

    protected Collection<FileType> getFileTypes() {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES;
    }
}

