/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Reader;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class TestEventXPPXmlView
implements TestEventXmlView {
    private static final HierarchicalStreamDriver DRIVER = new XppDriver();
    private String myTestEventType;
    private String myTestParentId;
    private String myTestId;
    private String myTestClassName;
    private String myTestEventResultType;
    private String myEventTitle;
    private String myEventOpenSettings;
    private String myEventMessage;
    private String myTestEventTest;
    private String myTestEventTestDescription;
    private String myEventTestReport;
    private String myEventTestResultActionFilePath;
    private String myEventTestResultFilePath;
    private String myEventTestResultExpected;
    private String myEventTestResultActual;
    private String myEventTestResultFailureType;
    private String myEventTestResultStackTrace;
    private String myEventTestResultErrorMsg;
    private String myEventTestResultEndTime;
    private String myEventTestResultStartTime;
    private String myTestName;

    public TestEventXPPXmlView(@NotNull String xml) throws TestEventXmlView.XmlParserException {
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "<init>"));
        }
        HierarchicalStreamReader parser = DRIVER.createReader((Reader)new StringReader(xml));
        if (!"ijLog".equals(parser.getNodeName())) {
            throw new RuntimeException("root element must be 'ijLog'");
        }
        while (parser.hasMoreChildren()) {
            parser.moveDown();
            if ("event".equals(parser.getNodeName())) {
                this.myTestEventType = parser.getAttribute("type");
                this.myEventOpenSettings = parser.getAttribute("openSettings");
                this.myEventTestReport = parser.getAttribute("testReport");
                while (parser.hasMoreChildren()) {
                    parser.moveDown();
                    if ("title".equals(parser.getNodeName())) {
                        this.myEventTitle = parser.getValue();
                    } else if ("message".equals(parser.getNodeName())) {
                        this.myEventMessage = parser.getValue();
                    } else if ("test".equals(parser.getNodeName())) {
                        this.myTestParentId = parser.getAttribute("parentId");
                        this.myTestId = parser.getAttribute("id");
                        while (parser.hasMoreChildren()) {
                            parser.moveDown();
                            if ("descriptor".equals(parser.getNodeName())) {
                                this.myTestName = parser.getAttribute("name");
                                this.myTestClassName = parser.getAttribute("className");
                            } else if ("event".equals(parser.getNodeName())) {
                                this.myTestEventTestDescription = parser.getAttribute("destination");
                                this.myTestEventTest = parser.getValue();
                            } else if ("result".equals(parser.getNodeName())) {
                                this.myTestEventResultType = parser.getAttribute("resultType");
                                this.myEventTestResultEndTime = parser.getAttribute("endTime");
                                this.myEventTestResultStartTime = parser.getAttribute("startTime");
                                while (parser.hasMoreChildren()) {
                                    parser.moveDown();
                                    if ("actualFilePath".equals(parser.getNodeName())) {
                                        this.myEventTestResultActionFilePath = parser.getValue();
                                    } else if ("filePath".equals(parser.getNodeName())) {
                                        this.myEventTestResultFilePath = parser.getValue();
                                    } else if ("expected".equals(parser.getNodeName())) {
                                        this.myEventTestResultExpected = parser.getValue();
                                    } else if ("actual".equals(parser.getNodeName())) {
                                        this.myEventTestResultActual = parser.getValue();
                                    } else if ("failureType".equals(parser.getNodeName())) {
                                        this.myEventTestResultFailureType = parser.getValue();
                                    } else if ("stackTrace".equals(parser.getNodeName())) {
                                        this.myEventTestResultStackTrace = parser.getValue();
                                    } else if ("errorMsg".equals(parser.getNodeName())) {
                                        this.myEventTestResultErrorMsg = parser.getValue();
                                    }
                                    parser.moveUp();
                                }
                            }
                            parser.moveUp();
                        }
                    }
                    parser.moveUp();
                }
            }
            parser.moveUp();
        }
    }

    @Override
    @NotNull
    public String getTestEventType() {
        String string = this.myTestEventType == null ? "" : this.myTestEventType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getTestEventType"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestName() {
        String string = this.myTestName == null ? "" : this.myTestName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getTestName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestParentId() {
        String string = this.myTestParentId == null ? "" : this.myTestParentId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getTestParentId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestId() {
        String string = this.myTestId == null ? "" : this.myTestId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getTestId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestClassName() {
        String string = this.myTestClassName == null ? "" : this.myTestClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getTestClassName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestEventResultType() {
        String string = this.myTestEventResultType == null ? "" : this.myTestEventResultType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getTestEventResultType"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTitle() {
        String string = this.myEventTitle == null ? "" : this.myEventTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTitle"));
        }
        return string;
    }

    @Override
    public boolean isEventOpenSettings() {
        return Boolean.parseBoolean(this.myEventOpenSettings == null ? "" : this.myEventOpenSettings);
    }

    @Override
    @NotNull
    public String getEventMessage() {
        String string = this.myEventMessage == null ? "" : this.myEventMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventMessage"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestEventTest() {
        String string = this.myTestEventTest == null ? "" : this.myTestEventTest;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getTestEventTest"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestEventTestDescription() {
        String string = this.myTestEventTestDescription == null ? "" : this.myTestEventTestDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getTestEventTestDescription"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestReport() {
        String string = this.myEventTestReport == null ? "" : this.myEventTestReport;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestReport"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultActualFilePath() {
        String string = this.myEventTestResultActionFilePath == null ? "" : this.myEventTestResultActionFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultActualFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultFilePath() {
        String string = this.myEventTestResultFilePath == null ? "" : this.myEventTestResultFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultExpected() {
        String string = this.myEventTestResultExpected == null ? "" : this.myEventTestResultExpected;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultExpected"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultActual() {
        String string = this.myEventTestResultActual == null ? "" : this.myEventTestResultActual;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultActual"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultFailureType() {
        String string = this.myEventTestResultFailureType == null ? "" : this.myEventTestResultFailureType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultFailureType"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultStackTrace() {
        String string = this.myEventTestResultStackTrace == null ? "" : this.myEventTestResultStackTrace;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultStackTrace"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultErrorMsg() {
        String string = this.myEventTestResultErrorMsg == null ? "" : this.myEventTestResultErrorMsg;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultErrorMsg"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultEndTime() {
        String string = this.myEventTestResultEndTime == null ? "" : this.myEventTestResultEndTime;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultEndTime"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getEventTestResultStartTime() {
        String string = this.myEventTestResultStartTime == null ? "" : this.myEventTestResultStartTime;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXPPXmlView", "getEventTestResultStartTime"));
        }
        return string;
    }
}

