/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.common.util.SecurityUtil;

abstract class DynamicLinkerImpl
implements DynamicLinker {
    private final Object secSync = new Object();
    private boolean allLinkPermissionGranted = false;
    private static final LongObjectHashMap libHandle2Name = new LongObjectHashMap(16);

    DynamicLinkerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void claimAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            this.allLinkPermissionGranted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void releaseAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            this.allLinkPermissionGranted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkLinkPermission(String string) throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                SecurityUtil.checkLinkPermission(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkLinkPermission(long l) throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                LibRef libRef = this.getLibRef(l);
                if (null == libRef) {
                    String string = String.valueOf(Long.toHexString(l));
                    throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Library handle 0x").append(string).append(" unknown.").toString());
                }
                SecurityUtil.checkLinkPermission(libRef.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                SecurityUtil.checkAllLinkPermission();
            }
        }
    }

    @Override
    public final long openLibraryGlobal(String string, boolean bl) throws SecurityException {
        this.checkLinkPermission(string);
        long l = this.openLibraryGlobalImpl(string);
        if (0L != l) {
            LibRef libRef = this.incrLibRefCount(l, string);
            if (DEBUG || bl) {
                String string2 = String.valueOf(Long.toHexString(l));
                String string3 = String.valueOf(libRef);
                System.err.println(new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("DynamicLinkerImpl.openLibraryGlobal \"").append(string).append("\": 0x").append(string2).append(" -> ").append(string3).append(")").toString());
            }
        } else if (DEBUG || bl) {
            String string4 = this.getLastError();
            System.err.println(new StringBuilder(54 + String.valueOf(string).length() + String.valueOf(string4).length()).append("DynamicLinkerImpl.openLibraryGlobal \"").append(string).append("\" failed, error: ").append(string4).toString());
        }
        return l;
    }

    protected abstract long openLibraryGlobalImpl(String var1) throws SecurityException;

    @Override
    public final long openLibraryLocal(String string, boolean bl) throws SecurityException {
        this.checkLinkPermission(string);
        long l = this.openLibraryLocalImpl(string);
        if (0L != l) {
            LibRef libRef = this.incrLibRefCount(l, string);
            if (DEBUG || bl) {
                String string2 = String.valueOf(Long.toHexString(l));
                String string3 = String.valueOf(libRef);
                System.err.println(new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("DynamicLinkerImpl.openLibraryLocal \"").append(string).append("\": 0x").append(string2).append(" -> ").append(string3).append(")").toString());
            }
        } else if (DEBUG || bl) {
            String string4 = this.getLastError();
            System.err.println(new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string4).length()).append("DynamicLinkerImpl.openLibraryLocal \"").append(string).append("\" failed, error: ").append(string4).toString());
        }
        return l;
    }

    protected abstract long openLibraryLocalImpl(String var1) throws SecurityException;

    @Override
    public final long lookupSymbolGlobal(String string) throws SecurityException {
        this.checkAllLinkPermission();
        long l = this.lookupSymbolGlobalImpl(string);
        if (DEBUG_LOOKUP) {
            String string2 = String.valueOf(Long.toHexString(l));
            System.err.println(new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DynamicLinkerImpl.lookupSymbolGlobal(").append(string).append(") -> 0x").append(string2).toString());
        }
        return l;
    }

    protected abstract long lookupSymbolGlobalImpl(String var1) throws SecurityException;

    @Override
    public final long lookupSymbol(long l, String string) throws SecurityException, IllegalArgumentException {
        this.checkLinkPermission(l);
        long l2 = this.lookupSymbolLocalImpl(l, string);
        if (DEBUG_LOOKUP) {
            String string2 = String.valueOf(Long.toHexString(l));
            String string3 = String.valueOf(Long.toHexString(l2));
            System.err.println(new StringBuilder(42 + String.valueOf(string2).length() + String.valueOf(string).length() + String.valueOf(string3).length()).append("DynamicLinkerImpl.lookupSymbol(0x").append(string2).append(", ").append(string).append(") -> 0x").append(string3).toString());
        }
        return l2;
    }

    protected abstract long lookupSymbolLocalImpl(long var1, String var3) throws SecurityException;

    @Override
    public final void closeLibrary(long l, boolean bl) throws SecurityException, IllegalArgumentException {
        LibRef libRef = this.decrLibRefCount(l);
        if (null == libRef) {
            String string = String.valueOf(Long.toHexString(l));
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Library handle 0x").append(string).append(" unknown.").toString());
        }
        this.checkLinkPermission(libRef.getName());
        if (DEBUG || bl) {
            String string = String.valueOf(Long.toHexString(l));
            String string2 = String.valueOf(libRef);
            System.err.println(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DynamicLinkerImpl.closeLibrary(0x").append(string).append(" -> ").append(string2).append(")").toString());
        }
        this.closeLibraryImpl(l);
    }

    protected abstract void closeLibraryImpl(long var1) throws SecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef getLibRef(long l) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            return (LibRef)libHandle2Name.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef incrLibRefCount(long l, String string) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            LibRef libRef = this.getLibRef(l);
            if (null == libRef) {
                libRef = new LibRef(string);
                libHandle2Name.put(l, libRef);
            } else {
                libRef.incrRefCount();
            }
            if (DEBUG) {
                String string2 = String.valueOf(Long.toHexString(l));
                String string3 = String.valueOf(libRef);
                int n = libHandle2Name.size();
                System.err.println(new StringBuilder(65 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("DynamicLinkerImpl.incrLibRefCount 0x").append(string2).append(" -> ").append(string3).append(", libs loaded ").append(n).toString());
            }
            return libRef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef decrLibRefCount(long l) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            LibRef libRef = this.getLibRef(l);
            if (null != libRef && 0 == libRef.decrRefCount()) {
                libHandle2Name.remove(l);
            }
            if (DEBUG) {
                String string = String.valueOf(Long.toHexString(l));
                String string2 = String.valueOf(libRef);
                int n = libHandle2Name.size();
                System.err.println(new StringBuilder(65 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DynamicLinkerImpl.decrLibRefCount 0x").append(string).append(" -> ").append(string2).append(", libs loaded ").append(n).toString());
            }
            return libRef;
        }
    }

    static final class LibRef {
        private final String name;
        private int refCount;

        LibRef(String string) {
            this.name = string;
            this.refCount = 1;
        }

        final int incrRefCount() {
            return ++this.refCount;
        }

        final int decrRefCount() {
            return --this.refCount;
        }

        final int getRefCount() {
            return this.refCount;
        }

        final String getName() {
            return this.name;
        }

        public final String toString() {
            String string = this.name;
            int n = this.refCount;
            return new StringBuilder(30 + String.valueOf(string).length()).append("LibRef[").append(string).append(", refCount ").append(n).append("]").toString();
        }
    }
}

