/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.os.Platform;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jogamp.common.os.elf.Ehdr_p2;
import jogamp.common.os.elf.ElfHeaderPart1;
import jogamp.common.os.elf.IOUtils;
import jogamp.common.os.elf.Section;
import jogamp.common.os.elf.SectionArmAttributes;
import jogamp.common.os.elf.SectionHeader;

public class ElfHeaderPart2 {
    public static final int EF_ARM_ABIMASK = -16777216;
    public static final int EF_ARM_ABISHIFT = 24;
    public static final int EF_ARM_ABI5 = 0x5000000;
    public static final int EF_ARM_BE8 = 0x800000;
    public static final int EF_ARM_GCCMASK = 0x400FFF;
    public static final int EF_ARM_ABI_FLOAT_HARD = 1024;
    public static final int EF_ARM_ABI_FLOAT_SOFT = 512;
    public final ElfHeaderPart1 eh1;
    public final Ehdr_p2 raw;
    public final String cpuName;
    public final Platform.CPUType cpuType;
    public final Platform.ABIType abiType;
    public final SectionHeader[] sht;

    public static ElfHeaderPart2 read(ElfHeaderPart1 elfHeaderPart1, RandomAccessFile randomAccessFile) throws IOException, IllegalArgumentException {
        return new ElfHeaderPart2(elfHeaderPart1, randomAccessFile);
    }

    ElfHeaderPart2(ElfHeaderPart1 elfHeaderPart1, RandomAccessFile randomAccessFile) throws IllegalArgumentException, IOException {
        this.eh1 = elfHeaderPart1;
        Object object = new byte[Ehdr_p2.size(elfHeaderPart1.machDesc.ordinal())];
        IOUtils.readBytes(randomAccessFile, (byte[])object, 0, ((byte[])object).length);
        Object object2 = ByteBuffer.wrap((byte[])object, 0, ((byte[])object).length);
        this.raw = Ehdr_p2.create(elfHeaderPart1.machDesc.ordinal(), (ByteBuffer)object2);
        this.sht = this.readSectionHeaderTable(randomAccessFile);
        if (Platform.CPUFamily.ARM == elfHeaderPart1.cpuType.family && elfHeaderPart1.cpuType.is32Bit) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            object = null;
            object2 = null;
            boolean bl = false;
            SectionHeader sectionHeader = this.getSectionHeader(0x70000003);
            if (ElfHeaderPart1.DEBUG) {
                object6 = String.valueOf(sectionHeader);
                System.err.println(new StringBuilder(39 + String.valueOf(object6).length()).append("ELF-2: Got ARM Attribs Section Header: ").append((String)object6).toString());
            }
            if (null != sectionHeader) {
                object6 = (SectionArmAttributes)sectionHeader.readSection(randomAccessFile);
                if (ElfHeaderPart1.DEBUG) {
                    object5 = String.valueOf(object6);
                    System.err.println(new StringBuilder(39 + String.valueOf(object5).length()).append("ELF-2: Got ARM Attribs Section Block : ").append((String)object5).toString());
                }
                if (null != (object5 = ((SectionArmAttributes)object6).get(SectionArmAttributes.Tag.CPU_name)) && ((SectionArmAttributes.Attribute)object5).isNTBS()) {
                    object = ((SectionArmAttributes.Attribute)object5).getNTBS();
                }
                if (null != (object4 = ((SectionArmAttributes)object6).get(SectionArmAttributes.Tag.CPU_raw_name)) && ((SectionArmAttributes.Attribute)object4).isNTBS()) {
                    object2 = ((SectionArmAttributes.Attribute)object4).getNTBS();
                }
                if (null != (object3 = ((SectionArmAttributes)object6).get(SectionArmAttributes.Tag.ABI_VFP_args))) {
                    bl = SectionArmAttributes.abiVFPArgsAcceptsVFPVariant(((SectionArmAttributes.Attribute)object3).getULEB128());
                }
            }
            if (null == (object5 = ElfHeaderPart2.queryCPUTypeSafe((String)(object6 = null != object && ((String)object).length() > 0 ? ((String)object).toLowerCase().replace(' ', '-') : (null != object2 && ((String)object2).length() > 0 ? ((String)object2).toLowerCase().replace(' ', '-') : elfHeaderPart1.cpuName))))) {
                String string = String.valueOf(object6);
                object6 = string.length() != 0 ? "arm-".concat(string) : new String("arm-");
                object5 = ElfHeaderPart2.queryCPUTypeSafe((String)object6);
                if (null == object5 && null == (object5 = ElfHeaderPart2.queryCPUTypeSafe((String)(object6 = elfHeaderPart1.cpuName)))) {
                    object4 = object6;
                    object3 = String.valueOf(elfHeaderPart1);
                    throw new InternalError(new StringBuilder(7 + String.valueOf(object4).length() + String.valueOf(object3).length()).append("XXX: ").append((String)object4).append(", ").append((String)object3).toString());
                }
            }
            this.cpuName = object6;
            this.cpuType = object5;
            if (ElfHeaderPart1.DEBUG) {
                object4 = object6;
                object3 = object;
                Object object7 = object2;
                String string = this.cpuName;
                String string2 = String.valueOf((Object)this.cpuType);
                boolean bl2 = bl;
                System.err.println(new StringBuilder(94 + String.valueOf(object4).length() + String.valueOf(object3).length() + String.valueOf(object7).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("ELF-2: abiARM cpuName ").append((String)object4).append("[armCpuName ").append((String)object3).append(", armCpuRawName ").append((String)object7).append("] -> ").append(string).append(" -> ").append(string2).append(", abiVFPArgsAcceptsVFPVariant ").append(bl2).toString());
            }
            this.abiType = this.cpuType.is32Bit ? (bl ? Platform.ABIType.EABI_GNU_ARMHF : Platform.ABIType.EABI_GNU_ARMEL) : elfHeaderPart1.abiType;
        } else {
            this.cpuName = elfHeaderPart1.cpuName;
            this.cpuType = elfHeaderPart1.cpuType;
            this.abiType = elfHeaderPart1.abiType;
        }
        if (ElfHeaderPart1.DEBUG) {
            object = this.cpuName;
            object2 = String.valueOf((Object)this.cpuType);
            String string = String.valueOf((Object)this.abiType);
            System.err.println(new StringBuilder(21 + String.valueOf(object).length() + String.valueOf(object2).length() + String.valueOf(string).length()).append("ELF-2: cpuName ").append((String)object).append(" -> ").append((String)object2).append(", ").append(string).toString());
        }
    }

    private static Platform.CPUType queryCPUTypeSafe(String string) {
        Platform.CPUType cPUType;
        block2: {
            cPUType = null;
            try {
                cPUType = Platform.CPUType.query(string);
            }
            catch (Throwable throwable) {
                if (!ElfHeaderPart1.DEBUG) break block2;
                String string2 = String.valueOf(throwable.getMessage());
                System.err.println(new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ELF-2: queryCPUTypeSafe(").append(string).append("): ").append(string2).toString());
            }
        }
        return cPUType;
    }

    public final short getSize() {
        return this.raw.getE_ehsize();
    }

    public final int getFlags() {
        return this.raw.getE_flags();
    }

    public byte getArmABI() {
        return (byte)((0xFF000000 & this.raw.getE_flags()) >> 24 & 0xFF);
    }

    public int getArmLegacyGCCFlags() {
        int n = this.raw.getE_flags();
        return 0 != (0xFF000000 & n) ? 0x400FFF & n : 0;
    }

    public byte getArmFloatMode() {
        int n = this.raw.getE_flags();
        if (0 != (0xFF000000 & n)) {
            if ((0x400 & n) != 0) {
                return 2;
            }
            if ((0x200 & n) != 0) {
                return 1;
            }
        }
        return 0;
    }

    public final SectionHeader getSectionHeader(int n) {
        for (int i = 0; i < this.sht.length; ++i) {
            SectionHeader sectionHeader = this.sht[i];
            if (sectionHeader.getType() != n) continue;
            return sectionHeader;
        }
        return null;
    }

    public final SectionHeader getSectionHeader(String string) {
        for (int i = 0; i < this.sht.length; ++i) {
            SectionHeader sectionHeader = this.sht[i];
            if (!sectionHeader.getName().equals(string)) continue;
            return sectionHeader;
        }
        return null;
    }

    public final String toString() {
        String string;
        byte by = this.getArmABI();
        if (0 != by) {
            int n = this.getArmLegacyGCCFlags();
            byte by2 = this.getArmFloatMode();
            string = new StringBuilder(52).append(", arm[abi ").append(by).append(", lGCC ").append(n).append(", float ").append(by2).append("]").toString();
        } else {
            string = "";
        }
        String string2 = String.valueOf((Object)this.cpuType);
        String string3 = String.valueOf((Object)this.abiType);
        String string4 = IOUtils.toHexString(this.getFlags());
        int n = this.sht.length;
        return new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string).length()).append("ELF-2[").append(string2).append(", ").append(string3).append(", flags[").append(string4).append(string).append("], sh-num ").append(n).append("]").toString();
    }

    final SectionHeader[] readSectionHeaderTable(RandomAccessFile randomAccessFile) throws IOException, IllegalArgumentException {
        int n;
        SectionHeader[] sectionHeaderArray;
        int n2;
        Object object;
        Object object2;
        long l = this.raw.getE_shoff();
        if (0L == l) {
            return new SectionHeader[0];
        }
        IOUtils.seek(randomAccessFile, l);
        short s = this.raw.getE_shstrndx();
        short s2 = this.raw.getE_shentsize();
        if (0 == this.raw.getE_shnum()) {
            object2 = new byte[s2];
            IOUtils.readBytes(randomAccessFile, (byte[])object2, 0, s2);
            object = new SectionHeader(this, (byte[])object2, 0, s2, 0);
            n2 = (int)((SectionHeader)object).raw.getSh_size();
            if (0 >= n2) {
                throw new IllegalArgumentException("EHdr sh_num == 0 and 1st SHdr size == 0");
            }
            sectionHeaderArray = new SectionHeader[n2];
            sectionHeaderArray[0] = object;
            n = 1;
        } else {
            n2 = this.raw.getE_shnum();
            sectionHeaderArray = new SectionHeader[n2];
            n = 0;
        }
        while (n < n2) {
            object2 = new byte[s2];
            IOUtils.readBytes(randomAccessFile, (byte[])object2, 0, s2);
            sectionHeaderArray[n] = new SectionHeader(this, (byte[])object2, 0, s2, n);
            ++n;
        }
        if (0 != s) {
            if (IOUtils.shortToInt((short)-256) <= s) {
                object2 = String.valueOf("TODO strndx: -256 < ");
                throw new InternalError(new StringBuilder(11 + String.valueOf(object2).length()).append((String)object2).append(s).toString());
            }
            object2 = sectionHeaderArray[s];
            if (3 != ((SectionHeader)object2).getType()) {
                int n3 = ((SectionHeader)object2).raw.getSh_type();
                throw new IllegalArgumentException(new StringBuilder(52).append("Ref. string Shdr[").append(s).append("] is of type ").append(n3).toString());
            }
            object = ((SectionHeader)object2).readSection(randomAccessFile);
            for (n = 0; n < n2; ++n) {
                sectionHeaderArray[n].initName((Section)object, sectionHeaderArray[n].raw.getSh_name());
            }
        }
        return sectionHeaderArray;
    }
}

