/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManagerBase;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.HotSwapScriptManager;
import org.jetbrains.v8.V8CallFrame;
import org.jetbrains.v8.V8Script;
import org.jetbrains.v8.V8ScriptKt;
import org.jetbrains.v8.V8ScriptLiveChangeResult;
import org.jetbrains.v8.V8ScriptManager;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.liveEditProtocol.LiveEditResult;
import org.jetbrains.v8.liveEditProtocol.ScriptLiveChangeResult;
import org.jetbrains.v8.protocol.ChangeLiveBody;
import org.jetbrains.v8.protocol.ChangeLiveMessage;
import org.jetbrains.v8.protocol.EvalLocation;
import org.jetbrains.v8.protocol.GetScriptsResult;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.ScriptDescriptor;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.ScriptsMessageKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.protocol.V8ProtocolUtilKt;
import org.jetbrains.v8.value.FunctionReference;
import org.jetbrains.v8.value.V8Function;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u001a\u001a\n \t*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u00020\f2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150$H\u0016J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170&2\u0006\u0010'\u001a\u00020\u001cJ\u0012\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010)\u001a\u00020*H\u0016J\u001e\u0010(\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00170\u00170&2\u0006\u0010+\u001a\u00020,H\u0016J#\u0010-\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010!0!0&\u00a2\u0006\u0002\b\n2\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0006\u0010.\u001a\u00020\fJ\u001b\u0010/\u001a\u000f\u0012\u0006\u0012\u0004\u0018\u0001000&\u00a2\u0006\u0002\b\n2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u001cJ\u001a\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0002J&\u00106\u001a\b\u0012\u0004\u0012\u0002070&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0015H\u0016R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00020\u00020\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/v8/V8ScriptManager;", "Lorg/jetbrains/debugger/ScriptManagerBase;", "Lorg/jetbrains/v8/V8Script;", "Lorg/jetbrains/v8/HotSwapScriptManager;", "vm", "Lorg/jetbrains/v8/V8Vm;", "(Lorg/jetbrains/v8/V8Vm;)V", "idToScript", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addScript", "", "descriptor", "Lorg/jetbrains/v8/protocol/ScriptDescriptor;", "scriptBody", "Lorg/jetbrains/v8/protocol/ScriptHandle;", "refs", "", "Lorg/jetbrains/v8/protocol/SomeHandle;", "containsScript", "", "script", "Lorg/jetbrains/debugger/Script;", "createScript", "rawScriptHandle", "findScript", "id", "", "findScriptByUrl", "url", "Lcom/intellij/util/Url;", "rawUrl", "", "forEachScript", "scriptProcessor", "Lkotlin/Function1;", "getOrLoadScript", "Lorg/jetbrains/concurrency/Promise;", "scriptId", "getScript", "frame", "Lorg/jetbrains/debugger/CallFrame;", "function", "Lorg/jetbrains/debugger/values/FunctionValue;", "loadScriptSource", "reset", "resolveScripts", "", "unresolvedScriptIds", "Lgnu/trove/TIntHashSet;", "scriptCollected", "setSourceCode", "body", "setSourceOnRemote", "Lorg/jetbrains/v8/liveEditProtocol/ScriptLiveChangeResult;", "newSource", "", "preview", "v8-backend"})
public final class V8ScriptManager
extends ScriptManagerBase<V8Script>
implements HotSwapScriptManager {
    private final ConcurrentIntObjectMap<V8Script> idToScript;
    private final V8Vm vm;

    @NotNull
    protected Promise<String> loadScriptSource(@NotNull V8Script script) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)script), (String)"script");
        return this.vm.getCommandProcessor().send((Request)ScriptsMessageKt.ScriptsMessage$default(true, 12, script.getId(), null, null, 24, null)).then((Function)loadScriptSource.1.INSTANCE);
    }

    @Override
    @NotNull
    public Promise<ScriptLiveChangeResult> setSourceOnRemote(@NotNull Script script, @NotNull CharSequence newSource, boolean preview) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)newSource, (String)"newSource");
        Promise promise2 = this.vm.getCommandProcessor().send((Request)new ChangeLiveMessage(((V8Script)script).getId(), newSource, preview)).then(new Function<T, SUB_RESULT>(this, preview, script){
            final /* synthetic */ V8ScriptManager this$0;
            final /* synthetic */ boolean $preview;
            final /* synthetic */ Script $script;

            @NotNull
            public final setSourceOnRemote.1 fun(ChangeLiveBody it) {
                boolean bl;
                LiveEditResult resultDescription = it.getResultDescription();
                if (!this.$preview) {
                    this.this$0.setSource((ScriptBase)this.$script, null);
                    V8ScriptManager.access$getVm$p(this.this$0).getDebugListener().scriptContentChanged(this.$script);
                }
                boolean stepInRecommended = it.stepin_recommended();
                boolean bl2 = bl = resultDescription != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                LiveEditResult liveEditResult = resultDescription;
                Intrinsics.checkExpressionValueIsNotNull((Object)liveEditResult, (String)"resultDescription");
                return new V8ScriptLiveChangeResult(this, stepInRecommended, resultDescription, liveEditResult){
                    final /* synthetic */ setSourceOnRemote.1 this$0;
                    final /* synthetic */ boolean $stepInRecommended;
                    final /* synthetic */ LiveEditResult $resultDescription;

                    public void doRecommended() {
                        if (this.$stepInRecommended) {
                            if (V8ScriptManager.access$getVm$p(this.this$0.this$0).getSuspendContextManager().getContext() != null) {
                                V8ScriptManager.access$getVm$p(this.this$0.this$0).getSuspendContextManager().continueVm(StepAction.IN, 0);
                            }
                        } else if (this.getDescription().stack_modified()) {
                            V8ScriptManager.access$getVm$p(this.this$0.this$0).getSuspendContextManager().startRebuildCurrentContext$v8_backend();
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$stepInRecommended = $captured_local_variable$1;
                        this.$resultDescription = $captured_local_variable$2;
                        super($super_call_param$3);
                    }
                };
            }
            {
                this.this$0 = v8ScriptManager;
                this.$preview = bl;
                this.$script = script;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"vm.commandProcessor.send\u2026      }\n        }\n      }");
        return promise2;
    }

    public void forEachScript(@NotNull Function1<? super Script, Boolean> scriptProcessor) {
        Intrinsics.checkParameterIsNotNull(scriptProcessor, (String)"scriptProcessor");
        Enumeration scripts = this.idToScript.elements();
        while (scripts.hasMoreElements()) {
            Object e = scripts.nextElement();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"scripts.nextElement()");
            if (((Boolean)scriptProcessor.invoke(e)).booleanValue()) continue;
            return;
        }
    }

    @NotNull
    public final Promise resolveScripts(@NotNull TIntHashSet unresolvedScriptIds) {
        Intrinsics.checkParameterIsNotNull((Object)unresolvedScriptIds, (String)"unresolvedScriptIds");
        return this.vm.getCommandProcessor().send((Request)ScriptsMessageKt.ScriptsMessage$default(false, 0, 0, null, unresolvedScriptIds, 15, null)).then(new Function<T, SUB_RESULT>(this){
            final /* synthetic */ V8ScriptManager this$0;

            @Nullable
            public final Void fun(List<? extends ScriptHandle> it) {
                for (ScriptHandle scriptHandle : it) {
                    this.this$0.addScript(scriptHandle, ((IncomingMessage)V8ScriptManager.access$getVm$p(this.this$0).getCommandProcessor().lastSuccessResponse().getBase()).refs());
                }
                return null;
            }
            {
                this.this$0 = v8ScriptManager;
            }
        });
    }

    @NotNull
    public Promise<Script> getScript(@NotNull FunctionValue function) {
        Promise promise2;
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (function instanceof FunctionReference) {
            Promise promise3 = function.resolve().thenAsync(new Function<T, Promise<SUB_RESULT>>(this){
                final /* synthetic */ V8ScriptManager this$0;

                @NotNull
                public final Promise<Script> fun(FunctionValue it) {
                    FunctionValue functionValue = it;
                    if (functionValue == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.v8.value.FunctionReference");
                    }
                    return this.this$0.getOrLoadScript(((FunctionReference)functionValue).getScriptId());
                }
                {
                    this.this$0 = v8ScriptManager;
                }
            });
            promise2 = promise3;
            Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"function.resolve()\n     \u2026ionReference).scriptId) }");
        } else {
            promise2 = this.getOrLoadScript(((V8Function)function).getScriptId());
        }
        return promise2;
    }

    @NotNull
    public final Promise<Script> getOrLoadScript(int scriptId) {
        V8Script script = this.findScript(scriptId);
        if (script != null) {
            return Promises.resolvedPromise((Object)((Object)script));
        }
        if (this.vm.getHasJbDebuggerSupport()) {
            Promise promise2 = this.vm.getCommandProcessor().send((Request)ProtocolKt.GetScripts(new int[]{scriptId})).then(new Function<T, SUB_RESULT>(this, scriptId){
                final /* synthetic */ V8ScriptManager this$0;
                final /* synthetic */ int $scriptId;

                public final V8Script fun(GetScriptsResult it) {
                    Iterable $receiver$iv = it.scripts();
                    for (T element$iv : $receiver$iv) {
                        ScriptDescriptor it2 = (ScriptDescriptor)element$iv;
                        this.this$0.addScript(it2);
                    }
                    return this.this$0.findScript(this.$scriptId);
                }
                {
                    this.this$0 = v8ScriptManager;
                    this.$scriptId = n;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"vm.commandProcessor.send\u2026cript(scriptId)\n        }");
            return promise2;
        }
        TIntHashSet tIntHashSet = null;
        int[] nArray = null;
        int n = 12;
        int n2 = scriptId;
        Promise promise3 = this.vm.getCommandProcessor().send((Request)ScriptsMessageKt.ScriptsMessage$default(false, n, n2, nArray, tIntHashSet, 25, null)).then(new Function<T, SUB_RESULT>(this, scriptId){
            final /* synthetic */ V8ScriptManager this$0;
            final /* synthetic */ int $scriptId;

            public final V8Script fun(List<? extends ScriptHandle> it) {
                for (ScriptHandle scriptHandle : it) {
                    this.this$0.addScript(scriptHandle, ((IncomingMessage)V8ScriptManager.access$getVm$p(this.this$0).getCommandProcessor().lastSuccessResponse().getBase()).refs());
                }
                return this.this$0.findScript(this.$scriptId);
            }
            {
                this.this$0 = v8ScriptManager;
                this.$scriptId = n;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"vm.commandProcessor.send\u2026cript(scriptId)\n        }");
        return promise3;
    }

    @Nullable
    public Script getScript(@NotNull CallFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return ((V8CallFrame)frame).getScript();
    }

    public final void addScript(@NotNull ScriptHandle scriptBody, @Nullable List<? extends SomeHandle> refs) {
        Intrinsics.checkParameterIsNotNull((Object)scriptBody, (String)"scriptBody");
        V8Script script = (V8Script)((Object)this.idToScript.get(scriptBody.getId()));
        if (script == null) {
            List<? extends SomeHandle> list = refs;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            V8Script v8Script = this.createScript(scriptBody, list);
            if (v8Script == null) {
                return;
            }
            script = v8Script;
            if (this.idToScript.putIfAbsent(script.getId(), (Object)script) != null) {
                return;
            }
        }
        if (scriptBody.getSource() != null) {
            this.setSourceCode(scriptBody, script);
        }
        this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)script, null);
    }

    public final void addScript(@Nullable ScriptDescriptor descriptor) {
        if (descriptor == null || descriptor.getId() == -1) {
            return;
        }
        V8Script script = (V8Script)((Object)this.idToScript.get(descriptor.getId()));
        if (script == null) {
            int n = descriptor.getId();
            Script.Type type = V8ProtocolUtilKt.getScriptType(descriptor.getType());
            if (type == null) {
                Intrinsics.throwNpe();
            }
            if (this.idToScript.putIfAbsent((script = V8ScriptKt.V8Script(n, type, descriptor.path(), descriptor.getStartLine(), descriptor.getStartColumn(), descriptor.getEndLine())).getId(), (Object)script) != null) {
                return;
            }
        }
        this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)script, descriptor.getSourceMapUrl());
    }

    public final void scriptCollected(int scriptId) {
        V8Script v8Script = (V8Script)((Object)this.idToScript.remove(scriptId));
        if (v8Script == null) {
            return;
        }
        V8Script script = v8Script;
        this.vm.getDebugListener().scriptRemoved((Script)script);
    }

    private final void setSourceCode(ScriptHandle body, V8Script script) {
        String source = body.getSource();
        if (source != null && script != null) {
            this.setSource(script, source);
        }
    }

    public boolean containsScript(@NotNull Script script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return script instanceof V8Script && this.idToScript.containsKey(((V8Script)script).getId());
    }

    public final V8Script findScript(int id) {
        return (V8Script)((Object)this.idToScript.get(id));
    }

    public final void reset() {
        this.idToScript.clear();
    }

    private final V8Script createScript(ScriptHandle rawScriptHandle, List<? extends SomeHandle> refs) {
        String name;
        int id;
        Script.Type type;
        ScriptHandle scriptHandle;
        block7: {
            EvalLocation evalLocation;
            ScriptHandle scriptHandle2 = V8ProtocolUtilKt.validScript(rawScriptHandle, refs);
            if (scriptHandle2 == null) {
                return null;
            }
            scriptHandle = scriptHandle2;
            Script.Type type2 = V8ProtocolUtilKt.getScriptType(scriptHandle.getScriptType());
            if (type2 == null) {
                return null;
            }
            type = type2;
            id = scriptHandle.getId();
            if (id == -1) {
                throw (Throwable)new RuntimeException("Null scriptHandle id");
            }
            name = scriptHandle.getName();
            EvalLocation evalLocation2 = scriptHandle.getEvalFromLocation();
            if (evalLocation2 == null) break block7;
            EvalLocation location = evalLocation = evalLocation2;
            if (name == null) {
                Object object = scriptHandle.getEvalFromScript();
                if (object != null && (object = object.asSomeRef()) != null) {
                    int n;
                    int it = n = object.getRef();
                    for (SomeHandle someHandle : refs) {
                        if (someHandle.handle() != it) continue;
                        V8Script v8Script = (V8Script)((Object)this.idToScript.get(someHandle.asScriptHandle().getId()));
                        if (v8Script != null) {
                            V8Script v8Script2;
                            V8Script it2 = v8Script2 = v8Script;
                            return new V8Script(id, type, it2.getUrl(), location.getLine(), location.getColumn(), location.getLine() + scriptHandle.getLineCount());
                        }
                        break;
                    }
                }
            }
        }
        return V8ScriptKt.V8Script(id, type, name, scriptHandle.getLineOffset(), scriptHandle.getColumnOffset(), scriptHandle.getLineOffset() + scriptHandle.getLineCount());
    }

    @Nullable
    public Script findScriptByUrl(@NotNull String rawUrl) {
        Intrinsics.checkParameterIsNotNull((Object)rawUrl, (String)"rawUrl");
        Url url = Urls.newLocalFileUrl((String)rawUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"Urls.newLocalFileUrl(rawUrl)");
        return this.findScriptByUrl(url);
    }

    @Nullable
    public Script findScriptByUrl(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Enumeration scripts = this.idToScript.elements();
        while (scripts.hasMoreElements()) {
            V8Script script = (V8Script)((Object)scripts.nextElement());
            if (!url.equalsIgnoreParameters(script.getUrl())) continue;
            return (Script)script;
        }
        return null;
    }

    public V8ScriptManager(@NotNull V8Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.idToScript = ContainerUtil.createConcurrentIntObjectMap();
    }

    @NotNull
    public static final /* synthetic */ V8Vm access$getVm$p(V8ScriptManager $this) {
        return $this.vm;
    }
}

