/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.network.LoadingFailedEventData;
import org.jetbrains.wip.protocol.network.NetworkKt;
import org.jetbrains.wip.protocol.network.RequestWillBeSentEventData;
import org.jetbrains.wip.protocol.network.ResponseReceivedEventData;
import org.jetbrains.wip.protocol.network.ResponseValue;
import org.jetbrains.wip.protocol.page.FrameDetachedEventData;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;
import org.jetbrains.wip.protocol.page.ResourceType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bR/\u0010\u0006\u001a#\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/wip/WipNetworkManager;", "", "eventMap", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "(Lorg/jetbrains/jsonProtocol/EventMap;)V", "idToRequest", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/wip/RequestInfo;", "Lorg/jetbrains/annotations/NotNull;", "enable", "Lorg/jetbrains/concurrency/Promise;", "", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "getRequest", "requestId", "lengthWithoutParameters", "", "s", "wasRequested", "", "url", "wip-backend"})
public final class WipNetworkManager {
    private final ConcurrentMap<String, RequestInfo> idToRequest;

    @NotNull
    public final Promise<Unit> enable(@NotNull WipCommandProcessor commandProcessor2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)commandProcessor2), (String)"commandProcessor");
        return commandProcessor2.send((Request)NetworkKt.Enable$default(0, 0, 3, null));
    }

    @Nullable
    public final RequestInfo getRequest(@Nullable String requestId) {
        CharSequence charSequence = requestId;
        return charSequence == null || charSequence.length() == 0 ? null : (RequestInfo)this.idToRequest.get(requestId);
    }

    private final int lengthWithoutParameters(String s) {
        int index = UriUtil.PARAM_CHAR_MATCHER.indexIn((CharSequence)s);
        return index < 0 ? s.length() : index;
    }

    public final boolean wasRequested(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        int length = this.lengthWithoutParameters(url);
        for (RequestInfo request : this.idToRequest.values()) {
            String oUrl;
            if (!Intrinsics.areEqual((Object)((Object)request.getResourceType()), (Object)((Object)ResourceType.SCRIPT)) && !Intrinsics.areEqual((Object)((Object)request.getResourceType()), (Object)((Object)ResourceType.XHR)) || length != this.lengthWithoutParameters(oUrl = request.getValue().url()) || !StringsKt.regionMatches$default((String)url, (int)0, (String)oUrl, (int)0, (int)length, (boolean)false, (int)16, null)) continue;
            return true;
        }
        return false;
    }

    public WipNetworkManager(@NotNull EventMap<ProtocolResponseReader> eventMap) {
        Intrinsics.checkParameterIsNotNull(eventMap, (String)"eventMap");
        this.idToRequest = ContainerUtil.newConcurrentMap();
        eventMap.add((EventType)RequestWillBeSentEventData.TYPE, (Function1)new Function1<RequestWillBeSentEventData, Unit>(){

            public final void invoke(@NotNull RequestWillBeSentEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                idToRequest.put(it.requestId(), new RequestInfo(it.frameId(), it.request(), it.initiator(), it.loaderId()));
            }
        });
        eventMap.add((EventType)LoadingFailedEventData.TYPE, (Function1)new Function1<LoadingFailedEventData, Unit>(){

            public final void invoke(@NotNull LoadingFailedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                RequestInfo request = (RequestInfo)idToRequest.get(it.requestId());
                if (request != null) {
                    request.setFailed$wip_backend(true);
                    request.setFailDescription$wip_backend(it.errorText());
                }
            }
        });
        eventMap.add((EventType)ResponseReceivedEventData.TYPE, (Function1)new Function1<ResponseReceivedEventData, Unit>(){

            public final void invoke(@NotNull ResponseReceivedEventData it) {
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ResponseValue response = it.response();
                if (response.headers().isEmpty() || (charSequence = (CharSequence)response.mimeType()) == null || charSequence.length() == 0 || response.getStatus() == 0.0) {
                    return;
                }
                RequestInfo requestInfo = (RequestInfo)idToRequest.get(it.requestId());
                if (requestInfo == null) {
                    return;
                }
                RequestInfo request = requestInfo;
                request.setStatusCode$wip_backend((int)response.getStatus());
                request.setStatusText$wip_backend(response.statusText());
                request.setResourceType$wip_backend(it.type());
            }
        });
        eventMap.add((EventType)FrameDetachedEventData.TYPE, (Function1)new Function1<FrameDetachedEventData, Unit>(){

            public final void invoke(@NotNull FrameDetachedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String frameId = it.frameId();
                Iterator iterator = idToRequest.values().iterator();
                while (iterator.hasNext()) {
                    RequestInfo item = (RequestInfo)iterator.next();
                    if (!Intrinsics.areEqual((Object)item.getFrameId(), (Object)frameId)) continue;
                    iterator.remove();
                }
            }
        });
        eventMap.add((EventType)FrameNavigatedEventData.TYPE, (Function1)new Function1<FrameNavigatedEventData, Unit>(){

            public final void invoke(@NotNull FrameNavigatedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String frameId = it.frame().id();
                String loaderId = it.frame().loaderId();
                Iterator iterator = idToRequest.values().iterator();
                while (iterator.hasNext()) {
                    RequestInfo item = (RequestInfo)iterator.next();
                    if (!Intrinsics.areEqual((Object)item.getFrameId(), (Object)frameId) || !(Intrinsics.areEqual((Object)item.getLoaderId(), (Object)loaderId) ^ true)) continue;
                    iterator.remove();
                }
            }
        });
    }
}

