/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.facet;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.struts.StrutsManager;
import com.intellij.util.descriptors.ConfigFile;
import org.jetbrains.annotations.Nullable;

public class StrutsSupportModel {
    private boolean struts13;
    private boolean tiles;
    private boolean strutsLib;
    private boolean validation;
    private boolean strutsEl;
    private boolean strutsTaglib;
    private boolean strutsFaces;
    private boolean scripting;
    private boolean extras;
    private boolean jstl;

    private StrutsSupportModel() {
    }

    public static StrutsSupportModel checkStrutsSupport(@Nullable WebFacet webFacet) {
        StrutsSupportModel support = new StrutsSupportModel();
        if (webFacet == null) {
            return support;
        }
        ConfigFile desc = webFacet.getWebXmlDescriptor();
        if (desc == null) {
            return support;
        }
        support.tiles = StrutsManager.getInstance().getAllTilesModels(webFacet.getModule()).size() > 0;
        support.validation = StrutsManager.getInstance().getAllValidationModels(webFacet.getModule()).size() > 0;
        Project project = webFacet.getModule().getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)webFacet.getModule());
        support.strutsLib = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.action.Action", scope) != null;
        support.struts13 = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.chain.ComposableRequestProcessor", scope) != null;
        support.jstl = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("javax.servlet.jsp.jstl.core.ConditionalTagSupport", scope) != null;
        support.strutsEl = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.strutsel.taglib.html.ELBaseTag", scope) != null;
        support.strutsTaglib = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.taglib.html.BaseTag", scope) != null;
        support.extras = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.plugins.ModuleConfigVerifier", scope) != null;
        support.scripting = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.scripting.ScriptAction", scope) != null;
        support.strutsFaces = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.faces.application.FacesRequestProcessor", scope) != null;
        return support;
    }

    public boolean isTiles() {
        return this.tiles;
    }

    public boolean isStrutsLib() {
        return this.strutsLib;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public boolean isStrutsEl() {
        return this.strutsEl;
    }

    public boolean isStrutsTaglib() {
        return this.strutsTaglib;
    }

    public boolean isStrutsFaces() {
        return this.strutsFaces;
    }

    public boolean isScripting() {
        return this.scripting;
    }

    public boolean isExtras() {
        return this.extras;
    }

    public boolean isJstl() {
        return this.jstl;
    }

    public boolean isStruts13() {
        return this.struts13;
    }
}

