/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference;

import com.intellij.jsp.impl.TldTagDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlReferenceUtil {
    @NonNls
    private static final String ROOT = "root";

    private XmlReferenceUtil() {
    }

    @Nullable
    public static XmlTag findEnclosingTag(@NotNull XmlTag tag, @NotNull @NonNls String enclosingTagName) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/struts/inplace/reference/XmlReferenceUtil", "findEnclosingTag"));
        }
        if (enclosingTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingTagName", "com/intellij/struts/inplace/reference/XmlReferenceUtil", "findEnclosingTag"));
        }
        return XmlReferenceUtil.findEnclosingTag(tag, enclosingTagName, tag.getNamespace(), null);
    }

    @Nullable
    public static XmlTag findEnclosingTagByClass(@NotNull XmlTag tag, @NotNull @NonNls String enclosingTagName, @NotNull @NonNls String tagClassName) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/struts/inplace/reference/XmlReferenceUtil", "findEnclosingTagByClass"));
        }
        if (enclosingTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingTagName", "com/intellij/struts/inplace/reference/XmlReferenceUtil", "findEnclosingTagByClass"));
        }
        if (tagClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagClassName", "com/intellij/struts/inplace/reference/XmlReferenceUtil", "findEnclosingTagByClass"));
        }
        Project project = tag.getProject();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(tagClassName, GlobalSearchScope.allScope((Project)project));
        return XmlReferenceUtil.findEnclosingTag(tag, enclosingTagName, tag.getNamespace(), psiClass);
    }

    @Nullable
    protected static XmlTag findEnclosingTag(@NotNull XmlTag tag, @NotNull String enclosingTagName, @Nullable String ns, @Nullable PsiClass clazz) {
        PsiElement parent;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/struts/inplace/reference/XmlReferenceUtil", "findEnclosingTag"));
        }
        if (enclosingTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingTagName", "com/intellij/struts/inplace/reference/XmlReferenceUtil", "findEnclosingTag"));
        }
        String name = tag.getLocalName();
        if (name.equals(ROOT)) {
            return null;
        }
        if (name.equals(enclosingTagName)) {
            Project project;
            PsiClass psiClass;
            String tagClassName;
            XmlElementDescriptor descriptor;
            String namespace;
            if (ns != null && (namespace = tag.getNamespace()).equals(ns)) {
                return tag;
            }
            if (clazz != null && (descriptor = tag.getDescriptor()) instanceof TldTagDescriptor && (tagClassName = ((TldTagDescriptor)descriptor).getTagClass()) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)(psiClass = JavaPsiFacade.getInstance((Project)(project = tag.getProject())).findClass(tagClassName, GlobalSearchScope.allScope((Project)project))), (PsiClass)clazz, (boolean)true)) {
                return tag;
            }
        }
        if (!((parent = tag.getContext()) instanceof XmlTag)) {
            return null;
        }
        return XmlReferenceUtil.findEnclosingTag((XmlTag)parent, enclosingTagName, ns, clazz);
    }
}

