/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.ZonedInfo;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcNativeUtil {
    public static final String PG_TIMESTAMP_TZ_NAME = "timestamptz";
    private static final String PG_TIME_TZ_NAME = "timetz";
    private static final String ESCAPE_SYMBOL = "#";

    public static void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull Rdbms dbms, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setStatementParameter"));
        }
        if (dbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setStatementParameter"));
        }
        if (columnInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnInfo", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setStatementParameter"));
        }
        String typeName = columnInfo.getTypeName();
        int type = columnInfo.getType();
        String javaClassName = columnInfo.getJavaClassName();
        if (value == null) {
            statement.setNull(idx, JdbcNativeUtil.isPgUuidColumn(typeName, dbms) ? 1111 : type);
        } else if (value instanceof LobInfo.FileBlobInfo) {
            LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
            statement.setBlob(idx, new FileBlob(info.file));
        } else if (value instanceof LobInfo.FileClobInfo) {
            LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
            statement.setClob(idx, new FileClob(info.file, info.charset));
        } else if (value instanceof LobInfo.BlobInfo) {
            statement.setBytes(idx, ((LobInfo.BlobInfo)value).data);
        } else if (value instanceof LobInfo.ClobInfo) {
            statement.setString(idx, JdbcNativeUtil.escapeSql(((LobInfo.ClobInfo)value).data, needsEscaping, dbms));
        } else if (value instanceof byte[]) {
            statement.setBytes(idx, (byte[])value);
        } else if (dbms == Postgres.RDBMS && type == 2003 && value instanceof Object[]) {
            statement.setArray(idx, StringUtil.replace((String)typeName, (String)"_", (String)""), (Object[])value);
        } else if (dbms == Postgres.RDBMS && (Arrays.asList("bit", "varbit", "tid", "uuid", "money", "interval").contains(typeName) || type == 2003 || type == 2002 || type == 1111 || Object.class.getName().equals(javaClassName))) {
            statement.setObject(idx, value, 1111);
        } else if (dbms == Postgres.RDBMS && type == 2009) {
            statement.setObject(idx, JdbcNativeUtil.escapeSql(value, needsEscaping, dbms), 2009);
        } else if (value instanceof java.util.Date) {
            JdbcNativeUtil.setDate(statement, value, idx, type);
        } else if (dbms == Postgres.RDBMS && JdbcNativeUtil.isZonedColumn(typeName, dbms)) {
            JdbcNativeUtil.setZonedValue(statement, typeName, (ZonedInfo)value, dbms, needsEscaping, idx);
        } else if (type == -5 && value instanceof BigInteger) {
            JdbcNativeUtil.setBigInteger(dbms, statement, (BigInteger)value, idx);
        } else {
            statement.setObject(idx, JdbcNativeUtil.escapeSql(value, needsEscaping, dbms));
        }
    }

    private static void setDate(@NotNull RemotePreparedStatement statement, @NotNull Object value, int idx, int type) throws Exception {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setDate"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setDate"));
        }
        long millis = ((java.util.Date)value).getTime();
        if (type == 93) {
            statement.setTimestamp(idx, value instanceof Timestamp ? (Timestamp)value : new Timestamp(millis));
            return;
        }
        if (type == 92) {
            statement.setTime(idx, value instanceof Time ? (Time)value : new Time(millis));
            return;
        }
        statement.setDate(idx, value instanceof Date ? (Date)value : new Date(millis));
    }

    private static void setZonedValue(@NotNull RemotePreparedStatement statement, @NotNull String typeName, @NotNull ZonedInfo value, @NotNull Rdbms dbms, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setZonedValue"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setZonedValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setZonedValue"));
        }
        if (dbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setZonedValue"));
        }
        if (JdbcNativeUtil.isZonedTimestampColumn(typeName, dbms)) {
            statement.setObject(idx, JdbcNativeUtil.escapeSql(value.getStringRepresentation(), needsEscaping, dbms), value.getType());
        } else {
            Time time = (Time)value.getDate();
            statement.setTime(idx, time, value.getCalendar());
        }
    }

    public static <T> T escapeSql(T value, boolean needsEscaping, @NotNull Rdbms rdbms) {
        Object[] objectArray;
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "escapeSql"));
        }
        if (!needsEscaping) {
            return value;
        }
        if (rdbms == Sqlite.RDBMS) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        if (rdbms == Mysql.RDBMS) {
            String[] stringArray = new String[4];
            stringArray[0] = "%";
            stringArray[1] = "_";
            stringArray[2] = "\\";
            objectArray = stringArray;
            stringArray[3] = ESCAPE_SYMBOL;
        } else if (rdbms == Mssql.RDBMS) {
            String[] stringArray = new String[5];
            stringArray[0] = "%";
            stringArray[1] = "_";
            stringArray[2] = "[";
            stringArray[3] = "]";
            objectArray = stringArray;
            stringArray[4] = ESCAPE_SYMBOL;
        } else {
            Object[] objectArray2 = new String[3];
            objectArray2[0] = "%";
            objectArray2[1] = "_";
            objectArray = objectArray2;
            objectArray2[2] = ESCAPE_SYMBOL;
        }
        Object[] unescapedChars = objectArray;
        String[] escapedChars = (String[])ContainerUtil.map2Array((Object[])unescapedChars, String.class, (Function)new Function<String, String>(){

            public String fun(String s) {
                return JdbcNativeUtil.ESCAPE_SYMBOL + s;
            }
        });
        return (T)StringUtil.replace((String)s, (String[])unescapedChars, (String[])escapedChars);
    }

    private static void setBigInteger(@NotNull Rdbms dialect, @NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setBigInteger"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setBigInteger"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "setBigInteger"));
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)dialect.code, (CharSequence)"DB2") || dialect == Sybase.RDBMS || dialect == Mssql.RDBMS) {
            statement.setObject(idx, value.longValue());
            return;
        }
        statement.setObject(idx, value, -5);
    }

    public static boolean isZonedColumn(@NotNull String typeName, @NotNull Rdbms dialect) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedColumn"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedColumn"));
        }
        return JdbcNativeUtil.isZonedTimeColumn(typeName, dialect) || JdbcNativeUtil.isZonedTimestampColumn(typeName, dialect);
    }

    public static boolean isZonedTimestampColumn(@NotNull String typeName, @NotNull Rdbms dialect) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedTimestampColumn"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedTimestampColumn"));
        }
        return dialect == Postgres.RDBMS && PG_TIMESTAMP_TZ_NAME.equals(typeName);
    }

    public static void closeRemoteStatementSafe(@Nullable RemoteStatement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public static Object tryGetString(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "tryGetString"));
        }
        return ReflectionHelper.tryInvokeMethod(o, "getString", null, null);
    }

    public static boolean isZonedTimeColumn(@NotNull String typeName, @NotNull Rdbms dialect) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedTimeColumn"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isZonedTimeColumn"));
        }
        return dialect == Postgres.RDBMS && PG_TIME_TZ_NAME.equals(typeName);
    }

    private static boolean isPgUuidColumn(@NotNull String typeName, @NotNull Rdbms dialect) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isPgUuidColumn"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/remote/jdbc/JdbcNativeUtil", "isPgUuidColumn"));
        }
        return dialect == Postgres.RDBMS && StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"uuid");
    }
}

