/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.ImportQueryGenerator;
import com.intellij.database.remote.dbimport.Query;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import com.intellij.util.ThrowableRunnable;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteBatchPreparedStatementImpl
extends RemotePreparedStatementImpl
implements RemoteBatchPreparedStatement {
    private static final String CHECK_CONNECTION = "Check connection and database settings and try again";
    private static final String ROLLBACK_ERROR = "Can't rollback changes with error records. Check connection and database settings and try again";
    private static final String SAVE_ERROR = "Can't save current transaction state. Check connection and database settings and try again";
    private static final int MAX_LINES_PER_TRANSACTION = 1000;
    private static final int[] EMPTY_INTS = new int[0];
    protected int myBatchSize;
    private final ImportQueryGenerator myGenerator;
    private final RemotePreparedStatement myOneLineStatement;
    private final String myLockQuery;
    private final Connection myConnection;
    private final int myLines;
    private final boolean myUseTransactions;
    private Savepoint myLastState;
    private int myCurrentLines;
    private int myApprovedLines;
    private int myImportedLines;

    protected RemoteBatchPreparedStatementImpl(@NotNull Configuration configuration, @NotNull PreparedStatement delegate, @NotNull PreparedStatement oneLineStatement, @NotNull Connection connection) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "<init>"));
        }
        if (oneLineStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oneLineStatement", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "<init>"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "<init>"));
        }
        super(delegate);
        this.myOneLineStatement = new MyInsider(oneLineStatement, 1);
        this.myLockQuery = configuration.lockQuery;
        this.myGenerator = new ImportQueryGenerator(configuration.rdbms, this, configuration.infos, configuration.useBatches, configuration.lines);
        this.myConnection = connection;
        this.myLines = configuration.lines;
        this.myUseTransactions = configuration.useTransactions;
    }

    @Override
    @NotNull
    public List<ErrorRecord> addBatch(@NotNull BatchRecords records, @NotNull String lastSql) throws SQLException, RemoteException {
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "addBatch"));
        }
        if (lastSql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastSql", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "addBatch"));
        }
        try {
            List<Query> generate = this.myGenerator.generate(lastSql, records);
            for (Query query : generate) {
                query.execute();
            }
        }
        catch (SQLException e) {
            throw this.rethrowException(e);
        }
        List<ErrorRecord> list = this.myGenerator.getErrors();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "addBatch"));
        }
        return list;
    }

    @Override
    public void addBatch() throws RemoteException, SQLException {
        this.addBatchInternal(new MyComputable<Void>(){

            @Override
            public Void compute() throws SQLException, RemoteException {
                RemoteBatchPreparedStatementImpl.super.addBatch();
                return null;
            }
        }, this.myLines);
    }

    @NotNull
    public RemotePreparedStatement withLines(String sql, int lines) throws SQLException, RemoteException {
        PreparedStatement statement = this.myConnection.prepareStatement(sql);
        MyInsider myInsider = new MyInsider(statement, lines);
        if (myInsider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "withLines"));
        }
        return myInsider;
    }

    @Override
    public long getInsertedLinesCount() {
        return this.myImportedLines;
    }

    @Override
    public void close() throws RemoteException, SQLException {
        try {
            this.commitIfNeeded(true);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
        finally {
            JdbcNativeUtil.closeRemoteStatementSafe(this.myOneLineStatement);
            super.close();
        }
    }

    private void addBatchInternal(@NotNull MyComputable<Void> computable, int lines) throws RemoteException, SQLException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "addBatchInternal"));
        }
        try {
            if (this.myBatchSize == 0) {
                this.onBatchStart();
            }
            computable.compute();
            this.myBatchSize += lines;
        }
        catch (SQLException e) {
            this.onAddBatchError();
        }
    }

    private int[] executeBatchInternal(@NotNull MyComputable<int[]> computable) throws RemoteException, SQLException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "executeBatchInternal"));
        }
        try {
            if (this.myBatchSize == 0) {
                return EMPTY_INTS;
            }
            int[] result = computable.compute();
            this.myCurrentLines += this.myBatchSize;
            this.myBatchSize = 0;
            this.approveLines();
            this.commitIfNeeded();
            this.onSuccessfulExecuteBatch();
            return result;
        }
        catch (IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException e) {
            this.onExecuteBatchError();
            throw e;
        }
    }

    private int executeUpdateInternal(@NotNull MyComputable<Integer> computable) throws RemoteException, SQLException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "executeUpdateInternal"));
        }
        try {
            int result = computable.compute();
            this.myCurrentLines += result;
            this.approveLines();
            this.commitIfNeeded();
            this.onSuccessfulExecuteUpdate();
            return result;
        }
        catch (IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException e) {
            this.onExecuteUpdateError();
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws RemoteException, SQLException {
        return this.executeBatchInternal(new MyComputable<int[]>(){

            @Override
            public int[] compute() throws SQLException, RemoteException {
                return RemoteBatchPreparedStatementImpl.super.executeBatch();
            }
        });
    }

    @Override
    public int executeUpdate() throws RemoteException, SQLException {
        return this.executeUpdateInternal(new MyComputable<Integer>(){

            @Override
            public Integer compute() throws SQLException, RemoteException {
                return RemoteBatchPreparedStatementImpl.super.executeUpdate();
            }
        });
    }

    protected void rollback() throws SQLException {
        if (!this.myUseTransactions) {
            return;
        }
        this.myBatchSize = 0;
        this.myCurrentLines = 0;
        this.myApprovedLines = 0;
        RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                RemoteBatchPreparedStatementImpl.this.myConnection.rollback();
                RemoteBatchPreparedStatementImpl.this.lock();
            }
        }, ROLLBACK_ERROR);
    }

    protected void checkoutLastState() throws SQLException {
        if (!this.myUseTransactions) {
            return;
        }
        this.myCurrentLines = 0;
        RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                RemoteBatchPreparedStatementImpl.this.myLastState = RemoteBatchPreparedStatementImpl.this.myConnection.setSavepoint();
            }
        }, SAVE_ERROR);
    }

    protected void releaseLastState() throws SQLException {
        if (!this.myUseTransactions) {
            return;
        }
        this.approveLines();
        try {
            RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

                public void run() throws SQLException {
                    if (RemoteBatchPreparedStatementImpl.this.myLastState != null) {
                        RemoteBatchPreparedStatementImpl.this.myConnection.releaseSavepoint(RemoteBatchPreparedStatementImpl.this.myLastState);
                    }
                }
            }, SAVE_ERROR);
        }
        finally {
            this.myLastState = null;
        }
    }

    protected void rollbackToLastState() throws SQLException {
        if (!this.myUseTransactions) {
            return;
        }
        this.myCurrentLines = 0;
        this.myBatchSize = 0;
        RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                if (RemoteBatchPreparedStatementImpl.this.myLastState == null) {
                    RemoteBatchPreparedStatementImpl.this.myConnection.rollback();
                    return;
                }
                RemoteBatchPreparedStatementImpl.this.myConnection.rollback(RemoteBatchPreparedStatementImpl.this.myLastState);
            }
        }, ROLLBACK_ERROR);
    }

    public void commitIfNeeded() throws SQLException {
        this.commitIfNeeded(false);
    }

    public void commitIfNeeded(boolean force) throws SQLException {
        if (!this.myUseTransactions) {
            this.linesCommitted();
            return;
        }
        if (!force && this.myApprovedLines < 1000) {
            return;
        }
        RemoteBatchPreparedStatementImpl.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                RemoteBatchPreparedStatementImpl.this.myConnection.commit();
                RemoteBatchPreparedStatementImpl.this.linesCommitted();
                RemoteBatchPreparedStatementImpl.this.lock();
                RemoteBatchPreparedStatementImpl.this.myLastState = null;
            }
        }, SAVE_ERROR);
    }

    private void linesCommitted() {
        this.myImportedLines += this.myApprovedLines;
        this.myApprovedLines = 0;
    }

    private void approveLines() {
        this.myApprovedLines += this.myCurrentLines;
        this.myCurrentLines = 0;
    }

    protected abstract void onAddBatchError() throws RemoteException, SQLException;

    protected abstract void onBatchStart() throws RemoteException, SQLException;

    protected abstract void onExecuteBatchError() throws RemoteException, SQLException;

    protected abstract void onExecuteUpdateError() throws RemoteException, SQLException;

    protected abstract void onSuccessfulExecuteBatch() throws RemoteException, SQLException;

    protected abstract void onSuccessfulExecuteUpdate() throws RemoteException, SQLException;

    private void lock() throws SQLException {
        if (!this.myUseTransactions || this.myLockQuery == null) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.myConnection.createStatement();
            statement.execute(this.myLockQuery);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private static void run(@NotNull ThrowableRunnable<SQLException> runnable, @NotNull String message) throws SQLException {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "run"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl", "run"));
        }
        try {
            runnable.run();
        }
        catch (SQLException e) {
            throw new IllegalTransactionStateException(e, message);
        }
    }

    private class MyInsider
    extends RemotePreparedStatementImpl {
        private final int myLines;

        private MyInsider(PreparedStatement delegate, int lines) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl$MyInsider", "<init>"));
            }
            super(delegate);
            this.myLines = lines;
        }

        public void addBatch() throws RemoteException, SQLException {
            RemoteBatchPreparedStatementImpl.this.addBatchInternal(new MyComputable<Void>(){

                @Override
                public Void compute() throws SQLException, RemoteException {
                    MyInsider.super.addBatch();
                    return null;
                }
            }, this.myLines);
        }

        public int[] executeBatch() throws RemoteException, SQLException {
            return RemoteBatchPreparedStatementImpl.this.executeBatchInternal(new MyComputable<int[]>(){

                @Override
                public int[] compute() throws SQLException, RemoteException {
                    return MyInsider.super.executeBatch();
                }
            });
        }

        public int executeUpdate() throws RemoteException, SQLException {
            return RemoteBatchPreparedStatementImpl.this.executeUpdateInternal(new MyComputable<Integer>(){

                @Override
                public Integer compute() throws SQLException, RemoteException {
                    return MyInsider.super.executeUpdate();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Configuration
    implements Serializable {
        public final Rdbms rdbms;
        public final String sql;
        public final String oneLineSql;
        public final String lockQuery;
        public final List<ColumnInfo> infos;
        public final boolean useTransactions;
        public final boolean useSavepoints;
        public final boolean useBatches;
        public final int lines;

        public Configuration(@NotNull Rdbms rdbms, @NotNull String sql, @NotNull String oneLineSql, @Nullable String lockQuery, @NotNull List<ColumnInfo> infos, boolean useTransactions, boolean useSavepoints, boolean useBatches, int lines) {
            if (rdbms == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl$Configuration", "<init>"));
            }
            if (sql == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl$Configuration", "<init>"));
            }
            if (oneLineSql == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oneLineSql", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl$Configuration", "<init>"));
            }
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/database/remote/jdbc/impl/RemoteBatchPreparedStatementImpl$Configuration", "<init>"));
            }
            this.rdbms = rdbms;
            this.sql = sql;
            this.oneLineSql = oneLineSql;
            this.lockQuery = lockQuery;
            this.infos = infos;
            this.useTransactions = useTransactions;
            this.useSavepoints = useSavepoints;
            this.useBatches = useBatches;
            this.lines = lines;
        }
    }

    public static class IllegalTransactionStateException
    extends SQLException {
        public IllegalTransactionStateException(Throwable cause, String error) {
            super(error, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MyComputable<T> {
        public T compute() throws SQLException, RemoteException;
    }
}

