/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.git.GitExKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J$\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/settingsRepository/RepositoryService;", "", "checkFileRepo", "", "url", "", "project", "Lcom/intellij/openapi/project/Project;", "checkUrl", "uriString", "suggestToCreate", "isValidRepository", "file", "Ljava/nio/file/Path;", "settings-repository"})
public interface RepositoryService {
    public boolean checkUrl(@NotNull String var1, boolean var2, @Nullable Project var3);

    public boolean isValidRepository(@NotNull Path var1);

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=3)
    public static final class DefaultImpls {
        public static boolean checkUrl(@NotNull RepositoryService $this, String uriString, @Nullable boolean suggestToCreate, Project project) {
            boolean isFile;
            Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
            URIish uri = new URIish(uriString);
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
                isFile = true;
            } else {
                boolean bl = isFile = uri.getScheme() == null && uri.getHost() == null;
            }
            return !isFile || DefaultImpls.checkFileRepo($this, uriString, project);
        }

        public static /* bridge */ /* synthetic */ boolean checkUrl$default(RepositoryService repositoryService, String string, boolean bl, Project project, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkUrl");
            }
            if ((n & 4) != 0) {
                project = null;
            }
            return repositoryService.checkUrl(string, bl, project);
        }

        private static boolean checkFileRepo(RepositoryService $this, String url, Project project) {
            String string;
            String suffix = "/" + ".git";
            if (StringsKt.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2, null)) {
                String string2 = url;
                int n = 0;
                int n2 = url.length() - suffix.length();
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = url;
            }
            Path file = Paths.get(string, new String[0]);
            if (PathKt.exists((Path)file)) {
                if (!PathKt.isDirectory((Path)file)) {
                    Messages.showErrorDialog((Project)project, (String)"Specified path is not a directory", (String)"Specified Path is Invalid");
                    return false;
                }
                Path path = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                if ($this.isValidRepository(path)) {
                    return true;
                }
            } else if (!file.isAbsolute()) {
                Messages.showErrorDialog((Project)project, (String)IcsBundleKt.icsMessage("specify.absolute.path.dialog.message", new Object[0]), (String)"");
                return false;
            }
            if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IcsBundleKt.icsMessage("init.dialog.title", new Object[0]), (String)IcsBundleKt.icsMessage("init.dialog.message", file)).yesText("Create")).project(project)).isYes()) {
                try {
                    Path path = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                    GitExKt.createBareRepository(path);
                    return true;
                }
                catch (IOException e) {
                    Messages.showErrorDialog((Project)project, (String)IcsBundleKt.icsMessage("init.failed.message", e.getMessage()), (String)IcsBundleKt.icsMessage("init.failed.title", new Object[0]));
                    return false;
                }
            }
            return false;
        }
    }
}

