/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.WebInspectionToolProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class WebXmlValidator
extends InspectionValidator {
    public WebXmlValidator() {
        super(WebBundle.message("web.xml.validator.decription", new Object[0]), WebBundle.message("progress.validating.web.xml.text", new Object[0]));
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new WebInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/highlighting/WebXmlValidator", "getInspectionToolClasses"));
        }
        return classArray;
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/j2ee/web/highlighting/WebXmlValidator", "isAvailableOnScope"));
        }
        return WebXmlValidator.containsWebFacets(scope);
    }

    private static boolean containsWebFacets(CompileScope scope) {
        for (Module module : scope.getAffectedModules()) {
            if (WebFacet.getInstances((Module)module).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collection webFacets = WebFacet.getInstances((Module)module);
            for (WebFacet webFacet : webFacets) {
                InspectionValidatorUtil.addDescriptor(list, (ConfigFile)webFacet.getWebXmlDescriptor());
            }
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded(list, (CompileContext)context);
        return list;
    }
}

