/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.javaee.model.NamedMethodResolveConverter;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.model.xml.ejb.InterceptorBinding;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.javaee.model.xml.ejb.NamedMethod;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NamedMethodResolveConverterImpl
extends NamedMethodResolveConverter {
    @NotNull
    protected Collection<PsiClass> getPsiClasses(NamedMethod parent, ConvertContext context) {
        EnterpriseBean bean;
        InterceptorBinding interceptorBinding;
        String xmlElementName = parent.getXmlElementName();
        if ("method".equals(xmlElementName) && (interceptorBinding = (InterceptorBinding)parent.getParentOfType(InterceptorBinding.class, true)) != null && (bean = (EnterpriseBean)interceptorBinding.getEnterpriseBean().getValue()) != null) {
            List<PsiClass> list = Arrays.asList((PsiClass)bean.getEjbClass().getValue());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/NamedMethodResolveConverterImpl", "getPsiClasses"));
            }
            return list;
        }
        EnterpriseBean bean2 = (EnterpriseBean)parent.getParentOfType(EjbBase.class, true);
        Module module = parent.getModule();
        if (bean2 != null && module != null) {
            bean2 = (EnterpriseBean)ElementPresentationManager.findByName((Collection)EjbCommonModelUtil.getAllEjbs((Project)module.getProject(), (Module)module, null), (String)((String)bean2.getEjbName().getValue()));
        }
        if (bean2 != null) {
            if ("timeout-method".equals(xmlElementName) || "bean-method".equals(xmlElementName)) {
                List<PsiClass> list = Arrays.asList((PsiClass)bean2.getEjbClass().getValue());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/NamedMethodResolveConverterImpl", "getPsiClasses"));
                }
                return list;
            }
            if ("create-method".equals(xmlElementName) && bean2 instanceof EjbWithHome) {
                EjbWithHome ejbWithHome = (EjbWithHome)bean2;
                List<PsiClass> list = Arrays.asList((PsiClass)ejbWithHome.getHome().getValue(), (PsiClass)ejbWithHome.getLocalHome().getValue());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/NamedMethodResolveConverterImpl", "getPsiClasses"));
                }
                return list;
            }
        }
        List<PsiClass> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/NamedMethodResolveConverterImpl", "getPsiClasses"));
        }
        return list;
    }

    @NotNull
    protected MethodParams getMethodParams(@NotNull NamedMethod parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javaee/model/NamedMethodResolveConverterImpl", "getMethodParams"));
        }
        MethodParams methodParams = parent.getMethodParams();
        if (methodParams == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/NamedMethodResolveConverterImpl", "getMethodParams"));
        }
        return methodParams;
    }
}

