/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.editor;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.ui.MockJavaeeDomElementsEditor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.BasicDomElementComponent;
import com.intellij.util.xml.ui.CaptionComponent;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.DomFileEditor;
import com.intellij.util.xml.ui.DomUIFactory;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeMockEditor
extends MockJavaeeDomElementsEditor {
    private final JavaeeIntegration myIntegration;

    protected JavaeeMockEditor(JavaeeFacet facet, JavaeeIntegration integration) {
        super(facet);
        this.myIntegration = integration;
    }

    private JavaeeIntegration getIntegration() {
        return this.myIntegration;
    }

    protected String getTitle() {
        return JavaeeBundle.getText("Editor.title", this.getIntegration().getName());
    }

    protected final DomFileEditor<?> initEditor(CommittablePanel panel, DomElement element) {
        CaptionComponent caption = new CaptionComponent(this.getTitle(), this.getIntegration().getBigIcon());
        caption = DomUIFactory.getDomUIFactory().addErrorPanel(caption, new DomElement[]{element});
        BasicDomElementComponent component = DomFileEditor.createComponentWithCaption((CommittablePanel)panel, (CaptionComponent)caption, (DomElement)element);
        return this.initFileEditor(component, DomUtil.getFile((DomElement)element).getVirtualFile(), caption.getText());
    }

    protected static void addWatchedElement(DomFileEditor<?> editor, @Nullable DomElement element) {
        if (element != null) {
            editor.addWatchedElement(element);
        }
    }
}

