/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.util;

import com.intellij.javaee.util.ILogger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;

public class LoggerWrapper
implements ILogger {
    private final Logger myLog;

    public LoggerWrapper(Logger log) {
        this.myLog = log;
    }

    public void debugEx(Exception e) {
        this.myLog.debug((Throwable)e);
    }

    public void errorEx(Exception e) {
        this.myLog.info((Throwable)e);
        LoggerWrapper.notifyError(e.toString());
    }

    public void debug(String message) {
        this.myLog.debug(message);
    }

    public void error(String message) {
        this.myLog.info(message);
        LoggerWrapper.notifyError(message);
    }

    public void info(String message) {
        this.myLog.info(message);
    }

    private static void notifyError(String message) {
        NotificationGroup notificationGroup = NotificationGroup.balloonGroup((String)"JavaEE");
        Notification notification = notificationGroup.createNotification(message, MessageType.ERROR);
        notification.notify(null);
    }
}

