/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation.ui;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.jpa.generation.ui.DatabaseRelationshipData;
import com.intellij.jpa.generation.ui.DatabaseSchemaImportDialog;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class DatabaseRelationshipRolePanel {
    private JComboBox myCbTable;
    private JComboBox myCbType;
    private JTextField myTfAttribute;
    private JPanel myPanel;
    private JComboBox myCbMapKey;
    private final DatabaseRelationshipData.Role myData;
    private DatabaseRelationshipRolePanel myOpposite;
    private DasColumn myMapKeySaved;

    public DatabaseRelationshipRolePanel(DatabaseRelationshipData.Role data) {
        this.myData = data;
        this.$$$setupUI$$$();
        this.initControls();
    }

    public void setOpposite(DatabaseRelationshipRolePanel opposite) {
        this.myOpposite = opposite;
    }

    /*
     * WARNING - void declaration
     */
    private void initControls() {
        void var4_6;
        ArrayList<ContainerTypeHolder> holders = new ArrayList<ContainerTypeHolder>();
        holders.add(new ContainerTypeHolder(null));
        JavaContainerType[] javaContainerTypeArray = JavaContainerType.values();
        int n = javaContainerTypeArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            JavaContainerType type = javaContainerTypeArray[var4_6];
            holders.add(new ContainerTypeHolder(type));
            ++var4_6;
        }
        this.myCbType.setModel(new DefaultComboBoxModel<Object>(holders.toArray()));
        SortedComboBoxModel tableModel = new SortedComboBoxModel(DatabaseSchemaImportDialog.TABLE_COMPARATOR);
        for (DasTable dasTable : this.getTables()) {
            tableModel.add((Object)dasTable);
        }
        this.myCbTable.setModel(tableModel);
        this.myCbTable.setRenderer(new ListCellRendererWrapper<DasTable>(){

            public void customize(JList list, DasTable value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(QNameUtil.getQualifiedName((DasObject)value));
                }
            }
        });
        if (this.myData.getTable() != null && tableModel.getItems().contains(this.myData.getTable())) {
            this.myCbTable.setSelectedItem(this.myData.getTable());
        } else {
            this.myCbTable.setSelectedIndex(0);
        }
        this.myTfAttribute.setText(this.myData.getAttribute());
        this.myTfAttribute.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                DatabaseRelationshipRolePanel.this.attributeNameChanged();
            }
        });
        this.myCbType.setSelectedItem(new ContainerTypeHolder(this.myData.getContainerType()));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseRelationshipRolePanel.this.tableOrTypeChanged();
            }
        };
        this.myCbTable.addActionListener(actionListener);
        this.myCbType.addActionListener(actionListener);
        this.myCbMapKey.setEnabled(false);
        this.myCbMapKey.setModel(new SortedComboBoxModel(DatabaseSchemaImportDialog.TABLE_FIELD_COMPARATOR));
        this.myCbMapKey.setRenderer(new ListCellRendererWrapper<DasColumn>(){

            public void customize(JList list, DasColumn value, int index, boolean selected, boolean hasFocus) {
                this.setText(value == null ? "" : value.getName());
            }
        });
        this.myMapKeySaved = this.myData.getMapKey();
    }

    public void setTableEditable(boolean editable) {
        this.myCbTable.setEnabled(false);
    }

    protected void tableOrTypeChanged() {
        this.updateControls();
    }

    protected void attributeNameChanged() {
    }

    protected abstract List<? extends DasTable> getTables();

    public void updateControls() {
        boolean tableChanged;
        boolean isMap = this.getContainerType() == JavaContainerType.MAP;
        boolean wasEnabled = this.myCbMapKey.isEnabled();
        boolean bl = tableChanged = isMap && !wasEnabled || wasEnabled && ((DasColumn)this.myCbMapKey.getSelectedItem()).getTable() != this.myOpposite.getTable();
        if (wasEnabled) {
            this.myMapKeySaved = (DasColumn)this.myCbMapKey.getSelectedItem();
        }
        if (isMap != wasEnabled) {
            this.myCbMapKey.setEnabled(isMap);
            if (!isMap) {
                this.myCbMapKey.setSelectedItem(null);
            }
        }
        if (tableChanged) {
            SortedComboBoxModel comboBoxModel = (SortedComboBoxModel)this.myCbMapKey.getModel();
            ArrayList list = ContainerUtil.newArrayList((Iterable)DasUtil.getColumns((DasObject)this.myOpposite.getTable()));
            comboBoxModel.setAll((Collection)list);
            if (!list.contains(this.myMapKeySaved)) {
                this.myMapKeySaved = (DasColumn)this.myCbMapKey.getItemAt(0);
            }
            this.myCbMapKey.setSelectedItem(this.myMapKeySaved);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public DatabaseRelationshipData.Role getData() {
        return this.myData;
    }

    public DasTable getTable() {
        return (DasTable)this.myCbTable.getSelectedItem();
    }

    public JavaContainerType getContainerType() {
        return ((ContainerTypeHolder)this.myCbType.getSelectedItem()).getType();
    }

    public String getAttributeName() {
        return this.myTfAttribute.getText();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCbTable;
    }

    public void commit() {
        this.myData.setAttribute(this.myTfAttribute.getText());
        this.myData.setTable((DasTable)this.myCbTable.getSelectedItem());
        this.myData.setContainerType(this.getContainerType());
        DasColumn mapKey = (DasColumn)this.myCbMapKey.getSelectedItem();
        this.myData.setMapKey(mapKey != null && !" ".equals(mapKey.getName()) ? mapKey : null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(134, 14), null));
        this.myCbType = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(3, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(134, 22), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JpaBundle").getString("label.persistence.relationship.role.map.key"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbMapKey = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myCbTable = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(134, 22), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/JpaBundle").getString("label.persistence.relationship.role.attribute.name"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTfAttribute = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/JpaBundle").getString("label.persistence.relationship.role.table"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/JpaBundle").getString("label.persistence.relationship.role.type"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(jComboBox);
        jLabel4.setLabelFor(jComboBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ContainerTypeHolder {
        private final JavaContainerType type;

        public ContainerTypeHolder(JavaContainerType type) {
            this.type = type;
        }

        public JavaContainerType getType() {
            return this.type;
        }

        public String toString() {
            return this.type == null ? "Single" : (this.type == JavaContainerType.ARRAY ? "Array" : this.type.getJavaBaseClassName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContainerTypeHolder that = (ContainerTypeHolder)o;
            return this.type == that.type;
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }
    }
}

