/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.intentions;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.actions.NewGroupPersistence;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.AbstractPersistenceAction;
import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.model.manipulators.PersistentRelationshipAttributeManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaAddInverseAttributeAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction", "isAvailable"));
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != StdLanguages.JAVA) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiMember targetMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
        if (!(targetMember instanceof PsiMethod) && !(targetMember instanceof PsiField) || !targetMember.isValid()) {
            return false;
        }
        if (targetMember instanceof PsiMethod && !HighlightNamesUtil.getMethodDeclarationTextRange((PsiMethod)((PsiMethod)targetMember)).containsRange(offset, offset + 1)) {
            return false;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)targetMember, PsiErrorElement.class) != null) {
            return false;
        }
        PsiDocComment docComment = ((PsiDocCommentOwner)targetMember).getDocComment();
        if (docComment != null && docComment.getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        String text = JpaAddInverseAttributeAction.getExplanation(targetMember);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = JpaMessages.message((String)"intention.persistence.add.inverse.attribute.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    public static String getExplanation(PsiMember member) {
        if (JpaUtil.getFirstPersistentObjectOfClass(member.getContainingClass(), PersistentEntityBase.class) == null) {
            return null;
        }
        return JpaAddInverseAttributeAction.queryTargetObjects(member).findFirst() != null ? JpaMessages.message((String)"intention.persistence.add.inverse.attribute.text", (Object[])new Object[0]) : null;
    }

    public static Query<Pair<PersistentRelationshipAttribute, PersistentObject>> queryTargetObjects(final PsiMember member) {
        return new ExecutorsQuery((Object)member, Arrays.asList(new QueryExecutor<Pair<PersistentRelationshipAttribute, PersistentObject>, PsiMember>(){

            public boolean execute(@NotNull PsiMember queryParameters, @NotNull Processor<Pair<PersistentRelationshipAttribute, PersistentObject>> consumer) {
                if (queryParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction$1", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction$1", "execute"));
                }
                for (PersistentAttribute attributeBase : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member)) {
                    if (!(attributeBase instanceof PersistentRelationshipAttribute) || !(attributeBase.getPersistentObject() instanceof PersistentEntityBase)) continue;
                    PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)member);
                    PersistentRelationshipAttribute relationshipAttribute = (PersistentRelationshipAttribute)attributeBase;
                    for (PersistentObject persistentObject : browser.queryTargetPersistentObjects(relationshipAttribute)) {
                        for (PersistentObject object : ModelMergerUtil.getFilteredImplementations((Object)persistentObject)) {
                            PersistentRelationshipAttribute attribute;
                            if (!(object instanceof PersistentEntityBase) || (attribute = (PersistentRelationshipAttribute)browser.queryTheOtherSideAttributes(relationshipAttribute, false, object).findFirst()) != null || consumer.process((Object)Pair.create((Object)relationshipAttribute, (Object)object))) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        }));
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        JpaAddInverseAttributeAction.generateInverseAttribute(project, editor, element.getContainingFile());
    }

    private static void generateInverseAttribute(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
        assert (member instanceof PsiField || member instanceof PsiMethod);
        THashSet pairs = new THashSet(JpaAddInverseAttributeAction.queryTargetObjects(member).findAll(), (TObjectHashingStrategy)new TObjectHashingStrategy<Pair<PersistentRelationshipAttribute, PersistentObject>>(){

            public int computeHashCode(Pair<PersistentRelationshipAttribute, PersistentObject> object) {
                return ((PersistentRelationshipAttribute)object.getFirst()).getAttributeModelHelper().getRelationshipType().hashCode() + ((PersistentObject)object.getSecond()).hashCode();
            }

            public boolean equals(Pair<PersistentRelationshipAttribute, PersistentObject> o1, Pair<PersistentRelationshipAttribute, PersistentObject> o2) {
                return ((PersistentRelationshipAttribute)o1.getFirst()).getAttributeModelHelper().getRelationshipType() == ((PersistentRelationshipAttribute)o2.getFirst()).getAttributeModelHelper().getRelationshipType() && ((PersistentObject)o1.getSecond()).equals(o2.getSecond());
            }
        });
        assert (!pairs.isEmpty());
        THashSet existingNames = new THashSet();
        for (Pair pair : pairs) {
            for (PersistentAttribute attribute : PersistenceHelper.getHelper().getSharedModelBrowser().queryAttributes((PersistentObject)pair.getSecond()).findAll()) {
                ContainerUtil.addIfNotNull((Collection)existingNames, (Object)attribute.getName().getValue());
            }
        }
        PersistentRelationshipAttribute firstAttr = (PersistentRelationshipAttribute)((Pair)pairs.iterator().next()).getFirst();
        PsiClassType entityClassType = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory().createType(member.getContainingClass());
        PsiClassType psiType = firstAttr.getAttributeModelHelper().getRelationshipType().isMany(false) ? JavaContainerType.COLLECTION.createCollectionType((PsiElement)member, (PsiType)entityClassType, null) : entityClassType;
        SuggestedNameInfo suggestedNameInfo = JavaCodeStyleManager.getInstance((Project)file.getProject()).suggestVariableName(VariableKind.LOCAL_VARIABLE, "", null, (PsiType)psiType);
        String defaultName = UniqueNameGenerator.generateUniqueName((String)suggestedNameInfo.names[0], s -> !existingNames.contains(s));
        if (pairs.size() > 1) {
            JBList list = new JBList(pairs.toArray());
            list.setCellRenderer(new ColoredListCellRenderer(){

                protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction$3", "customizeCellRenderer"));
                    }
                    Pair pair = (Pair)value;
                    PersistentObject object = (PersistentObject)pair.getSecond();
                    this.setIcon(ElementPresentationManager.getIcon((Object)object));
                    String entityName = object instanceof PersistentEntity ? (String)((PersistentEntity)object).getName().getValue() : object.getClazz().getStringValue();
                    String typeName = AttributeType.getAttributeType((RelationshipType)((PersistentRelationshipAttribute)pair.getFirst()).getAttributeModelHelper().getRelationshipType().getInverseType()).getTypeName();
                    PsiFile containingFile = object.getContainingFile();
                    if (entityName != null) {
                        this.append(entityName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    this.append(": " + typeName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (containingFile != null) {
                        this.append("  [" + containingFile.getName() + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            });
            new PopupChooserBuilder((JList)list).setTitle(JpaMessages.message((String)"title.choose.persistent.object", (Object[])new Object[0])).setItemChoosenCallback(() -> JpaAddInverseAttributeAction.lambda$generateInverseAttribute$1((JList)list, project, existingNames, defaultName, editor)).createPopup().showInBestPositionFor(editor);
        } else {
            String targetName = JpaAddInverseAttributeAction.getTargetName(project, (THashSet<String>)existingNames, defaultName);
            if (targetName == null) {
                return;
            }
            PersistenceAction action = JpaAddInverseAttributeAction.createAction((Pair<PersistentRelationshipAttribute, PersistentObject>)((Pair)pairs.iterator().next()), targetName);
            NewGroupPersistence.runAction(project, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), action);
        }
    }

    private static String getTargetName(final Project project, final THashSet<String> existingNames, String defaultName) {
        String targetName = Messages.showInputDialog((Project)project, (String)JpaMessages.message((String)"intention.persistence.add.inverse.attribute.input.name.text", (Object[])new Object[0]), (String)JpaMessages.message((String)"intention.persistence.add.inverse.attribute.input.name.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)defaultName, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return !existingNames.contains((Object)inputString) && PsiNameHelper.getInstance((Project)project).isIdentifier(inputString, LanguageLevel.HIGHEST);
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        return targetName;
    }

    private static PersistenceAction createAction(Pair<PersistentRelationshipAttribute, PersistentObject> pair, final String targetName) {
        final ManipulatorsRegistry manipulatorsRegistry = PersistenceHelper.getHelper().getManipulatorsRegistry();
        final PersistentRelationshipAttribute attribute = (PersistentRelationshipAttribute)pair.getFirst();
        final PersistentEntityBase persistentObject = (PersistentEntityBase)pair.getSecond();
        PersistentObjectManipulator persistenceManipulator = (PersistentObjectManipulator)manipulatorsRegistry.getManipulator((Object)persistentObject, PersistentObjectManipulator.class);
        if (persistenceManipulator == null) {
            return null;
        }
        return new AbstractPersistenceAction<PersistentObjectManipulator<PersistentEntityBase>>(persistenceManipulator, JpaMessages.message((String)"intention.persistence.add.inverse.attribute.text", (Object[])new Object[0]), JpaMessages.message((String)"intention.persistence.add.inverse.attribute.text", (Object[])new Object[0]), JavaeeIcons.ATTRIBUTE_ICON){

            protected PsiElement getTargetElement() {
                return persistentObject.getIdentifyingPsiElement();
            }

            public void invokeAction(@NotNull Collection result) throws IncorrectOperationException {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction$5", "invokeAction"));
                }
                ((PersistentObjectManipulator)this.getManipulator()).ensureClassExists();
                RelationshipType thisType = attribute.getAttributeModelHelper().getRelationshipType();
                boolean thisInverse = thisType == RelationshipType.ONE_TO_MANY || attribute.getAttributeModelHelper().isInverseSide();
                ((PersistentObjectManipulator)this.getManipulator()).addRelationshipAttribute((PersistentEntityBase)attribute.getPersistentObject(), thisType.getInverseType(), JavaContainerType.COLLECTION, targetName, (String)attribute.getName().getValue(), !thisInverse, false, null, Collections.emptyList(), persistentObject.getObjectModelHelper().getDefaultAccessMode());
                PersistentRelationshipAttributeManipulator manipulator = (PersistentRelationshipAttributeManipulator)manipulatorsRegistry.getManipulator((Object)attribute, PersistentRelationshipAttributeManipulator.class);
                if (manipulator != null) {
                    manipulator.setMappedByAndInverse(targetName, thisInverse);
                }
            }

            public int getGroupId() {
                return 50;
            }

            public void addAffectedElements(@NotNull Collection<PsiElement> affectedElements) {
                if (affectedElements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedElements", "com/intellij/jpa/intentions/JpaAddInverseAttributeAction$5", "addAffectedElements"));
                }
                ContainerUtil.addIfNotNull(affectedElements, (Object)attribute.getPsiMember());
                ContainerUtil.addIfNotNull(affectedElements, (Object)attribute.getIdentifyingPsiElement());
                ContainerUtil.addIfNotNull(affectedElements, (Object)persistentObject.getIdentifyingPsiElement());
                ContainerUtil.addIfNotNull(affectedElements, (Object)persistentObject.getClazz().getValue());
            }
        };
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void lambda$generateInverseAttribute$1(JList list, Project project, THashSet existingNames, String defaultName, Editor editor) {
        Object value = list.getSelectedValue();
        Pair pair = (Pair)value;
        if (pair != null) {
            String targetName = JpaAddInverseAttributeAction.getTargetName(project, (THashSet<String>)existingNames, defaultName);
            if (targetName == null) {
                return;
            }
            PersistenceAction action = JpaAddInverseAttributeAction.createAction((Pair<PersistentRelationshipAttribute, PersistentObject>)pair, targetName);
            NewGroupPersistence.runAction(project, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), action);
        }
    }
}

