/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.ide.TypePresentationService;
import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.actions.GenerateEntityListenerMethods;
import com.intellij.jpa.model.manipulators.AttributeNameDialog;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.EntityListenerBindingsDialog;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultUserResponse
implements UserResponse {
    private final THashMap<String, Object> myStorage = new THashMap();

    public String getPersistenceUnitName(@NotNull PersistenceFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/jpa/model/manipulators/DefaultUserResponse", "getPersistenceUnitName"));
        }
        String myKey = "getPersistenceUnitName";
        if (this.myStorage.containsKey((Object)"getPersistenceUnitName")) {
            return (String)this.myStorage.get((Object)"getPersistenceUnitName");
        }
        List list = facet.getPersistenceUnits();
        String typeName = TypePresentationService.getService().getTypePresentableName(facet.getPersistenceUnitClass()).replace(" ", "");
        final Condition condition = s -> {
            if (StringUtil.isEmpty((String)s)) {
                return false;
            }
            for (PersistencePackage unit : list) {
                if (!Comparing.equal((String)((String)unit.getName().getValue()), (String)s)) continue;
                return false;
            }
            return true;
        };
        String initialName = UniqueNameGenerator.generateUniqueName((String)StringUtil.decapitalize((String)typeName), (Condition)condition);
        String result = Messages.showInputDialog((Project)facet.getModule().getProject(), (String)JpaMessages.message((String)"prompt.enter.a.name", (Object[])new Object[0]), (String)JpaMessages.message((String)"title.new.persistence.unit", (Object[])new Object[]{typeName}), (Icon)Messages.getQuestionIcon(), (String)initialName, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return condition.value((Object)inputString);
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        this.myStorage.put((Object)"getPersistenceUnitName", (Object)result);
        return result;
    }

    @NotNull
    public VirtualFile[] getPersistenceMappingFiles(@NotNull PersistenceFacet facet, String templateName, Class<? extends PersistenceMappings> mappingsClass) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/jpa/model/manipulators/DefaultUserResponse", "getPersistenceMappingFiles"));
        }
        String myKey = "getPersistenceMappingsName";
        if (this.myStorage.containsKey((Object)"getPersistenceMappingsName")) {
            VirtualFile[] virtualFileArray = (VirtualFile[])this.myStorage.get((Object)"getPersistenceMappingsName");
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/manipulators/DefaultUserResponse", "getPersistenceMappingFiles"));
            }
            return virtualFileArray;
        }
        THashSet existingFiles = new THashSet();
        for (ConfigFile configFile : facet.getDescriptors()) {
            ContainerUtil.addIfNotNull((Collection)existingFiles, (Object)configFile.getVirtualFile());
        }
        VirtualFile[] result = JpaUtil.chooseXmlFiles(facet.getModule(), templateName, mappingsClass, JpaMessages.message((String)"title.new.persistence.mappings", (Object[])new Object[0]), (Collection<VirtualFile>)existingFiles, true);
        if (result.length > 0) {
            this.myStorage.put((Object)"getPersistenceMappingsName", (Object)result);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/manipulators/DefaultUserResponse", "getPersistenceMappingFiles"));
        }
        return result;
    }

    @Nullable
    public Pair<PsiDirectory, String> getClassName(@NotNull Module module, String title, final String helpID) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jpa/model/manipulators/DefaultUserResponse", "getClassName"));
        }
        String myKey = "getClassName";
        if (this.myStorage.containsKey((Object)"getClassName")) {
            return (Pair)this.myStorage.get((Object)"getClassName");
        }
        CreateClassDialog dialog = new CreateClassDialog(module.getProject(), title, "", "", (ClassKind)CreateClassKind.CLASS, true, module){

            protected void doHelpAction() {
                HelpManager.getInstance().invokeHelp(helpID);
            }
        };
        dialog.show();
        Pair result = !dialog.isOK() || dialog.getTargetDirectory() == null ? null : Pair.create((Object)dialog.getTargetDirectory(), (Object)dialog.getClassName());
        this.myStorage.put((Object)"getClassName", (Object)result);
        return result;
    }

    public void askUserToSetupListener(PersistenceAction action, PersistenceFacet facet, PsiClass psiClass) {
        String myKey = "askUserToSetupListener";
        if (this.myStorage.containsKey((Object)"askUserToSetupListener")) {
            return;
        }
        this.myStorage.put((Object)"askUserToSetupListener", (Object)Boolean.TRUE);
        Project project = facet.getModule().getProject();
        Editor editor1 = CodeInsightUtil.positionCursorAtLBrace((Project)project, (PsiFile)psiClass.getContainingFile(), (PsiClass)psiClass);
        if (editor1 != null) {
            new GenerateEntityListenerMethods().actionPerformedImpl(project, editor1);
        }
        EntityListenerBindingsDialog entityListenerBindingsDialog = new EntityListenerBindingsDialog(project, psiClass.getQualifiedName(), facet);
        entityListenerBindingsDialog.show();
    }

    @Nullable
    public UserResponse.AttributeInfo getAttributeName(PersistentObject object, PersistentAttributeType attributeType, RelationshipType relationshipType, ModelValidator typeValidator, String title, String defaultName) {
        String myKey = "getAttributeName";
        if (this.myStorage.containsKey((Object)"getAttributeName")) {
            return (UserResponse.AttributeInfo)this.myStorage.get((Object)"getAttributeName");
        }
        AttributeNameDialog dialog = new AttributeNameDialog(object, attributeType, relationshipType, (Function<PsiType, String>)((NullableFunction)psiType -> {
            if (attributeType == JpaAttributeType.TRANSIENT) {
                return null;
            }
            return typeValidator.getAttributeTypeProblem(PersistenceCommonUtil.getTypeInfo((PsiType)psiType), attributeType, false);
        }), title, defaultName);
        dialog.show();
        UserResponse.AttributeInfo result = !dialog.isOK() ? null : (relationshipType != null ? new UserResponse.AttributeInfo(dialog.getAttributeName(), dialog.getAttributeType(), dialog.isFieldAccess(), dialog.getTargetAttributeName(), dialog.isInverse()) : new UserResponse.AttributeInfo(dialog.getAttributeName(), dialog.getAttributeType(), dialog.isFieldAccess(), dialog.isGenerated()));
        this.myStorage.put((Object)"getAttributeName", result);
        return result;
    }
}

