/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.psi.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlColumnExpression;
import com.intellij.jpa.ql.psi.QlConstructorArgumentsList;
import com.intellij.jpa.ql.psi.QlConstructorExpression;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlInVariableExpression;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlStringLiteral;
import com.intellij.jpa.ql.psi.QlTableExpression;
import com.intellij.jpa.ql.psi.impl.QlExpressionBaseImpl;
import com.intellij.jpa.ql.psi.impl.QlReferenceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.OrderedSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QlPsiImplUtil {
    public static final PsiArrayType PACKAGE_TYPE = new PsiArrayType((PsiType)PsiType.VOID);

    private QlPsiImplUtil() {
    }

    @NotNull
    public static PsiPolyVariantReference getReference(QlReferenceExpression o) {
        QlReferenceImpl qlReferenceImpl = new QlReferenceImpl(o);
        if (qlReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "getReference"));
        }
        return qlReferenceImpl;
    }

    @Nullable
    public static QlExpression getQualifier(QlReferenceExpression o) {
        return (QlExpression)PsiTreeUtil.findChildOfType((PsiElement)o, QlExpression.class);
    }

    @Nullable
    public static Object resolve(QlReferenceExpression o) {
        ResolveResult result;
        ResolveResult[] results = o.getReference().multiResolve(false);
        ResolveResult resolveResult = result = results.length > 0 ? results[0] : null;
        if (result == null) {
            return null;
        }
        if (result instanceof QlReferenceImpl.QlResolveResult) {
            return ((QlReferenceImpl.QlResolveResult)result).getPersistentElement();
        }
        return result.getElement();
    }

    @Nullable
    public static PsiType getPsiType(QlReferenceExpression o) {
        Object target = o.resolve();
        if (target == null) {
            return null;
        }
        if (target instanceof QlAliasDefinition) {
            Object o1;
            QlExpression expression = ((QlAliasDefinition)target).getExpression();
            if (expression instanceof QlReferenceExpression && (o1 = ((QlReferenceExpression)expression).resolve()) instanceof QlElement) {
                return ((QlElement)o1).getPsiType();
            }
            return null;
        }
        if (target instanceof QlElement) {
            return ((QlElement)target).getPsiType();
        }
        if (target instanceof QlInVariableExpression) {
            QlReferenceExpression referenceExpression = ((QlInVariableExpression)target).getReferenceExpression();
            return referenceExpression == null ? null : referenceExpression.getPsiType();
        }
        if (target instanceof PsiField) {
            return ((PsiField)target).getType();
        }
        if (target instanceof QlReferenceExpression) {
            return target.equals(o) && ((QlReferenceExpression)target).getText().equals("size") ? JavaPsiFacade.getInstance((Project)o.getProject()).getElementFactory().createTypeFromText("java.lang.Integer", (PsiElement)o) : null;
        }
        if (target instanceof PsiPackage) {
            return PACKAGE_TYPE;
        }
        if (target instanceof PsiClass) {
            return PsiElementFactory.SERVICE.getInstance((Project)o.getProject()).createType((PsiClass)target);
        }
        return null;
    }

    @NotNull
    public static PsiElement getNavigationElement(QlReferenceExpression o) {
        QlIdentifier qlIdentifier = o.getIdentifier();
        if (qlIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "getNavigationElement"));
        }
        return qlIdentifier;
    }

    @Nullable
    public static PsiReference getReference(QlConstructorExpression o) {
        QlReferenceExpression expression = o.getReferenceExpression();
        if (expression == null) {
            return null;
        }
        return new PsiReferenceBase<QlConstructorExpression>(o, TextRange.from((int)expression.getStartOffsetInParent(), (int)expression.getTextLength())){

            public PsiElement resolve() {
                return QlPsiImplUtil.resolveConstructor((QlConstructorExpression)this.getElement());
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
        };
    }

    @Nullable
    public static PsiPolyVariantReference getReference(final QlStringLiteral o) {
        QlReferenceExpression ref;
        PsiElement parent = o.getParent();
        final QlModel model = QlReferenceImpl.getPersistenceModel(o);
        final String unquote = StringUtil.unquoteString((String)o.getText());
        if (parent instanceof QlTableExpression) {
            return new PsiPolyVariantReferenceBase<QlStringLiteral>(o, TextRange.create((int)1, (int)(o.getTextLength() - 1))){

                @NotNull
                public ResolveResult[] multiResolve(boolean incompleteCode) {
                    OrderedSet result = new OrderedSet();
                    model.processInDbSchema((PsiScopeProcessor)new BaseScopeProcessor((Collection)result){
                        final /* synthetic */ Collection val$result;
                        {
                            this.val$result = collection;
                        }

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2$1", "execute"));
                            }
                            if (state == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2$1", "execute"));
                            }
                            if (element instanceof PsiNamedElement && Comparing.equal((String)unquote, (String)((PsiNamedElement)element).getName(), (boolean)true)) {
                                this.val$result.add(new PsiElementResolveResult(element));
                            }
                            return true;
                        }
                    }, ResolveState.initial());
                    ResolveResult[] resolveResultArray = (ResolveResult[])ArrayUtil.toObjectArray((Collection)result, ResolveResult.class);
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2", "multiResolve"));
                    }
                    return resolveResultArray;
                }

                @NotNull
                public Object[] getVariants() {
                    OrderedSet result = new OrderedSet();
                    model.processInDbSchema((PsiScopeProcessor)new BaseScopeProcessor((Collection)result){
                        final /* synthetic */ Collection val$result;
                        {
                            this.val$result = collection;
                        }

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2$2", "execute"));
                            }
                            if (state == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2$2", "execute"));
                            }
                            if (element instanceof PsiNamedElement) {
                                this.val$result.add(LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)element)).withIcon(QlReferenceImpl.getIcon(element)));
                            }
                            return true;
                        }
                    }, ResolveState.initial());
                    Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$2", "getVariants"));
                    }
                    return objectArray;
                }
            };
        }
        if (parent instanceof QlColumnExpression && (ref = (QlReferenceExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)o, QlReferenceExpression.class)) != null) {
            return new PsiPolyVariantReferenceBase<QlStringLiteral>(o, TextRange.create((int)1, (int)(o.getTextLength() - 1))){

                @NotNull
                public ResolveResult[] multiResolve(boolean incompleteCode) {
                    OrderedSet result = new OrderedSet();
                    BaseScopeProcessor processor = QlReferenceImpl.createResolveProcessor(model, unquote, (Collection<ResolveResult>)result, false);
                    QlReferenceImpl.processQualifierExpression(o.getProject(), ref, (PsiScopeProcessor)processor, ResolveState.initial(), o);
                    ResolveResult[] resolveResultArray = (ResolveResult[])ArrayUtil.toObjectArray((Collection)result, ResolveResult.class);
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$3", "multiResolve"));
                    }
                    return resolveResultArray;
                }

                @NotNull
                public Object[] getVariants() {
                    OrderedSet result = new OrderedSet();
                    BaseScopeProcessor processor = QlReferenceImpl.getCompletionProcessor((Collection<LookupElement>)result);
                    QlReferenceImpl.processQualifierExpression(o.getProject(), ref, (PsiScopeProcessor)processor, ResolveState.initial(), o);
                    Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil$3", "getVariants"));
                    }
                    return objectArray;
                }
            };
        }
        return null;
    }

    @NotNull
    public static List<QlExpression> getParameters(QlConstructorExpression o) {
        QlConstructorArgumentsList list = o.getConstructorArgumentsList();
        if (list == null) {
            List<QlExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "getParameters"));
            }
            return list2;
        }
        List<QlExpression> list3 = list.getExpressionList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "getParameters"));
        }
        return list3;
    }

    @NotNull
    public static List<PsiType> getParameterTypes(QlConstructorExpression o) {
        List<QlExpression> parameters = QlPsiImplUtil.getParameters(o);
        SmartList types = new SmartList();
        for (QlExpression parameter : parameters) {
            types.add(QlExpressionBaseImpl.getPsiType(parameter));
        }
        SmartList smartList = types;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "getParameterTypes"));
        }
        return smartList;
    }

    @Nullable
    public static PsiMethod resolveConstructor(@NotNull QlConstructorExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "resolveConstructor"));
        }
        return QlPsiImplUtil.resolveConstructor(o.getProject(), o.getPsiClass(), QlPsiImplUtil.getParameterTypes(o));
    }

    @Nullable
    public static PsiMethod resolveConstructor(@NotNull Project project, @Nullable PsiClass psiClass, @NotNull List<PsiType> typeList) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "resolveConstructor"));
        }
        if (typeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeList", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "resolveConstructor"));
        }
        if (psiClass == null) {
            return null;
        }
        PsiType[] types = typeList.toArray(PsiType.createArray((int)typeList.size()));
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
        block0: for (PsiMethod constructor : psiClass.getConstructors()) {
            if (constructor.getParameterList().getParametersCount() != types.length) continue;
            MethodSignature emptySignature = constructor.getSignature(PsiSubstitutor.EMPTY);
            PsiType[] parameterTypes = emptySignature.getParameterTypes();
            PsiTypeParameter[] typeParameters = (PsiTypeParameter[])ArrayUtil.mergeArrays((Object[])psiClass.getTypeParameters(), (Object[])constructor.getTypeParameters(), (ArrayFactory)PsiTypeParameter.ARRAY_FACTORY);
            MethodSignature targetSignature = typeParameters.length == 0 ? emptySignature : constructor.getSignature(helper.inferTypeArguments(typeParameters, parameterTypes, types, PsiUtil.getLanguageLevel((PsiElement)psiClass)));
            PsiType[] targetTypes = targetSignature.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != null && !targetTypes[i].isAssignableFrom(types[i])) continue block0;
            }
            return constructor;
        }
        return null;
    }

    @Nullable
    public static PsiClass getPsiClass(@NotNull QlConstructorExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlPsiImplUtil", "getPsiClass"));
        }
        QlReferenceExpression refExpression = o.getReferenceExpression();
        Object target = refExpression == null ? null : refExpression.resolve();
        return QlPsiImplUtil.getPsiClassInner(target);
    }

    @Nullable
    public static PsiClass getPsiClassInner(@Nullable Object target) {
        if (target instanceof PsiClass) {
            return (PsiClass)target;
        }
        if (target instanceof QlEntity) {
            return PsiTypesUtil.getPsiClass((PsiType)((QlEntity)target).getPsiType());
        }
        return null;
    }
}

