/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.GenerateSqlActions;
import com.intellij.database.actions.ManageDataSourcesAction;
import com.intellij.database.actions.OpenDbStorageAction;
import com.intellij.database.actions.RunQueryAction;
import com.intellij.database.actions.SynchronizeSchemaAction;
import com.intellij.database.console.RunSqlScriptAction;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.diff.CompareDbElementsAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.ui.PlaceProvider;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

public class DatabaseActionPromoter
implements ActionPromoter {
    public List<AnAction> promote(List<AnAction> actions, DataContext context) {
        Object place;
        if (DatabaseView.DATABASE_VIEW_KEY.getData(context) != null) {
            return ContainerUtil.findAll(actions, (Condition)Conditions.instanceOf((Class[])new Class[]{SynchronizeSchemaAction.class, ManageDataSourcesAction.class, GenerateSqlActions.CopyDdlAction.class, CompareDbElementsAction.class}));
        }
        Component contextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(context);
        if (grid != null && contextComponent != null && SwingUtilities.isDescendingFrom(contextComponent, grid.getPreferredFocusedComponent())) {
            return ContainerUtil.findAll(actions, (Condition)Conditions.instanceOf(GridAction.class));
        }
        if (EditorWindow.DATA_KEY.getData(context) != null) {
            return ContainerUtil.findAll(actions, (Condition)Conditions.instanceOf((Class[])new Class[]{RunQueryAction.class, RunSqlScriptAction.class}));
        }
        if (LangDataKeys.IDE_VIEW.getData(context) != null) {
            return ContainerUtil.findAll(actions, (Condition)Conditions.instanceOf(OpenDbStorageAction.class));
        }
        Object object = place = contextComponent instanceof PlaceProvider ? ((PlaceProvider)contextComponent).getPlace() : null;
        if ("StructureViewPopup".equals(place) || "StructureViewToolbar".equals(place)) {
            return ContainerUtil.findAll(actions, (Condition)Conditions.instanceOf(RunQueryAction.class));
        }
        return Collections.emptyList();
    }
}

