/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.Arrays;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEngine
extends DataRequest.Visitor
implements DataProducer,
Disposable {
    protected static final Logger LOG = Logger.getInstance(AbstractEngine.class);
    private final ThreadPoolExecutor myExecutorService;
    private final Project myProject;
    private final DataBus.Producing myMessageBus;
    private final DataAuditor myDataAuditor;
    private final DataConsumer myDataConsumer;
    private final AtomicReference<DataRequest.Context> myRequestContext;
    private final AtomicBoolean myCancelled;

    protected AbstractEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/AbstractEngine", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/console/AbstractEngine", "<init>"));
        }
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)StringUtil.getShortName((String)this.getClass().getName()));
        this.myRequestContext = new AtomicReference();
        this.myCancelled = new AtomicBoolean(false);
        this.myProject = project;
        this.myMessageBus = messageBus;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myDataAuditor = messageBus.getDataAuditor();
        this.myDataConsumer = messageBus.getDataConsumer();
        messageBus.addProducer(this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/AbstractEngine", "getProject"));
        }
        return project;
    }

    @NotNull
    protected DataAuditor getDataAuditor() {
        DataAuditor dataAuditor = this.myDataAuditor;
        if (dataAuditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/AbstractEngine", "getDataAuditor"));
        }
        return dataAuditor;
    }

    @NotNull
    protected DataConsumer getDataConsumer() {
        DataConsumer dataConsumer = this.myDataConsumer;
        if (dataConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/AbstractEngine", "getDataConsumer"));
        }
        return dataConsumer;
    }

    @NotNull
    protected DataRequest.Context getRequestContext() {
        DataRequest.Context context = this.myRequestContext.get();
        if (context == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/AbstractEngine", "getRequestContext"));
        }
        return context;
    }

    @Nullable
    protected DataRequest.Context getRequestContextIfAny() {
        return this.myRequestContext.get();
    }

    @Override
    public void processRequest(@NotNull DataRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/AbstractEngine", "processRequest"));
        }
        request.accept(this);
    }

    @Override
    public void visitCancel(DataRequest.Cancel r) {
        if (!this.cancelPendingRequests()) {
            this.terminate();
        }
    }

    @Override
    public void visitRequest(DataRequest r) {
        LOG.error("unknown request: " + r);
    }

    public final void dispose() {
        this.myMessageBus.beforeProducerRemove(this);
        this.submitRunnable(this::releaseConnection);
        this.submitRunnable(() -> this.myMessageBus.afterProducerRemove(this));
        this.cancelAndPassThroughRemainingRequests();
        this.myExecutorService.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutorService.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void releaseConnection() {
    }

    public boolean isDisposed() {
        return this.myExecutorService.isShutdown();
    }

    public void terminate() {
        this.cancelPendingRequests();
    }

    protected boolean cancelPendingRequests() {
        this.cancelAndPassThroughRemainingRequests();
        return true;
    }

    private void cancelAndPassThroughRemainingRequests() {
        if (this.myCancelled.compareAndSet(false, true)) {
            this.submitRunnable(() -> this.myCancelled.compareAndSet(true, false));
        }
    }

    @NotNull
    protected abstract DataRequest.Context createRequestContext(@NotNull DataRequest var1);

    protected void submitRunnable(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/console/AbstractEngine", "submitRunnable"));
        }
        this.myExecutorService.submit(runnable);
    }

    private void submitRunnable(DataRequest request, Computable<Boolean> runnable) {
        this.getDataAuditor().jobSubmitted(request, this);
        this.submitRunnable(() -> {
            boolean result = false;
            try {
                if (this.myCancelled.get()) {
                    return;
                }
                result = (Boolean)runnable.compute();
            }
            finally {
                if (ApplicationManager.getApplication().isDisposeInProgress()) {
                    return;
                }
                try {
                    this.getDataAuditor().jobFinished(request, this);
                }
                finally {
                    DbImplUtil.setActionCallbackDone(request.getPromise(), result);
                }
            }
        });
    }

    protected void submitRequest(@NotNull DataRequest request, @NotNull ThrowableComputable<Boolean, Exception> computable) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/AbstractEngine", "submitRequest"));
        }
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/console/AbstractEngine", "submitRequest"));
        }
        this.submitRunnable(request, (Computable<Boolean>)((Computable)() -> {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/AbstractEngine", "lambda$submitRequest$3"));
            }
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/console/AbstractEngine", "lambda$submitRequest$3"));
            }
            boolean result = false;
            DataRequest.Context context = null;
            try {
                context = this.createRequestContext(request);
                this.myRequestContext.set(context);
                result = (Boolean)computable.compute();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                if (context == null) {
                    LOG.error(e);
                } else if (!this.myCancelled.get()) {
                    try {
                        context.reportException(e, null);
                    }
                    catch (Exception e1) {
                        LOG.error((Throwable)new CompoundRuntimeException(Arrays.asList(e, e1)));
                    }
                }
            }
            finally {
                this.myRequestContext.compareAndSet(context, null);
            }
            return result;
        }));
    }
}

