/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="csv-format")
public class PersistentCsvFormat {
    @Attribute(value="name")
    public String name;
    @Tag(value="data")
    public Record data;
    @Tag(value="header")
    public Record header;
    @Attribute(value="row-numbers")
    public boolean rowNumbers;

    public PersistentCsvFormat() {
        this("");
    }

    public PersistentCsvFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/PersistentCsvFormat", "<init>"));
        }
        this(format.name, format);
    }

    public PersistentCsvFormat(@NotNull String name, @NotNull CsvFormat format) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/csv/PersistentCsvFormat", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/PersistentCsvFormat", "<init>"));
        }
        this(name);
        this.data = new Record(format.dataRecord);
        this.header = format.headerRecord != null ? new Record(format.headerRecord) : null;
        this.rowNumbers = format.rowNumbers;
    }

    private PersistentCsvFormat(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/csv/PersistentCsvFormat", "<init>"));
        }
        this.name = name;
    }

    @Nullable
    public CsvFormat immutable() {
        if (!this.isValid()) {
            return null;
        }
        String name = (String)ObjectUtils.assertNotNull((Object)this.name);
        CsvRecordFormat dataFormat = (CsvRecordFormat)ObjectUtils.assertNotNull((Object)this.data.immutable());
        CsvRecordFormat header = this.header != null ? (CsvRecordFormat)ObjectUtils.assertNotNull((Object)this.header.immutable()) : null;
        return new CsvFormat(name, dataFormat, header, this.rowNumbers);
    }

    private boolean isValid() {
        return this.name != null && this.data != null && this.data.isValid() && (this.header == null || this.header.isValid());
    }

    @Tag(value="quotes")
    public static class Quotes {
        @Attribute(value="left")
        public String left;
        @Attribute(value="right")
        public String right;
        @Attribute(value="leftEscaped")
        public String leftEscaped;
        @Attribute(value="rightEscaped")
        public String rightEscaped;

        public Quotes() {
        }

        public Quotes(@NotNull CsvRecordFormat.Quotes quotes) {
            if (quotes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/csv/PersistentCsvFormat$Quotes", "<init>"));
            }
            this.left = quotes.leftQuote;
            this.right = quotes.rightQuote;
            this.leftEscaped = quotes.leftQuoteEscaped;
            this.rightEscaped = quotes.rightQuoteEscaped;
        }

        private boolean isValid() {
            return this.left != null && this.right != null && this.leftEscaped != null && this.rightEscaped != null;
        }
    }

    @Tag(value="record-format")
    public static class Record {
        private static String QUOTATION_POLICY_ALWAYS = "always";
        private static String QUOTATION_POLICY_AS_NEEDED = "as needed";
        @Attribute(value="prefix")
        public String prefix;
        @Attribute(value="suffix")
        public String suffix;
        @Attribute(value="nullText")
        public String nullText;
        @Attribute(value="quotationPolicy")
        public String quotationPolicy;
        @Attribute(value="valueSeparator")
        public String valueSeparator;
        @Attribute(value="recordSeparator")
        public String recordSeparator;
        @Attribute(value="trimWhitespace")
        public boolean trimWhitespace;
        @Tag(value="quotation")
        @AbstractCollection(surroundWithTag=false, elementTypes={Quotes.class})
        public List<Quotes> quotes;

        public Record() {
            this.quotes = ContainerUtil.newArrayList();
        }

        public Record(@NotNull CsvRecordFormat record) {
            if (record == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/database/csv/PersistentCsvFormat$Record", "<init>"));
            }
            this.quotes = ContainerUtil.newArrayList();
            this.prefix = record.prefix;
            this.suffix = record.suffix;
            this.nullText = record.nullText;
            this.quotationPolicy = Record.valueOfQuotationPolicy(record.quotationPolicy);
            this.valueSeparator = record.valueSeparator;
            this.recordSeparator = record.recordSeparator;
            this.trimWhitespace = record.trimWhitespace;
            this.quotes = ContainerUtil.map(record.quotes, quotes1 -> new Quotes((CsvRecordFormat.Quotes)quotes1));
        }

        @NotNull
        private CsvRecordFormat immutable() {
            CsvRecordFormat.QuotationPolicy qp = (CsvRecordFormat.QuotationPolicy)((Object)ObjectUtils.assertNotNull((Object)((Object)Record.quotationPolicy(this.quotationPolicy))));
            ImmutableList immutableQuotes = ContainerUtil.immutableList((List)ContainerUtil.map(this.quotes, quotes1 -> new CsvRecordFormat.Quotes(quotes1.left, quotes1.right, quotes1.leftEscaped, quotes1.rightEscaped)));
            CsvRecordFormat csvRecordFormat = new CsvRecordFormat(this.prefix, this.suffix, this.nullText, (List<CsvRecordFormat.Quotes>)immutableQuotes, qp, this.valueSeparator, this.recordSeparator, this.trimWhitespace);
            if (csvRecordFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/PersistentCsvFormat$Record", "immutable"));
            }
            return csvRecordFormat;
        }

        private boolean isValid() {
            return this.prefix != null && this.suffix != null && Record.quotationPolicy(this.quotationPolicy) != null && this.valueSeparator != null && this.recordSeparator != null && this.quotes != null && ContainerUtil.find(this.quotes, quotes1 -> quotes1 == null || !((Quotes)quotes1).isValid()) == null;
        }

        @Nullable
        private static CsvRecordFormat.QuotationPolicy quotationPolicy(@NotNull String qp) {
            if (qp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qp", "com/intellij/database/csv/PersistentCsvFormat$Record", "quotationPolicy"));
            }
            return QUOTATION_POLICY_AS_NEEDED.equals(qp) ? CsvRecordFormat.QuotationPolicy.AS_NEEDED : (QUOTATION_POLICY_ALWAYS.equals(qp) ? CsvRecordFormat.QuotationPolicy.ALWAYS : null);
        }

        @NotNull
        private static String valueOfQuotationPolicy(@NotNull CsvRecordFormat.QuotationPolicy policy) {
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/database/csv/PersistentCsvFormat$Record", "valueOfQuotationPolicy"));
            }
            switch (policy) {
                case ALWAYS: {
                    String string = QUOTATION_POLICY_ALWAYS;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/PersistentCsvFormat$Record", "valueOfQuotationPolicy"));
                    }
                    return string;
                }
                case AS_NEEDED: {
                    String string = QUOTATION_POLICY_AS_NEEDED;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/PersistentCsvFormat$Record", "valueOfQuotationPolicy"));
                    }
                    return string;
                }
            }
            throw new AssertionError((Object)policy);
        }
    }
}

