/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.database.dataSource.url.ui.CheckBoxParamEditor;
import com.intellij.database.dataSource.url.ui.ComboBoxParamEditor;
import com.intellij.database.dataSource.url.ui.DatabaseParamEditor;
import com.intellij.database.dataSource.url.ui.LocalDbParamEditor;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.SsrpHostParamEditor;
import com.intellij.database.dataSource.url.ui.SsrpInstanceParamEditor;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.dataSource.url.ui.TnsNamesParamEditor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypesRegistry
implements TextDecomposition.PatternFactory {
    public static final String HOST_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.]]+";
    public static final String IPV6_COLON_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}";
    public static final String IPV6_DOT_QUAD_PATTERN = "(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}";
    public static final String IPV6_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}|(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}";
    public static final String HOST_N_IPV6_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}|(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}|[\\p{L}\\p{M}\\p{N}[-_.]]+";
    public static final String PARAMETER_PATTERN = "[^;=&]+";
    public static final String PORT_PATTERN = "[\\p{N}]{1,5}";
    public static final String DB_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.]]+";
    public static final String FILE_PATH_PATTERN = "(?!//)[^;?&]+?|/";
    public static final String USER_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.]]+";
    public static final String PASSWORD_PATERN = "[\\p{L}\\p{M}\\p{N}[-_.]]+";
    public static final String PATH_PATTERN = "(?!//)[^;?&]+?|/";
    public static final String IDENTIFIER_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.]]+";
    public static final TypesRegistry INSTANCE = new TypesRegistry();
    private final Map<String, TypeDescriptor> myTypes = new HashMap<String, TypeDescriptor>();

    @Override
    @Nullable
    public Pattern getPattern(@NotNull String type, @Nullable String configuration) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dataSource/url/TypesRegistry", "getPattern"));
        }
        TypeDescriptor descriptor = this.myTypes.get(type);
        return descriptor == null ? null : descriptor.getPattern(configuration);
    }

    public void put(@NotNull TypeDescriptor desc) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/dataSource/url/TypesRegistry", "put"));
        }
        TypeDescriptor prev = this.myTypes.put(desc.getName(), desc);
        assert (prev == null);
    }

    @Nullable
    public TypeDescriptor get(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dataSource/url/TypesRegistry", "get"));
        }
        return this.myTypes.get(type);
    }

    private TypesRegistry() {
        this.put(new TextFieldTypeDescriptor("identifier", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "Identifier"));
        this.put(new TextFieldTypeDescriptor("param", PARAMETER_PATTERN, "Parameter"));
        this.put(new TextFieldTypeDescriptor("user", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "User"));
        this.put(new TextFieldTypeDescriptor("password", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "Password"));
        this.put(new TextFieldTypeDescriptor("host", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "Host"));
        this.put(new SsrpHostTypeDescriptor("ssrp_host", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "Host"));
        this.put(new SsrpInstanceTypeDescriptor("ssrp_instance", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "Instance"));
        this.put(new TextFieldTypeDescriptor("host_ipv6", HOST_N_IPV6_PATTERN, "Host"));
        this.put(new SsrpHostTypeDescriptor("ssrp_host_ipv6", HOST_N_IPV6_PATTERN, "Host"));
        this.put(new TextFieldTypeDescriptor("ipv6", IPV6_PATTERN, "Host"));
        this.put(new TextFieldTypeDescriptor("port", PORT_PATTERN, "Port", ParamEditor.FieldSize.SMALL, new AnAction[0]));
        this.put(new DatabaseTypeDescriptor("database", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "Database"));
        this.put(new TextFieldTypeDescriptor("file", "(?!//)[^;?&]+?|/", "File", ParamEditor.FieldSize.LARGE, TypesRegistry.getSelectDbAction(true), TypesRegistry.getCreateDbAction()));
        this.put(new TextFieldTypeDescriptor("path", "(?!//)[^;?&]+?|/", "Path", ParamEditor.FieldSize.LARGE, TypesRegistry.getSelectDbAction(false)));
        this.put(new TextFieldTypeDescriptor("path_db", "(?!//)[^;?&]+?|/", "Path", ParamEditor.FieldSize.LARGE, TypesRegistry.getSelectDbPathFileAction()));
        this.put(new TnsNameTypeDescriptor("tns_name", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "TNS name"));
        this.put(new TextCBTypeDescriptor("true_box", "true", "", "[\\p{L}\\p{M}\\p{N}[-_.]]+", "true", "false|", "True box"));
        this.put(new LocalDBTypeDescriptor("localdb_pipe", "Instance"));
        this.put(new ComboBoxTypeDescriptor("variants", "Variants"));
    }

    private static AnAction getSelectDbPathFileAction() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false);
        descriptor.setHideIgnored(false);
        descriptor.setTitle("Choose Database File Or Path");
        return new ParamEditorBase.FMChooseAction(descriptor){

            @Override
            protected void setFile(@NotNull ParamEditorBase editor, @NotNull VirtualFile file) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dataSource/url/TypesRegistry$1", "setFile"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/url/TypesRegistry$1", "setFile"));
                }
                if (file.isDirectory()) {
                    super.setFile(editor, file);
                    return;
                }
                editor.setText(file.getParent().getPath());
                editor.getInterchange().putProperty("database", file.getNameWithoutExtension());
            }
        };
    }

    private static AnAction getSelectDbAction(boolean file) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(file, !file, false, false, false, false);
        descriptor.setHideIgnored(false);
        descriptor.setTitle("Choose Database " + (file ? "File" : "Path"));
        return new ParamEditorBase.FMChooseAction(descriptor);
    }

    private static AnAction getCreateDbAction() {
        FileSaverDescriptor descriptor = new FileSaverDescriptor("New Database", "Choose database file path and name", new String[0]);
        return new ParamEditorBase.FMSaveAction(descriptor);
    }

    private static abstract class BaseTypeDescriptor
    implements TypeDescriptor {
        private final String myRegex;
        private final String myName;
        private final String myDefaultCaption;

        public BaseTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "<init>"));
            }
            this.myRegex = regex;
            this.myName = name;
            this.myDefaultCaption = defaultCaption;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "getName"));
            }
            return string;
        }

        @NotNull
        protected static String formatFieldCaption(@NotNull String caption) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "formatFieldCaption"));
            }
            String string = caption + ":";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "formatFieldCaption"));
            }
            return string;
        }

        @NotNull
        protected String formatCaption(@NotNull String param) {
            if (param == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "formatCaption"));
            }
            String string = param.equals(this.myName) ? this.myDefaultCaption : StringUtil.capitalize((String)param);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "formatCaption"));
            }
            return string;
        }

        @Override
        @NotNull
        public ParamEditor createField(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "createField"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "createField"));
            }
            ParamEditor paramEditor = this.createFieldImpl(this.formatCaption(caption), configuration, interchange);
            if (paramEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "createField"));
            }
            return paramEditor;
        }

        @NotNull
        protected abstract ParamEditor createFieldImpl(@NotNull String var1, @Nullable String var2, @NotNull DataInterchange var3);

        @Override
        @NotNull
        public Collection<ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "createSatellites"));
            }
            List<ParamEditor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "createSatellites"));
            }
            return list;
        }

        @Override
        @NotNull
        public Pattern getPattern(@Nullable String configuration) {
            Pattern pattern = Pattern.compile(this.myRegex);
            if (pattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "getPattern"));
            }
            return pattern;
        }

        @Override
        @Nullable
        public String getCaption(@NotNull String param) {
            if (param == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor", "getCaption"));
            }
            return BaseTypeDescriptor.formatFieldCaption(this.formatCaption(param));
        }
    }

    private static class LocalDBTypeDescriptor
    extends BaseTypeDescriptor {
        public LocalDBTypeDescriptor(@NotNull String name, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$LocalDBTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$LocalDBTypeDescriptor", "<init>"));
            }
            super(name, "[\\p{L}\\p{M}\\p{N}[-_.]]+#\\p{XDigit}+|" + Pattern.quote("<pipe name>"), defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$LocalDBTypeDescriptor", "createFieldImpl"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$LocalDBTypeDescriptor", "createFieldImpl"));
            }
            LocalDbParamEditor localDbParamEditor = new LocalDbParamEditor(LocalDBTypeDescriptor.formatFieldCaption(caption), interchange);
            if (localDbParamEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$LocalDBTypeDescriptor", "createFieldImpl"));
            }
            return localDbParamEditor;
        }

        @Override
        @NotNull
        public Collection<ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$LocalDBTypeDescriptor", "createSatellites"));
            }
            List<ParamEditor> list = Collections.singletonList(new LocalDbParamEditor.LocalDbExecParamEditor(interchange));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$LocalDBTypeDescriptor", "createSatellites"));
            }
            return list;
        }
    }

    private static class TnsNameTypeDescriptor
    extends BaseTypeDescriptor {
        public TnsNameTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$TnsNameTypeDescriptor", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/database/dataSource/url/TypesRegistry$TnsNameTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$TnsNameTypeDescriptor", "<init>"));
            }
            super(name, regex, defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$TnsNameTypeDescriptor", "createFieldImpl"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$TnsNameTypeDescriptor", "createFieldImpl"));
            }
            TnsNamesParamEditor tnsNamesParamEditor = new TnsNamesParamEditor(TnsNameTypeDescriptor.formatFieldCaption(caption), interchange);
            if (tnsNamesParamEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$TnsNameTypeDescriptor", "createFieldImpl"));
            }
            return tnsNamesParamEditor;
        }

        @Override
        @NotNull
        public Collection<ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$TnsNameTypeDescriptor", "createSatellites"));
            }
            Collection<ParamEditor> collection = TnsNamesParamEditor.createSatellites(interchange);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$TnsNameTypeDescriptor", "createSatellites"));
            }
            return collection;
        }
    }

    private static class DatabaseTypeDescriptor
    extends BaseTypeDescriptor {
        public DatabaseTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor", "<init>"));
            }
            super(name, regex, defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor", "createFieldImpl"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor", "createFieldImpl"));
            }
            SqlLanguageDialect language = DatabaseDriverImpl.getLanguage(interchange.getDriver());
            if (language == null || !((DatabaseDialectEx)language.getDatabaseDialect()).supportsLoadDatabaseList()) {
                TextParamEditor textParamEditor = new TextParamEditor(interchange, this.formatCaption(caption), ParamEditor.FieldSize.MEDIUM, new AnAction[0]);
                if (textParamEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor", "createFieldImpl"));
                }
                return textParamEditor;
            }
            DatabaseParamEditor databaseParamEditor = new DatabaseParamEditor(DatabaseTypeDescriptor.formatFieldCaption(caption), interchange);
            if (databaseParamEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor", "createFieldImpl"));
            }
            return databaseParamEditor;
        }
    }

    private static class TextFieldTypeDescriptor
    extends BaseTypeDescriptor {
        private final ParamEditor.FieldSize myFieldSize;
        private final AnAction[] myActions;

        public TextFieldTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "<init>"));
            }
            this(name, regex, defaultCaption, ParamEditor.FieldSize.MEDIUM, new AnAction[0]);
        }

        public TextFieldTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption, @NotNull ParamEditor.FieldSize fieldSize, AnAction ... actions) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "<init>"));
            }
            if (fieldSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldSize", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "<init>"));
            }
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "<init>"));
            }
            super(name, regex, defaultCaption);
            this.myActions = actions;
            this.myFieldSize = fieldSize;
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "createFieldImpl"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "createFieldImpl"));
            }
            TextParamEditor textParamEditor = new TextParamEditor(interchange, TextFieldTypeDescriptor.formatFieldCaption(caption), this.myFieldSize, this.myActions);
            if (textParamEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor", "createFieldImpl"));
            }
            return textParamEditor;
        }
    }

    private static class SsrpInstanceTypeDescriptor
    extends BaseTypeDescriptor {
        public SsrpInstanceTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$SsrpInstanceTypeDescriptor", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/database/dataSource/url/TypesRegistry$SsrpInstanceTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$SsrpInstanceTypeDescriptor", "<init>"));
            }
            super(name, regex, defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$SsrpInstanceTypeDescriptor", "createFieldImpl"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$SsrpInstanceTypeDescriptor", "createFieldImpl"));
            }
            SsrpInstanceParamEditor ssrpInstanceParamEditor = new SsrpInstanceParamEditor(SsrpInstanceTypeDescriptor.formatFieldCaption(caption), interchange);
            if (ssrpInstanceParamEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$SsrpInstanceTypeDescriptor", "createFieldImpl"));
            }
            return ssrpInstanceParamEditor;
        }
    }

    private static class SsrpHostTypeDescriptor
    extends BaseTypeDescriptor {
        public SsrpHostTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$SsrpHostTypeDescriptor", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/database/dataSource/url/TypesRegistry$SsrpHostTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$SsrpHostTypeDescriptor", "<init>"));
            }
            super(name, regex, defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$SsrpHostTypeDescriptor", "createFieldImpl"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$SsrpHostTypeDescriptor", "createFieldImpl"));
            }
            SsrpHostParamEditor ssrpHostParamEditor = new SsrpHostParamEditor(SsrpHostTypeDescriptor.formatFieldCaption(caption), interchange);
            if (ssrpHostParamEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$SsrpHostTypeDescriptor", "createFieldImpl"));
            }
            return ssrpHostParamEditor;
        }
    }

    private static class TextCBTypeDescriptor
    extends BaseTypeDescriptor {
        private final String myTrueValue;
        private final String myFalseValue;
        private final Pattern myTrueRegexp;
        private final Pattern myFalseRegexp;

        public TextCBTypeDescriptor(@NotNull String name, @NotNull String trueValue, @NotNull String falseValue, @NotNull String regex, @NotNull String trueRegex, @NotNull String falseRegex, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "<init>"));
            }
            if (trueValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueValue", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "<init>"));
            }
            if (falseValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "falseValue", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "<init>"));
            }
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "<init>"));
            }
            if (trueRegex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueRegex", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "<init>"));
            }
            if (falseRegex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "falseRegex", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "<init>"));
            }
            super(name, regex, defaultCaption);
            this.myTrueValue = trueValue;
            this.myFalseValue = falseValue;
            this.myTrueRegexp = PatternBuilder.compile(trueRegex);
            this.myFalseRegexp = PatternBuilder.compile(falseRegex);
        }

        @Override
        @Nullable
        public String getCaption(@NotNull String param) {
            if (param == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "getCaption"));
            }
            return null;
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "createFieldImpl"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "createFieldImpl"));
            }
            CheckBoxParamEditor checkBoxParamEditor = new CheckBoxParamEditor(interchange, caption, this.myTrueValue, this.myFalseValue, this.myTrueRegexp, this.myFalseRegexp);
            if (checkBoxParamEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor", "createFieldImpl"));
            }
            return checkBoxParamEditor;
        }
    }

    private static class ComboBoxTypeDescriptor
    extends BaseTypeDescriptor {
        public ComboBoxTypeDescriptor(@NotNull String name, @NotNull String defaultCaption) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor", "<init>"));
            }
            if (defaultCaption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCaption", "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor", "<init>"));
            }
            super(name, "", defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor", "createFieldImpl"));
            }
            if (interchange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor", "createFieldImpl"));
            }
            ComboBoxParamEditor comboBoxParamEditor = new ComboBoxParamEditor(interchange, ComboBoxTypeDescriptor.formatFieldCaption(caption), configuration);
            if (comboBoxParamEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor", "createFieldImpl"));
            }
            return comboBoxParamEditor;
        }

        @Override
        @NotNull
        public Pattern getPattern(@Nullable String configuration) {
            Pattern pattern = ComboBoxParamEditor.getPattern(configuration);
            Pattern pattern2 = pattern == null ? super.getPattern(configuration) : pattern;
            if (pattern2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor", "getPattern"));
            }
            return pattern2;
        }
    }

    public static interface TypeDescriptor {
        @NotNull
        public String getName();

        @NotNull
        public ParamEditor createField(@NotNull String var1, @Nullable String var2, @NotNull DataInterchange var3);

        @NotNull
        public Collection<ParamEditor> createSatellites(@NotNull DataInterchange var1);

        @NotNull
        public Pattern getPattern(@Nullable String var1);

        @Nullable
        public String getCaption(@NotNull String var1);
    }

    public static interface ParamEditor
    extends Disposable {
        @NotNull
        public String getText();

        public void setText(@NotNull String var1);

        public void addFocusListener(@NotNull FocusListener var1);

        @NotNull
        public JComponent getComponent();

        @Nullable
        public String getCaption();

        public FieldSize getFieldSize();

        public void setChangeListener(@NotNull Runnable var1);

        public JComponent getEditorComponent();

        public void setActive(boolean var1);

        public static enum FieldSize {
            SMALL,
            MEDIUM,
            LARGE;

        }
    }
}

