/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.CsvLexer;
import com.intellij.database.datagrid.StreamCsvFormatParser;
import com.intellij.database.dbimport.ImportDatabaseModifier;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.OffsetBatchRecords;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntLongHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvInput
implements ReaderTask.Input {
    private final ThrowableComputable<InputStream, IOException> myStream;
    private final Charset myCharset;
    private final long mySizeInBytes;
    private final double myBytesPerChar;
    private final ParserChooser myChooser;
    private BufferedReader myReader;
    private CsvInputParser myParser;

    public CsvInput(@NotNull ThrowableComputable<InputStream, IOException> stream, @NotNull Charset charset, @NotNull ImportInfo info, int charCountToRead, long bytes) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/database/dbimport/csv/CsvInput", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/csv/CsvInput", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/csv/CsvInput", "<init>"));
        }
        this.myStream = stream;
        this.myBytesPerChar = charset.newEncoder().averageBytesPerChar();
        this.myCharset = charset;
        this.myChooser = new ParserChooser((CsvFormat)ObjectUtils.assertNotNull((Object)info.getFormat()), charCountToRead);
        this.mySizeInBytes = bytes;
    }

    @Override
    @Nullable
    public ReaderTask.Result read() throws InterruptedException, IOException {
        if (this.myReader == null) {
            this.myReader = new BufferedReader(new InputStreamReader((InputStream)this.myStream.compute(), this.myCharset));
        }
        if (this.myParser == null) {
            this.myParser = this.myChooser.create(this.myReader);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        StreamCsvFormatParser.CsvParserResult result = this.myParser.parse(this.myReader);
        if (result == null) {
            return null;
        }
        List<StreamCsvFormatParser.Token[]> tokens = result.getRecords();
        return new ReaderTask.ResultImpl(CsvInput.createBatch(tokens, (double)result.getCharacters() * this.myBytesPerChar), result.getErrors());
    }

    @Override
    @NotNull
    public ImportDatabaseModifier.IndicatorUpdater getIndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder adder, @NotNull ImportInfo info) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/csv/CsvInput", "getIndicatorUpdater"));
        }
        if (adder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adder", "com/intellij/database/dbimport/csv/CsvInput", "getIndicatorUpdater"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/csv/CsvInput", "getIndicatorUpdater"));
        }
        ImportDatabaseModifier.IndicatorUpdater indicatorUpdater = new ImportDatabaseModifier.IndicatorUpdater(indicator, adder, info){

            @Override
            @Nullable
            public String calculateSpeed(long timeSpent) {
                long size = Math.round(this.myCurrentSize / (double)timeSpent);
                return size == 0L ? null : String.format("%s/s", StringUtil.formatFileSize((long)size));
            }
        };
        if (indicatorUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInput", "getIndicatorUpdater"));
        }
        return indicatorUpdater;
    }

    @Override
    public void calculateSize(@NotNull Consumer<Double> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/dbimport/csv/CsvInput", "calculateSize"));
        }
        callback.consume((Object)this.mySizeInBytes);
    }

    @Override
    public void close() {
        if (this.myReader == null) {
            return;
        }
        try {
            this.myReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static BatchRecords createBatch(@NotNull List<StreamCsvFormatParser.Token[]> tokens, double size) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/database/dbimport/csv/CsvInput", "createBatch"));
        }
        ArrayList objects = ContainerUtil.newArrayList();
        TIntLongHashMap lines = new TIntLongHashMap();
        TIntLongHashMap offsets = new TIntLongHashMap();
        for (Object[] objectArray : tokens) {
            StreamCsvFormatParser.Token first = (StreamCsvFormatParser.Token)ArrayUtil.getFirstElement((Object[])objectArray);
            long lineNumber = ((StreamCsvFormatParser.Token)ObjectUtils.assertNotNull((Object)first)).getLine();
            long charNumber = ((StreamCsvFormatParser.Token)ObjectUtils.assertNotNull((Object)first)).getOffset();
            lines.put(objects.size(), lineNumber);
            offsets.put(objects.size(), charNumber);
            objects.add(ContainerUtil.map((Object[])objectArray, StreamCsvFormatParser.Token::getText, (Object[])new String[0]));
        }
        MyRecords myRecords = new MyRecords(objects, lines, offsets, tokens, size);
        if (myRecords == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInput", "createBatch"));
        }
        return myRecords;
    }

    private static class MyFormatParser
    implements CsvInputParser {
        private final StreamCsvFormatParser myParser;

        private MyFormatParser(@NotNull CsvFormat format, int maxChars) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/csv/CsvInput$MyFormatParser", "<init>"));
            }
            this.myParser = new StreamCsvFormatParser(format, maxChars);
        }

        @Override
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse(@NotNull Reader reader) throws IOException {
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dbimport/csv/CsvInput$MyFormatParser", "parse"));
            }
            return this.myParser.parse(reader);
        }
    }

    private static class MyOneLineParser
    implements CsvInputParser {
        private boolean myEnd;

        private MyOneLineParser() {
        }

        @Override
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse(@NotNull Reader reader) throws IOException {
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dbimport/csv/CsvInput$MyOneLineParser", "parse"));
            }
            if (this.myEnd) {
                return null;
            }
            this.myEnd = true;
            char[] buffer = new char[0x500000];
            int count = reader.read(buffer);
            if (count == -1) {
                return null;
            }
            String string = String.valueOf(buffer, 0, count);
            int length = string.length();
            StreamCsvFormatParser.Token token = new StreamCsvFormatParser.Token(string, CsvLexer.TokenType.VALUE, 0L, 0L, 0L, length);
            StreamCsvFormatParser.Token[] tokens = new StreamCsvFormatParser.Token[]{token};
            List<StreamCsvFormatParser.Token[]> list = Collections.singletonList(tokens);
            return new StreamCsvFormatParser.CsvParserResult(tokens, list, MyOneLineParser.getError(reader, string.substring(0, Math.min(string.length(), 10000))), length);
        }

        @NotNull
        private static List<ErrorRecord> getError(@NotNull Reader r, @NotNull String text) throws IOException {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/dbimport/csv/CsvInput$MyOneLineParser", "getError"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dbimport/csv/CsvInput$MyOneLineParser", "getError"));
            }
            int value = r.read();
            if (value == -1) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInput$MyOneLineParser", "getError"));
                }
                return list;
            }
            StreamCsvFormatParser.MaxCharactersReachedException exception = new StreamCsvFormatParser.MaxCharactersReachedException(text);
            OffsetBatchRecords.OffsetRecord record = new OffsetBatchRecords.OffsetRecord((Exception)exception, 0L, 0L);
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new ErrorRecord[]{record});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInput$MyOneLineParser", "getError"));
            }
            return arrayList;
        }
    }

    private static class ParserChooser {
        private final CsvFormat myFormat;
        private final int myMaxChars;

        private ParserChooser(@NotNull CsvFormat format, int chars) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/csv/CsvInput$ParserChooser", "<init>"));
            }
            this.myFormat = format;
            this.myMaxChars = chars;
        }

        @NotNull
        CsvInputParser create(@NotNull Reader reader) throws IOException {
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dbimport/csv/CsvInput$ParserChooser", "create"));
            }
            CsvFormatParser parser = new CsvFormatParser(this.myFormat);
            String line = CsvLexer.readAhead(reader, 10000);
            CsvDocumentDataHookUp.CsvMarkup markup = parser.parse(line);
            CsvInputParser csvInputParser = markup == null ? new MyOneLineParser() : new MyFormatParser(this.myFormat, this.myMaxChars);
            if (csvInputParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInput$ParserChooser", "create"));
            }
            return csvInputParser;
        }
    }

    private static interface CsvInputParser {
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse(@NotNull Reader var1) throws IOException;
    }

    private static class MyRecords
    extends OffsetBatchRecords {
        private final List<StreamCsvFormatParser.Token[]> myTokens;

        public MyRecords(@NotNull List<Object[]> records, @NotNull TIntLongHashMap lines, @NotNull TIntLongHashMap startOffsets, @NotNull List<StreamCsvFormatParser.Token[]> tokens, double size) {
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/csv/CsvInput$MyRecords", "<init>"));
            }
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/database/dbimport/csv/CsvInput$MyRecords", "<init>"));
            }
            if (startOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startOffsets", "com/intellij/database/dbimport/csv/CsvInput$MyRecords", "<init>"));
            }
            if (tokens == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/database/dbimport/csv/CsvInput$MyRecords", "<init>"));
            }
            super(records, lines, startOffsets, size);
            this.myTokens = tokens;
        }

        @NotNull
        public ErrorRecord getErrorRecord(@NotNull Exception e, int idx) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dbimport/csv/CsvInput$MyRecords", "getErrorRecord"));
            }
            if (!(e instanceof ImportInfo.ConversionException)) {
                ErrorRecord errorRecord = super.getErrorRecord(e, idx);
                if (errorRecord == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInput$MyRecords", "getErrorRecord"));
                }
                return errorRecord;
            }
            int tokenIndex = ((ImportInfo.ConversionException)e).getIndex();
            StreamCsvFormatParser.Token[] tokens = this.myTokens.get(idx);
            StreamCsvFormatParser.Token token = tokens[tokenIndex];
            OffsetBatchRecords.OffsetRecord offsetRecord = new OffsetBatchRecords.OffsetRecord(e, this.getLineNumber(idx), token.getOffset());
            if (offsetRecord == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/csv/CsvInput$MyRecords", "getErrorRecord"));
            }
            return offsetRecord;
        }
    }
}

