/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.component;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.ModelTraverserEx;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlPreviewComponent
implements ImportComponent<ImportDatabaseTableEditor<?>, Object> {
    private final DdlPreview myDdlPreview;
    private final TableDialogSettings.Settings mySettings;
    private final ImportAction.ImportEditorContext myContext;

    public DdlPreviewComponent(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "<init>"));
        }
        this.myContext = context;
        Project project = this.myContext.getProject();
        this.mySettings = this.myContext.getBuilder().getImportType().getCodeGenerationSettings();
        this.myDdlPreview = new DdlPreview(this.myContext, DdlPreviewComponent.createProcessor((Project)ObjectUtils.assertNotNull((Object)project)));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myDdlPreview.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "getComponent"));
        }
        return jComponent;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "build"));
        }
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "isVisible"));
        }
        return true;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "addListener"));
        }
    }

    @Override
    @NotNull
    public CompletionStage<Object> notifyChanged(@Nullable ImportDatabaseTableEditor<?> object) {
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        if (object == null) {
            CompletableFuture<Object> completableFuture = future;
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "notifyChanged"));
            }
            return completableFuture;
        }
        this.myDdlPreview.updatePreview(new ModelTraverserEx(this.mySettings, object.getTableModel(), this.myContext.getModel()));
        CompletableFuture<Object> completableFuture = future;
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "notifyChanged"));
        }
        return completableFuture;
    }

    @NotNull
    private static Function<Runnable, ActionCallback> createProcessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "createProcessor"));
        }
        Function<Runnable, ActionCallback> function = DatabaseDialogsHelper.createAsyncProcessor(project, "Fetching DDL", () -> {});
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "createProcessor"));
        }
        return function;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "dependsOn"));
        }
        return false;
    }

    @NotNull
    public DdlPreview getDdlPreview() {
        DdlPreview ddlPreview = this.myDdlPreview;
        if (ddlPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/DdlPreviewComponent", "getDdlPreview"));
        }
        return ddlPreview;
    }
}

