/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpComponent;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.DumpProperties;
import com.intellij.database.dump.dbdump.LexemeIndicators;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpSettings
implements Disposable {
    private static final String OPTIONS = "Options";
    private static final int INSET = 10;
    private final List<DumpComponent> myComponents;
    private final DumpConfiguration myConfiguration;
    private final TextFieldWithBrowseButton myExecutableField;
    private final TextFieldWithAutoCompletion<String> myArgumentsField;
    private final HideableTitledPanel myPanel;
    private final DumpProperties myProperties;
    private List<String> myParameterizable;
    private boolean myBusy;

    public DumpSettings(@NotNull Project project, @NotNull Collection<DbElement> elements, @NotNull DumpConfiguration configuration, @NotNull Disposable parent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/dbdump/DumpSettings", "<init>"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpSettings", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DumpSettings", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dump/dbdump/DumpSettings", "<init>"));
        }
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myConfiguration = configuration;
        this.myComponents = configuration.getComponents();
        this.myProperties = new DumpProperties(configuration, this);
        Disposer.register((Disposable)this, (Disposable)this.myProperties);
        this.myPanel = new HideableTitledPanel(OPTIONS);
        this.myPanel.setOn(true);
        this.myParameterizable = ContainerUtil.emptyList();
        this.myArgumentsField = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)new MyCompletionProvider(configuration.getInfoMap()), true, null);
        this.myArgumentsField.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBUI.insets((int)10, (int)0, (int)0, (int)0)));
        this.myExecutableField = new TextFieldWithBrowseButton();
        this.myExecutableField.addBrowseFolderListener((TextBrowseFolderListener)new MyBrowseButtonListener());
        this.setPathToExecutable(this.myConfiguration.getDefaultSearchPath() == null ? "" : this.myConfiguration.getDefaultSearchPath());
        this.configureComponents();
        this.myProperties.restore();
        this.myArgumentsField.setText(configuration.sanitizeArguments(elements, this.myArgumentsField.getText()));
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.filteredLexemes(this.myArgumentsField.getText(), this.myConfiguration, this.myParameterizable);
        DumpContextDescriptor state = new DumpContextDescriptor(lexemes, DumpContextDescriptor.Operation.UNKNOWN);
        this.myComponents.forEach(component -> {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpSettings", "lambda$new$0"));
            }
            component.configure(elements, state);
        });
    }

    public void store() {
        this.myProperties.store();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent settingsPanel = this.myConfiguration.getDecorator().decorate(this.myPanel, (JComponent)this.myExecutableField, this.myComponents);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)settingsPanel, "North");
        panel.add((Component)this.myArgumentsField, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public DumpContextDescriptor getContext() {
        DumpContextDescriptor dumpContextDescriptor = new DumpContextDescriptor(DbDumpUtil.filteredLexemes(this.myArgumentsField.getText(), this.myConfiguration, this.myParameterizable), DumpContextDescriptor.Operation.UNKNOWN);
        if (dumpContextDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getContext"));
        }
        return dumpContextDescriptor;
    }

    public boolean isExpanded() {
        return this.myPanel.isExpanded();
    }

    public void setExpanded(boolean expanded) {
        this.myPanel.setOn(expanded);
    }

    @NotNull
    public String getCommand() {
        String string = this.myArgumentsField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getCommand"));
        }
        return string;
    }

    public boolean contains(@Nullable LexemeIndicators indicators) {
        if (indicators == null) {
            return false;
        }
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.rawLexemes(this.myArgumentsField.getText());
        return ContainerUtil.find(lexemes, DbDumpUtil.lexemeWithParameterFinder(lexemes, indicators)) != null;
    }

    @NotNull
    public DumpConfiguration getConfiguration() {
        DumpConfiguration dumpConfiguration = this.myConfiguration;
        if (dumpConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getConfiguration"));
        }
        return dumpConfiguration;
    }

    @NotNull
    public List<DumpComponent> getDumpComponents() {
        List<DumpComponent> list = this.myComponents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getDumpComponents"));
        }
        return list;
    }

    @NotNull
    public String getPathToExecutable() {
        String string = this.myExecutableField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getPathToExecutable"));
        }
        return string;
    }

    public void setPathToExecutable(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dump/dbdump/DumpSettings", "setPathToExecutable"));
        }
        this.myExecutableField.setText(path);
        this.myProperties.storeVariants();
    }

    public void setCommand(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpSettings", "setCommand"));
        }
        this.myArgumentsField.setText(command);
    }

    public void setVariants(@NotNull List<String> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dump/dbdump/DumpSettings", "setVariants"));
        }
        List<String> tweaked = this.myConfiguration.tweakAutocompletion(variants);
        this.myParameterizable = JBIterable.from(tweaked).filter(s -> s.endsWith("=")).transform(s -> s.substring(0, s.length() - 1)).toList();
        this.myArgumentsField.setVariants(tweaked);
    }

    @NotNull
    public List<String> getParameterizable() {
        List<String> list = this.myParameterizable;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getParameterizable"));
        }
        return list;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myExecutableField;
        if (textFieldWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getPreferredFocusableComponent"));
        }
        return textFieldWithBrowseButton;
    }

    @NotNull
    public JComponent getCommandComponent() {
        JComponent jComponent = this.myArgumentsField.getFocusTarget();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings", "getCommandComponent"));
        }
        return jComponent;
    }

    private void configureComponents() {
        Consumer consumer = source -> this.runProtected(() -> {
            this.componentChanged((DumpComponent)source);
            DbUIUtil.invokeLater(() -> this.updateFromText((DumpComponent)source));
        });
        this.myComponents.forEach(component -> component.addListener((Consumer<DumpComponent>)consumer));
        this.myExecutableField.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                DumpSettings.this.myProperties.storeVariants();
            }
        });
        this.myArgumentsField.setFontInheritedFromLAF(false);
        this.myArgumentsField.addSettingsProvider(editor -> {
            editor.setEmbeddedIntoDialogWrapper(true);
            editor.getSettings().setWheelFontChangeEnabled(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            editor.getSettings().setUseSoftWraps(true);
            editor.setOneLineMode(false);
        });
        this.myArgumentsField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                DumpSettings.this.runProtected(() -> DumpSettings.this.stateChanged());
            }
        });
    }

    private void updateFromText(@NotNull DumpComponent source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpSettings", "updateFromText"));
        }
        this.runProtected(() -> {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpSettings", "lambda$updateFromText$8"));
            }
            this.clearWhitespaces();
            this.stateChanged(source);
        });
    }

    private void clearWhitespaces() {
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.rawLexemes(this.myArgumentsField.getText());
        ArrayList filtered = ContainerUtil.newArrayList();
        boolean delimited = false;
        for (DumpCommandLineLexeme lexeme : lexemes) {
            if (delimited && lexeme.isWhitespace()) continue;
            delimited = lexeme.isWhitespace();
            filtered.add(lexeme);
        }
        this.myArgumentsField.setText(StringUtil.join((Collection)filtered, DumpCommandLineLexeme::getText, (String)""));
    }

    private void stateChanged() {
        this.stateChanged(null);
    }

    private void stateChanged(@Nullable DumpComponent exclude) {
        String text = this.myArgumentsField.getText();
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.filteredLexemes(text, this.myConfiguration, this.myParameterizable);
        DumpContextDescriptor state = new DumpContextDescriptor(lexemes, DumpContextDescriptor.Operation.TEXT_CHANGED);
        for (DumpComponent component : this.myComponents) {
            if (component == exclude || DumpSettings.processComponent(component, state, text, lexemes)) continue;
            component.reset(state);
        }
    }

    private static boolean processComponent(@NotNull DumpComponent component, @NotNull DumpContextDescriptor state, @NotNull String text, @NotNull List<DumpCommandLineLexeme> lexemes) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dump/dbdump/DumpSettings", "processComponent"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dump/dbdump/DumpSettings", "processComponent"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DumpSettings", "processComponent"));
        }
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpSettings", "processComponent"));
        }
        boolean changed = false;
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            DumpCommandLineLexeme next;
            DumpCommandLineLexeme current = lexemes.get(i2);
            DumpCommandLineLexeme dumpCommandLineLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbDumpUtil.getLastCharacterLexeme(text);
            if (!component.isMyLexeme(text, current, next, state)) continue;
            component.changeState(text, current, next, state);
            changed = true;
        }
        return changed;
    }

    private void componentChanged(@NotNull DumpComponent source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpSettings", "componentChanged"));
        }
        String text = StringUtil.trim((String)this.myArgumentsField.getText());
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.filteredLexemes(text, this.myConfiguration, this.myParameterizable);
        DumpContextDescriptor cd = new DumpContextDescriptor(lexemes, DumpContextDescriptor.Operation.COMPONENT_CHANGED);
        List<Pair<DumpCommandLineLexeme, DumpCommandLineLexeme>> pairs = DbDumpUtil.lexemePairs(cd, lexemes, text, source);
        if (pairs.isEmpty()) {
            this.myArgumentsField.setText(text + DbDumpUtil.prepareArgument(source, cd));
            return;
        }
        StringBuilder sb = new StringBuilder(text);
        int offset = 0;
        for (Pair<DumpCommandLineLexeme, DumpCommandLineLexeme> pair : pairs) {
            DumpCommandLineLexeme first = (DumpCommandLineLexeme)pair.getFirst();
            DumpCommandLineLexeme second = (DumpCommandLineLexeme)pair.getSecond();
            sb.delete(first.getStart() - offset, second.getStart() - offset);
            offset += second.getStart() - first.getStart();
        }
        int start = ((DumpCommandLineLexeme)pairs.get(pairs.size() - 1).getSecond()).getStart();
        DumpSettings.insertArgument(sb, cd, source, start, offset);
        this.myArgumentsField.setText(sb.toString());
    }

    private void runProtected(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dump/dbdump/DumpSettings", "runProtected"));
        }
        if (this.myBusy) {
            return;
        }
        try {
            this.myBusy = true;
            runnable.run();
        }
        finally {
            this.myBusy = false;
        }
    }

    public void dispose() {
    }

    private static void insertArgument(@NotNull StringBuilder sb, @NotNull DumpContextDescriptor cd, @NotNull DumpComponent source, int start, int offset) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/dump/dbdump/DumpSettings", "insertArgument"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/DumpSettings", "insertArgument"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpSettings", "insertArgument"));
        }
        if (source.isAppendInTheEnd(cd)) {
            sb.append(DbDumpUtil.prepareArgument(source, cd));
            return;
        }
        sb.insert(start - offset, DbDumpUtil.prepareArgument(source, cd, true));
    }

    private static class MyPrefixMatcher
    extends PlainPrefixMatcher {
        private final MinusculeMatcher myMatcher;

        protected MyPrefixMatcher(String prefix) {
            super(prefix);
            this.myMatcher = NameUtil.buildMatcher((String)prefix, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        }

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/dbdump/DumpSettings$MyPrefixMatcher", "prefixMatches"));
            }
            return super.prefixMatches(name) || this.myMatcher.matches(name);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/dump/dbdump/DumpSettings$MyPrefixMatcher", "cloneWithPrefix"));
            }
            MyPrefixMatcher myPrefixMatcher = new MyPrefixMatcher(prefix);
            if (myPrefixMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpSettings$MyPrefixMatcher", "cloneWithPrefix"));
            }
            return myPrefixMatcher;
        }
    }

    private static class MyCompletionProvider
    extends TextFieldWithAutoCompletion.StringsCompletionProvider {
        private final Map<String, String> myInfoMap;

        public MyCompletionProvider(@NotNull Map<String, String> infoMap) {
            if (infoMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoMap", "com/intellij/database/dump/dbdump/DumpSettings$MyCompletionProvider", "<init>"));
            }
            super((Collection)ContainerUtil.emptyList(), null);
            this.myInfoMap = infoMap;
        }

        @Nullable
        protected String getTypeText(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dump/dbdump/DumpSettings$MyCompletionProvider", "getTypeText"));
            }
            return this.myInfoMap.get(item);
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/dump/dbdump/DumpSettings$MyCompletionProvider", "createPrefixMatcher"));
            }
            return new MyPrefixMatcher(prefix);
        }
    }

    private class MyBrowseButtonListener
    extends TextBrowseFolderListener {
        public MyBrowseButtonListener() {
            super(new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor()));
        }

        protected void onFileChosen(@NotNull VirtualFile chosenFile) {
            if (chosenFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/database/dump/dbdump/DumpSettings$MyBrowseButtonListener", "onFileChosen"));
            }
            DumpSettings.this.myExecutableField.setText(chosenFile.getPath());
        }
    }
}

