/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.GenericIntrospector;
import com.intellij.database.introspection.MsIntrospector;
import com.intellij.database.introspection.MysqlIntrospector;
import com.intellij.database.introspection.OraIntrospector;
import com.intellij.database.introspection.PostgresIntrospector;
import com.intellij.database.introspection.SqliteIntrospector;
import com.intellij.database.introspection.SybaseIntrospector;
import com.intellij.database.model.impl.ModelFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.core.DBFacade;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "modelFactory", "Lcom/intellij/database/model/impl/ModelFactory;", "db", "Lorg/jetbrains/dekaf/core/DBFacade;", "legacy", "", "createLegacyIntrospector", "hasModerIntrospector", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "database-introspection"})
@JvmName(name="DBIntrospectorFactory")
public final class DBIntrospectorFactory {
    public static final boolean hasModerIntrospector(@Nullable Rdbms rdbms) {
        Rdbms rdbms2 = rdbms;
        return Intrinsics.areEqual((Object)rdbms2, (Object)Postgres.RDBMS) ? true : (Intrinsics.areEqual((Object)rdbms2, (Object)Oracle.RDBMS) ? true : (Intrinsics.areEqual((Object)rdbms2, (Object)Mssql.RDBMS) ? true : (Intrinsics.areEqual((Object)rdbms2, (Object)Sybase.RDBMS) ? true : (Intrinsics.areEqual((Object)rdbms2, (Object)Mysql.RDBMS) ? true : Intrinsics.areEqual((Object)rdbms2, (Object)Sqlite.RDBMS)))));
    }

    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull ModelFactory modelFactory, @NotNull DBFacade db, boolean legacy) {
        BaseIntrospector baseIntrospector;
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        if (legacy) {
            return DBIntrospectorFactory.createLegacyIntrospector(modelFactory, db);
        }
        Rdbms rdbms = db.rdbms();
        if (Intrinsics.areEqual((Object)rdbms, (Object)Postgres.RDBMS)) {
            baseIntrospector = new PostgresIntrospector(db);
        } else if (Intrinsics.areEqual((Object)rdbms, (Object)Oracle.RDBMS)) {
            baseIntrospector = new OraIntrospector(db);
        } else if (Intrinsics.areEqual((Object)rdbms, (Object)Mssql.RDBMS)) {
            baseIntrospector = new MsIntrospector(db);
        } else if (Intrinsics.areEqual((Object)rdbms, (Object)Sybase.RDBMS)) {
            baseIntrospector = new SybaseIntrospector(db);
        } else if (Intrinsics.areEqual((Object)rdbms, (Object)Mysql.RDBMS)) {
            baseIntrospector = new MysqlIntrospector(db);
        } else if (Intrinsics.areEqual((Object)rdbms, (Object)Sqlite.RDBMS)) {
            baseIntrospector = new SqliteIntrospector(db);
        } else {
            return DBIntrospectorFactory.createLegacyIntrospector(modelFactory, db);
        }
        BaseIntrospector introspector = baseIntrospector;
        introspector.setModelFactory$database_introspection(modelFactory);
        return introspector;
    }

    private static final DBIntrospector createLegacyIntrospector(ModelFactory modelFactory, DBFacade db) {
        GenericIntrospector introspector = new GenericIntrospector(db);
        introspector.setModelFactory(modelFactory);
        return introspector;
    }
}

