/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class TableKeyColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> {
    private final TIntHashSet myPoses;
    private final DatabaseMetaDataWrapper.Table myTable;

    public TableKeyColumnIt(@NotNull ResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/introspection/jdbcMetadataWrappers/TableKeyColumnIt", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/jdbcMetadataWrappers/TableKeyColumnIt", "<init>"));
        }
        super(rs);
        this.myPoses = new TIntHashSet();
        this.myTable = table;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableKeyColumn createStorage() {
        DatabaseMetaDataWrapper.TableKeyColumn tableKeyColumn = new DatabaseMetaDataWrapper.TableKeyColumn(new DatabaseMetaDataWrapper.TableKey(this.myTable, ""));
        if (tableKeyColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/TableKeyColumnIt", "createStorage"));
        }
        return tableKeyColumn;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableKeyColumn calcValue() throws SQLException {
        DatabaseMetaDataWrapper.TableKeyColumn res = (DatabaseMetaDataWrapper.TableKeyColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
            }
            String cat = this.myRs.getString("TABLE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.myTable.schema.schema);
            if (!Comparing.equal((String)schema, (String)this.myTable.schema.schema) || !Comparing.equal((String)table, (String)this.myTable.name)) {
                return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
            }
            res.name = this.myRs.getString("COLUMN_NAME", 4);
            res.position = this.myRs.getShort("KEY_SEQ", 5);
            while (this.myPoses.contains((int)res.position)) {
                res.position = (short)(res.position + 1);
            }
            this.myPoses.add((int)res.position);
            res.key.name = this.myRs.getString("PK_NAME", 6);
            res.name = this.myRs.getString("COLUMN_NAME", 4);
            res.key.primary = true;
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.TableKeyColumn)this.skip();
        }
        return res;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableKeyColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.key.table.schema.database, cur.key.table.schema.schema, cur.key.table.name);
        this.addError(title, e);
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn, DatabaseMetaDataWrapper.TableKeyColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/introspection/jdbcMetadataWrappers/TableKeyColumnIt$Grouping", "<init>"));
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableKeyColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> it) {
            final String keyName = ((DatabaseMetaDataWrapper.TableKeyColumn)it.current()).key.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableKeyColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableKeyColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableKeyColumn item) {
                    return Comparing.equal((String)keyName, (String)item.key.name);
                }
            };
            if (groupIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/TableKeyColumnIt$Grouping", "createGroupIt"));
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.TableKey getItem(ClosableIt<DatabaseMetaDataWrapper.TableKeyColumn> it) {
            return ((DatabaseMetaDataWrapper.TableKeyColumn)it.current()).key;
        }
    }
}

