/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.db2;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.db2.Db2ModCheck;
import com.intellij.database.model.db2.Db2ModForeignKey;
import com.intellij.database.model.db2.Db2ModIndex;
import com.intellij.database.model.db2.Db2ModKey;
import com.intellij.database.model.db2.Db2ModLikeTable;
import com.intellij.database.model.db2.Db2ModSchema;
import com.intellij.database.model.db2.Db2ModTableColumn;
import com.intellij.database.model.db2.Db2ModTrigger;
import com.intellij.database.model.db2.Db2Table;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Db2ModTable
extends Db2Table,
Db2ModLikeTable {
    @Override
    @NotNull
    public Db2ModSchema getSchema();

    @Override
    @NotNull
    default public Db2ModSchema getDbParent() {
        Db2ModSchema db2ModSchema = this.getSchema();
        if (db2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModTable", "getDbParent"));
        }
        return db2ModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends Db2ModTable> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends Db2ModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingFamily<? extends Db2ModIndex> getIndices();

    @Override
    @NotNull
    public ModNamingFamily<? extends Db2ModKey> getKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends Db2ModForeignKey> getForeignKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends Db2ModCheck> getChecks();

    @NotNull
    public ModNamingFamily<? extends Db2ModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    public void setTemporary(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/db2/Db2ModTable", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        String temporary = properties.get("Temporary");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (temporary != null) {
            this.setTemporary(PropertyConverter.importBoolean(temporary));
        }
    }
}

