/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.h2;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.h2.H2ModSchema;
import com.intellij.database.model.h2.H2ModSourceAware;
import com.intellij.database.model.h2.H2ModTable;
import com.intellij.database.model.h2.H2Trigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface H2ModTrigger
extends H2Trigger,
H2ModSourceAware,
BasicModNamedElement {
    @Override
    @NotNull
    public H2ModTable getTable();

    @Override
    @NotNull
    default public H2ModTable getDbParent() {
        H2ModTable h2ModTable = this.getTable();
        if (h2ModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModTrigger", "getDbParent"));
        }
        return h2ModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends H2ModTrigger> getParentFamily();

    @Override
    @NotNull
    default public H2ModSchema getSchema() {
        H2ModSchema h2ModSchema = this.getTable().getSchema();
        if (h2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModTrigger", "getSchema"));
        }
        return h2ModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    public void setTurn(@Nullable TrigTurn var1);

    public void setEvent(@NotNull Set<TrigEvent> var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/h2/H2ModTrigger", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String turn = properties.get("Turn");
        String event = properties.get("Event");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (turn != null) {
            this.setTurn(PropertyConverter.importTrigTurn(turn));
        }
        if (event != null) {
            this.setEvent(PropertyConverter.importSetOfTrigEvent(event));
        }
    }
}

