/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.db2.Db2;
import com.intellij.database.model.derby.Derby;
import com.intellij.database.model.hsql.HsqlDB;
import com.intellij.database.model.impl.BaseModel;
import com.intellij.database.model.impl.Db2ImplModel;
import com.intellij.database.model.impl.DerbyImplModel;
import com.intellij.database.model.impl.GenericImplModel;
import com.intellij.database.model.impl.H2ImplModel;
import com.intellij.database.model.impl.HsqlImplModel;
import com.intellij.database.model.impl.MssqlImplModel;
import com.intellij.database.model.impl.MysqlImplModel;
import com.intellij.database.model.impl.OracleImplModel;
import com.intellij.database.model.impl.PostgresImplModel;
import com.intellij.database.model.impl.SqliteImplModel;
import com.intellij.database.model.impl.SybaseImplModel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ+\u0010\u0007\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/model/impl/ModelFactory;", "", "myTextStorage", "Lcom/intellij/database/model/ModelTextStorage;", "(Lcom/intellij/database/model/ModelTextStorage;)V", "getMyTextStorage", "()Lcom/intellij/database/model/ModelTextStorage;", "createModel", "Lcom/intellij/database/model/basic/BasicModModel;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "M", "Lcom/intellij/database/model/basic/BasicModel;", "modelClass", "Ljava/lang/Class;", "(Lorg/jetbrains/dekaf/Rdbms;Ljava/lang/Class;)Lcom/intellij/database/model/basic/BasicModel;", "database-model-impl"})
public final class ModelFactory {
    @NotNull
    private final ModelTextStorage myTextStorage;

    @NotNull
    public final BasicModModel createModel(@NotNull Rdbms rdbms) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Rdbms rdbms2 = rdbms;
        BaseModel model = Intrinsics.areEqual((Object)rdbms2, (Object)Oracle.RDBMS) ? (BaseModel)new OracleImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)Mssql.RDBMS) ? (BaseModel)new MssqlImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)Sybase.RDBMS) ? (BaseModel)new SybaseImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)Postgres.RDBMS) ? (BaseModel)new PostgresImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)Mysql.RDBMS) ? (BaseModel)new MysqlImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)H2db.RDBMS) ? (BaseModel)new H2ImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)HsqlDB.RDBMS) ? (BaseModel)new HsqlImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)Db2.RDBMS) ? (BaseModel)new Db2ImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)Derby.RDBMS) ? (BaseModel)new DerbyImplModel() : (Intrinsics.areEqual((Object)rdbms2, (Object)Sqlite.RDBMS) ? (BaseModel)new SqliteImplModel() : (BaseModel)new GenericImplModel())))))))));
        model.setTextStorage(this.myTextStorage);
        return model;
    }

    @NotNull
    public final <M extends BasicModel> M createModel(@NotNull Rdbms rdbms, @NotNull Class<M> modelClass) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull(modelClass, (String)"modelClass");
        BasicModModel model = this.createModel(rdbms);
        if (modelClass.isAssignableFrom(model.getClass())) {
            BasicModModel basicModModel = model;
            if (basicModModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type M");
            }
            return (M)basicModModel;
        }
        throw (Throwable)new IllegalArgumentException("Cannot cast a model of " + rdbms + " to " + modelClass.getSimpleName());
    }

    @NotNull
    public final ModelTextStorage getMyTextStorage() {
        return this.myTextStorage;
    }

    public ModelFactory(@NotNull ModelTextStorage myTextStorage) {
        Intrinsics.checkParameterIsNotNull((Object)myTextStorage, (String)"myTextStorage");
        this.myTextStorage = myTextStorage;
    }
}

