/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresModArgument;
import com.intellij.database.model.postgres.PostgresModCatalogObject;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModSourceAware;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModRoutine
extends PostgresRoutine,
PostgresModCatalogObject,
BasicModRoutine,
PostgresModSourceAware,
BasicModNamedElement {
    @Override
    @NotNull
    public PostgresModSchema getSchema();

    @Override
    @NotNull
    default public PostgresModSchema getDbParent() {
        PostgresModSchema postgresModSchema = this.getSchema();
        if (postgresModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModRoutine", "getDbParent"));
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModRoutine> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends PostgresModArgument> getArguments();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<PositioningNamingFamily> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModRoutine", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getArguments());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModRoutine", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    @Override
    public void setStateNumber(long var1);

    public void setArgumentsDefinition(@Nullable String var1);

    public void setResultsDefinition(@Nullable String var1);

    public void setLanguageName(@Nullable String var1);

    @Override
    public void setRoutineKind(@NotNull DasRoutine.Kind var1);

    public void setReturnsSet(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModRoutine", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String invalid = properties.get("Invalid");
        String stateNumber = properties.get("StateNumber");
        String argumentsDefinition = properties.get("ArgumentsDefinition");
        String resultsDefinition = properties.get("ResultsDefinition");
        String languageName = properties.get("LanguageName");
        String routineKind = properties.get("RoutineKind");
        String returnsSet = properties.get("ReturnsSet");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (invalid != null) {
            this.setInvalid(PropertyConverter.importBoolean(invalid));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (argumentsDefinition != null) {
            this.setArgumentsDefinition(PropertyConverter.importString(argumentsDefinition));
        }
        if (resultsDefinition != null) {
            this.setResultsDefinition(PropertyConverter.importString(resultsDefinition));
        }
        if (languageName != null) {
            this.setLanguageName(PropertyConverter.importString(languageName));
        }
        if (routineKind != null) {
            this.setRoutineKind(PropertyConverter.importDasRoutineKind(routineKind));
        }
        if (returnsSet != null) {
            this.setReturnsSet(PropertyConverter.importBoolean(returnsSet));
        }
    }
}

