/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbDocumentationLinks;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.psi.DocumentationLink;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbElementImpl<D, P extends DbElement>
extends FakePsiElement
implements DbElement,
PsiMetaOwner,
PsiPresentableMetaData {
    public static final int WEIGHT_BASE = 10000;
    public static final int WEIGHT_INC = 1000;
    protected final P myParent;
    protected final D myDelegate;
    protected static final String ASYNC_DOC_CUT = "<!-- async-doc-cut -->";

    public DbElementImpl(P parent, D delegate) {
        this.myParent = parent;
        this.myDelegate = delegate;
    }

    @Nullable
    public D getDelegate() {
        return this.myDelegate;
    }

    @Nullable
    public P getDbParent() {
        return this.myParent;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate instanceof DasObject ? ((DasObject)this.myDelegate).getName() : DasUtil.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public Language getLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getLanguage"));
        }
        return sqlLanguage;
    }

    public PsiElement getDeclaration() {
        return this;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public short getPosition() {
        return this.myDelegate instanceof DasPositioned ? ((DasPositioned)this.myDelegate).getPosition() : (short)0;
    }

    @NotNull
    public String getDisplayOrder() {
        String string = this.myDelegate instanceof DasPositioned ? ((DasPositioned)this.myDelegate).getDisplayOrder() : DasUtil.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getDisplayOrder"));
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public Project getProject() {
        Project project = ((DbElement)ObjectUtils.assertNotNull(this.getDbParent())).getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getProject"));
        }
        return project;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    public boolean isWritable() {
        D delegate = this.getDelegate();
        if (delegate instanceof PsiElement) {
            return ((PsiElement)delegate).isWritable();
        }
        D dataSource = this.getDataSource().getDelegate();
        return !(dataSource instanceof DataSource) || !((DataSource)dataSource).isReadOnly();
    }

    public String getLocationString() {
        ObjectKind type = this.getKind();
        return type != ObjectKind.NONE ? QNameUtil.getQualifiedName(this.getDbParent()) + " (" + this.getDataSource().getName() + ")" : super.getLocationString();
    }

    public PsiManager getManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/psi/DbElementImpl", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/psi/DbElementImpl", "getDbChildren"));
        }
        JBIterable jBIterable = this.getDataSource().findChildren(this, clazz).filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getDbChildren"));
        }
        return jBIterable;
    }

    public String getText() {
        return new DdlBuilder().configureFor(this).element((DasObject)this).getStatement();
    }

    @NotNull
    public ObjectKind getKind() {
        D delegate = this.getDelegate();
        if (delegate instanceof DasObject) {
            ObjectKind objectKind = ((DasObject)delegate).getKind();
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getKind"));
            }
            return objectKind;
        }
        throw new AssertionError((Object)(((Object)((Object)this)).getClass() + ":" + String.valueOf(delegate)));
    }

    @Nullable
    public Icon getIcon() {
        return this.getIcon(0);
    }

    @Nullable
    public Icon getBaseIcon() {
        return DbPresentation.getIcon(this.getKind());
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return DbPresentation.getIcon((DasObject)this);
    }

    public boolean isCaseSensitive() {
        return DbElementImpl.isCaseSensitive(this);
    }

    @Nullable
    public String getComment() {
        return this.myDelegate instanceof DasObject ? ((DasObject)this.myDelegate).getComment() : null;
    }

    public PsiElement getParent() {
        return this.getDbParent();
    }

    @NotNull
    public String getTypeName() {
        String string = DbPresentation.getPresentableName(this.getKind(), DbImplUtil.getDatabaseDialect(this));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getTypeName"));
        }
        return string;
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/psi/DbElementImpl", "setName"));
        }
        D delegate = this.getDelegate();
        if (delegate instanceof PsiNamedElement) {
            ((PsiNamedElement)delegate).setName(name);
        }
        return this;
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/psi/DbElementImpl", "acceptChildren"));
        }
        for (DbElement element : this.getDbChildren(DbElement.class, ObjectKind.NONE)) {
            element.accept(visitor);
        }
    }

    @NotNull
    public List<?> getDelegates() {
        List list = ContainerUtil.createMaybeSingletonList(this.getDelegate());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getDelegates"));
        }
        return list;
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        D delegate = this.getDelegate();
        return !(delegate instanceof Navigatable) || ((Navigatable)delegate).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        DatabaseView.select(this, requestFocus);
    }

    @NotNull
    public StringBuilder getDocumentation() {
        StringBuilder sb = new StringBuilder(HtmlValuesExtractor.getStyleHeader());
        DbElementImpl cur = this;
        while (cur != null) {
            String name = cur.getName();
            if (!StringUtil.isEmpty((String)name)) {
                sb.insert(0, "<b>" + StringUtil.capitalize((String)cur.getTypeName()) + ":</b> " + name + "<br>");
            }
            cur = cur.getParent() instanceof DbElement ? (DbElement)cur.getParent() : null;
        }
        this.appendDocumentationLinks(sb);
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getDocumentation"));
        }
        return stringBuilder;
    }

    protected void appendDocumentationLinks(StringBuilder b) {
        DocumentationLink link;
        D delegate = this.getDelegate();
        DocumentationLink documentationLink = link = delegate instanceof BasicElement ? DbDocumentationLinks.makeDocumentationLink((BasicElement)delegate) : null;
        if (link != null) {
            b.append("\n<p><b>Documentation page: <tt>").append(link.getHtmlText()).append("</tt></b></p>\n");
        }
    }

    protected void scheduleAsyncDocumentationUpdate(@NotNull StringBuilder currentDocumentation) {
        if (currentDocumentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDocumentation", "com/intellij/database/psi/DbElementImpl", "scheduleAsyncDocumentationUpdate"));
        }
        if (!DatabaseSettings.getSettings().loadSlowDocumentation) {
            return;
        }
        if (!DbImplUtil.canConnectTo(this)) {
            return;
        }
        String progressMessage = "<small>Connecting to database...</small>";
        currentDocumentation.append("<br>").append("<small>Connecting to database...</small>");
        Project project = this.getProject();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Ref noEx = Ref.create((Object)true);
            CharOut out = CharOut.Util.newSink();
            try {
                ConnectionProvider.runWithProvider(this, (ThrowableConsumer<ConnectionProvider, Exception>)((ThrowableConsumer)provider -> this.loadSlowDocumentationInner(out, (ConnectionProvider)provider)));
            }
            catch (Exception e) {
                noEx.set((Object)Boolean.FALSE);
                out.append(DbImplUtil.exceptionToHtml(e, "<b>Connection failed</b>", new StringBuilder()));
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
                if (component == null) {
                    return;
                }
                String prevText = component.getText();
                int generatedIdx = prevText.indexOf(ASYNC_DOC_CUT);
                int progressIdx = prevText.indexOf("<small>Connecting to database...</small>");
                if (progressIdx < 0) {
                    return;
                }
                String newText = prevText.substring(0, generatedIdx > 0 && (Boolean)noEx.get() != false ? generatedIdx : progressIdx) + out.tryCast(CharSequence.class) + prevText.substring(progressIdx + "<small>Connecting to database...</small>".length());
                if (!Comparing.equal((String)newText, (String)prevText)) {
                    component.replaceText(newText, (PsiElement)this);
                }
            });
        });
    }

    protected boolean appendDefinition(@NotNull StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/psi/DbElementImpl", "appendDefinition"));
        }
        String text = DbImplUtil.loadDefinitionFromStorage(this);
        if (text == null && DatabaseEditorHelper.isDefinitionAvailable(this)) {
            StringBuilder tmp = new StringBuilder();
            DatabaseEditorHelper.generateDefinition(this, tmp);
            if (tmp.length() == 0) {
                return false;
            }
            tmp.insert(0, "-- auto-generated definition\n");
            text = tmp.toString();
        }
        if (text != null) {
            sb.append("<br><code><pre>").append(this.sql2Html(text)).append("</pre></code><br>");
            return true;
        }
        return false;
    }

    protected void loadSlowDocumentationInner(CharOut charOut, ConnectionProvider provider) throws Exception {
        throw new UnsupportedOperationException("getUpdatedDocumentationInner() not implemented in " + ((Object)((Object)this)).getClass());
    }

    protected DdlBuilder.Colored createDocBuilder(StringBuilder sb) {
        DdlBuilder.Colored colored = new DdlBuilder.Colored(sb);
        colored.configureFor(this);
        return colored;
    }

    protected void checkValid() {
        PsiUtilCore.ensureValid((PsiElement)this);
    }

    public boolean isValid() {
        return this.getDataSource().isValidImpl(this);
    }

    @NotNull
    public DbDataSourceImpl getDataSource() {
        DbDataSourceImpl o = (DbDataSourceImpl)((Object)SyntaxTraverser.psiApi().parents((Object)this).filter(DbDataSourceImpl.class).first());
        if (o != null) {
            DbDataSourceImpl dbDataSourceImpl = o;
            if (dbDataSourceImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "getDataSource"));
            }
            return dbDataSourceImpl;
        }
        throw new AssertionError((Object)(this.getTypeName() + ": no datasource"));
    }

    public int getWeight() {
        ObjectKind kind = this.getKind();
        if (kind == ObjectKind.TABLE) {
            return 10000;
        }
        if (kind == ObjectKind.MAT_VIEW) {
            return 11000;
        }
        if (kind == ObjectKind.VIEW) {
            return 12000;
        }
        if (kind == ObjectKind.SEQUENCE) {
            return 13000;
        }
        if (kind == ObjectKind.TRIGGER) {
            return 14000;
        }
        if (kind == ObjectKind.ROUTINE) {
            return 16000;
        }
        if (kind == ObjectKind.PACKAGE) {
            return 17000;
        }
        return 10000;
    }

    @NotNull
    protected String sql2Html(CharSequence s) {
        String string = DbSqlUtil.sql2Html(this.getProject(), (Language)DbSqlUtil.getSqlDialect(this), s);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "sql2Html"));
        }
        return string;
    }

    @NotNull
    public static Processor<DbElement> newDeclarationProcessor(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/psi/DbElementImpl", "newDeclarationProcessor"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/psi/DbElementImpl", "newDeclarationProcessor"));
        }
        Processor processor2 = element -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/psi/DbElementImpl", "lambda$newDeclarationProcessor$3"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/psi/DbElementImpl", "lambda$newDeclarationProcessor$3"));
            }
            if (lastParent == element) {
                return true;
            }
            return processor.execute((PsiElement)element, state);
        };
        if (processor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbElementImpl", "newDeclarationProcessor"));
        }
        return processor2;
    }

    public Processor<DbElement> createDeclarationProcessor(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/psi/DbElementImpl", "createDeclarationProcessor"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/psi/DbElementImpl", "createDeclarationProcessor"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/psi/DbElementImpl", "createDeclarationProcessor"));
        }
        return DbElementImpl.newDeclarationProcessor(processor, state, lastParent);
    }

    public final boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/psi/DbElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/psi/DbElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/psi/DbElementImpl", "processDeclarations"));
        }
        Processor<DbElement> p = this.createDeclarationProcessor(processor, state, lastParent, place);
        return ContainerUtil.process(this.getDbChildren(DbElement.class, ObjectKind.NONE), p);
    }

    public String toString() {
        ObjectKind kind = this.getKind();
        String s = kind == ObjectKind.SCHEMA ? QNameUtil.getQualifiedName(this) : (this instanceof DbTableChild ? this.getText() : this.getName());
        return kind + ":" + String.valueOf(s);
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private static boolean isCaseSensitive(DbElement element) {
        if (!(element instanceof DasSchemaChild) && !(element instanceof DasColumn)) {
            return false;
        }
        return DbUtil.isCaseSensitive((String)element.getName(), (DbElement)element);
    }
}

