/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.ui.CalendarView;
import java.sql.Timestamp;
import java.util.Date;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeZonedTimestampEditorFactory
extends FormatBasedGridCellEditorFactory {
    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        return DbImplUtil.isZonedTimestampColumn(c, DataGridUtil.getDatabaseDialect(grid)) ? 2 : 0;
    }

    @Override
    @NotNull
    protected Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "getFormat"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "getFormat"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        CompositeFormatter compositeFormatter = grid.getObjectFormatter().getZonedTimestampFormat(c, DataGridUtil.getDatabaseDialect(grid));
        if (compositeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "getFormat"));
        }
        return compositeFormatter;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, final @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, final @NotNull ModelIndex<DataConsumer.Column> column) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "createEditorImpl"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "createEditorImpl"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "createEditorImpl"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "createEditorImpl"));
        }
        FormatBasedGridCellEditor.WithBrowseButton<CalendarView> withBrowseButton = new FormatBasedGridCellEditor.WithBrowseButton<CalendarView>(project, grid, format, value, nullValue, initiator, column){

            @Override
            protected void configurePopup(@NotNull JBPopup popup, @NotNull CalendarView component) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1", "configurePopup"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1", "configurePopup"));
                }
                component.registerEnterHandler(() -> {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1", "lambda$configurePopup$2"));
                    }
                    if (popup == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1", "lambda$configurePopup$2"));
                    }
                    this.processDate(component.getDate().getTime(), () -> {
                        if (popup == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1", "lambda$null$0"));
                        }
                        popup.closeOk(null);
                    }, () -> {
                        if (component == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1", "lambda$null$1"));
                        }
                        component.getDaysCombo().requestFocus();
                    });
                });
            }

            @Override
            protected Object createObject(@NotNull Long internalValue) {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1", "createObject"));
                }
                return new TimeZonedTimestamp(new Timestamp(internalValue), this.getTextField().getText());
            }

            @Override
            @NotNull
            protected Pair<CalendarView, JComponent> getPopupComponents() {
                CalendarView calendarView = new CalendarView();
                calendarView.setFocusCycleRoot(true);
                Object value = this.getValue();
                Date initial = value instanceof TimeZonedTimestamp ? DataGridFormattersUtil.getBoundedValue(value, column, grid) : new Date();
                calendarView.setDate(initial);
                Pair pair = Pair.create((Object)calendarView, (Object)calendarView.getDaysCombo());
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1", "getPopupComponents"));
                }
                return pair;
            }
        };
        if (withBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory", "createEditorImpl"));
        }
        return withBrowseButton;
    }
}

