/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.ConfigurableDdlGenerator;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TruncateTableOperation
extends ConfigurableDdlGenerator<DeTable> {
    public static final ConfigurableDdlGenerator.Option<Boolean> USE_DELETE = ConfigurableDdlGenerator.Option.create("Use delete", Boolean.FALSE);
    public static final ConfigurableDdlGenerator.Option<Boolean> RESTART_SEQUENCES = ConfigurableDdlGenerator.Option.create("Restart sequences", Boolean.FALSE);
    public static final ConfigurableDdlGenerator.Option<Boolean> DROP_STORAGE = ConfigurableDdlGenerator.Option.create("Drop storage", Boolean.FALSE);
    public static final ConfigurableDdlGenerator.Option<Boolean> PURGE_MATERIALIZED_VIEW_LOG = ConfigurableDdlGenerator.Option.create("Purge materialized view log", Boolean.FALSE);
    public static final ConfigurableDdlGenerator.Option<Boolean> CASCADE = ConfigurableDdlGenerator.Option.create("Cascade", Boolean.FALSE);
    public static final ConfigurableDdlGenerator.Option<Boolean> IGNORE_DELETE_TRIGGERS = ConfigurableDdlGenerator.Option.create("Ignore delete triggers", Boolean.FALSE);
    public static final ConfigurableDdlGenerator.Option<Boolean> IMMEDIATE = ConfigurableDdlGenerator.Option.create("Immediate", Boolean.TRUE);

    public TruncateTableOperation() {
        this(USE_DELETE);
    }

    protected TruncateTableOperation(ConfigurableDdlGenerator.Option<?> ... options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "<init>"));
        }
        super(DasDdlOperations.TRUNCATE_TABLE, options);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "generate"));
        }
        if (TruncateTableOperation.findOption((Iterable)OPTION_VALUES.get(data), USE_DELETE) == Boolean.TRUE) {
            builder.keywords("DELETE", "FROM").space().qualifiedRef(object).newStatement();
        } else {
            builder.keywords("TRUNCATE", "TABLE").space().qualifiedRef(object).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "generate"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTable object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "getDependencies"));
        }
        if (ArrayUtil.contains(CASCADE, (Object[])this.getOptions()) && TruncateTableOperation.findOption((Iterable)OPTION_VALUES.get(data), CASCADE) == Boolean.TRUE) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "getDependencies"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(object.model.getExportedKeys(object)).transform(key -> {
            DeTable table = (DeTable)ObjectUtils.tryCast((Object)key.getTable(), DeTable.class);
            if (table == null) {
                return null;
            }
            return new DdlOperationKey(table, DasDdlOperations.TRUNCATE_TABLE);
        }).filter(Conditions.notNull());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "getDependencies"));
        }
        return jBIterable;
    }

    @Override
    public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "isSupported"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "isSupported"));
        }
        return super.isSupported(support, obj) && obj instanceof DeTable;
    }

    @Override
    public boolean isSupportedLight(@NotNull DdlOperation.DdlOperationSupport support, @NotNull ObjectKind kind) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "isSupportedLight"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/schemaEditor/operations/TruncateTableOperation", "isSupportedLight"));
        }
        return kind == ObjectKind.TABLE;
    }
}

