/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.serialization;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.serialization.FixHierarchicalStreamReader;
import com.intellij.database.serialization.ImportException;
import com.intellij.database.serialization.ModelExporter;
import com.intellij.database.serialization.ModelImporter;
import com.intellij.database.serialization.ModelMem;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"deserialize", "Lcom/intellij/database/model/basic/BasicModModel;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "modelFactory", "Lcom/intellij/database/model/impl/ModelFactory;", "importer", "Lcom/intellij/database/serialization/ModelImporter;", "serialize", "", "model", "Lcom/intellij/database/model/DasModel;", "writer", "Lcom/thoughtworks/xstream/io/HierarchicalStreamWriter;", "exporter", "Lcom/intellij/database/serialization/ModelExporter;", "database-introspection"})
public final class ModelSerializerKt {
    public static final void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        ModelSerializerKt.serialize(model, writer, new ModelExporter());
    }

    @NotNull
    public static final BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @NotNull ModelFactory modelFactory) throws ImportException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        return ModelSerializerKt.deserialize(reader, new ModelImporter(modelFactory));
    }

    private static final void serialize(DasModel model, HierarchicalStreamWriter writer, ModelExporter exporter) {
        DasModel dasModel = model;
        if (!(dasModel instanceof BasicModel)) {
            throw (Throwable)new IllegalArgumentException("Unknown how to export model class " + model.getClass().getSimpleName());
        }
        exporter.saveModel((BasicModel)model, writer);
    }

    private static final BasicModModel deserialize(HierarchicalStreamReader reader, ModelImporter importer) throws ImportException {
        ModelMem modelMem = importer.deserializeModel(new FixHierarchicalStreamReader(reader));
        BasicModModel basicModModel = importer.importModel(modelMem);
        Intrinsics.checkExpressionValueIsNotNull((Object)basicModModel, (String)"importer.importModel(modelMem)");
        return basicModModel;
    }

    public static final /* synthetic */ void access$serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer, @NotNull ModelExporter exporter) {
        ModelSerializerKt.serialize(model, writer, exporter);
    }

    @NotNull
    public static final /* synthetic */ BasicModModel access$deserialize(@NotNull HierarchicalStreamReader reader, @NotNull ModelImporter importer) {
        return ModelSerializerKt.deserialize(reader, importer);
    }
}

