/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.ssrp;

import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.database.vendors.mssql.ssrp.SsrpNet;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInfo {
    public static final String SERVER_NAME = "ServerName";
    public static final String SSRP_ERROR = "SsrpError";
    public static final String INSTANCE_NAME = "InstanceName";
    public static final String SSRP_ERROR_UNKNOWN_HOST = "UnknownHost";
    public static final String SSRP_ERROR_NO_RESPONSE = "NoResponse";
    public static final String PORT = "tcp";
    public static final String PIPE = "np";
    public static final String VERSION = "Version";
    private final THashMap<String, SsrpServer> myServers;
    private final THashMap<String, SsrpServer> myAliases;

    public SsrpInfo(@Nullable SsrpInfo info, @NotNull Set<String> except) {
        if (except == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "except", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "<init>"));
        }
        this.myServers = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        this.myAliases = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        if (info == null) {
            return;
        }
        HashMap clones = ContainerUtil.newHashMap();
        for (Map.Entry entry : info.myServers.entrySet()) {
            if (except.contains(entry.getKey())) continue;
            SsrpServer newServer = new SsrpServer((SsrpServer)entry.getValue());
            clones.put(entry.getValue(), newServer);
            this.myServers.put(entry.getKey(), (Object)newServer);
        }
        for (Map.Entry entry : info.myServers.entrySet()) {
            SsrpServer server = (SsrpServer)clones.get(entry.getValue());
            if (server == null) continue;
            this.myServers.put(entry.getKey(), (Object)server);
        }
    }

    public SsrpInfo() {
        this.myServers = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        this.myAliases = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public List<SsrpServer> merge(@NotNull SsrpNet.Response resp) throws SsrpConstants.SsrpException {
        if (resp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resp", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "merge"));
        }
        List<SsrpServer> servers = this.merge(resp.response);
        String a1 = resp.host;
        String a2 = resp.addr == null ? null : resp.addr.getHostAddress();
        for (String alias : JBIterable.of((Object[])new String[]{a1, a2}).filter(Conditions.notNull())) {
            for (SsrpServer server : servers) {
                if (server.getName().equalsIgnoreCase(alias)) continue;
                this.myAliases.put((Object)alias, (Object)server);
            }
        }
        List<SsrpServer> list = servers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "merge"));
        }
        return list;
    }

    @NotNull
    public List<SsrpServer> merge(@NotNull String str) throws SsrpConstants.SsrpException {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "merge"));
        }
        List res = ContainerUtil.newSmartList();
        for (String inst : str.split(";;")) {
            SsrpServer server;
            String[] split = inst.split(";");
            if (split.length < 2) continue;
            if (!split[0].equals(SERVER_NAME)) {
                SsrpInfo.expected(SERVER_NAME, new String[]{str, inst});
            }
            if ((server = (SsrpServer)this.myServers.get((Object)split[1])) == null) {
                server = new SsrpServer(split[1]);
                this.myServers.put((Object)split[1], (Object)server);
            }
            server.merge(split);
            res.add(server);
        }
        List list = res;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "merge"));
        }
        return list;
    }

    public static Set<String> extractServers(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "extractServers"));
        }
        HashSet res = ContainerUtil.newHashSet();
        for (String inst : str.split(";;")) {
            String[] split = inst.split(";");
            if (split.length < 2 || !split[0].equals(SERVER_NAME)) continue;
            res.add(split[1]);
        }
        return res;
    }

    @NotNull
    public Collection<SsrpServer> getServers() {
        Collection collection = this.myServers.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "getServers"));
        }
        return collection;
    }

    @Nullable
    public SsrpServer getServer(@NotNull String server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "getServer"));
        }
        SsrpServer res = (SsrpServer)this.myServers.get((Object)server);
        if (res == null) {
            res = (SsrpServer)this.myAliases.get((Object)server);
        }
        return res;
    }

    @Contract(value="_,_->fail")
    private static void expected(@NotNull String s, @NotNull String[] split) throws SsrpConstants.SsrpException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "expected"));
        }
        if (split == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "split", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "expected"));
        }
        throw new SsrpConstants.SsrpException("Expected " + s + " in `" + StringUtil.join((String[])split, (String)";") + "`");
    }

    @NotNull
    public static String concat(String ... strs) {
        if (strs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strs", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "concat"));
        }
        String string = StringUtil.join((Object[])strs, s -> StringUtil.isEmpty((String)s) ? " " : s, (String)";");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo", "concat"));
        }
        return string;
    }

    public static class SsrpInstance {
        private String myName;
        private final Map<String, String> myAttributes;

        public SsrpInstance(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "<init>"));
            }
            this.myAttributes = ContainerUtil.newHashMap();
            this.myName = name;
        }

        public SsrpInstance(@NotNull SsrpInstance other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "<init>"));
            }
            this.myAttributes = ContainerUtil.newHashMap();
            this.myName = other.myName;
            this.myAttributes.putAll(other.myAttributes);
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "getName"));
            }
            return string;
        }

        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "setName"));
            }
            this.myName = name;
        }

        @Nullable
        public String getAttribute(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpInstance", "getAttribute"));
            }
            return this.myAttributes.get(name);
        }
    }

    public static final class SsrpServer {
        private String myName;
        private String myError;
        private final Map<String, SsrpInstance> myInstances;

        public SsrpServer(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "<init>"));
            }
            this.myInstances = ContainerUtil.newTreeMap();
            this.myName = name;
        }

        public SsrpServer(@NotNull SsrpServer other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "<init>"));
            }
            this.myInstances = ContainerUtil.newTreeMap();
            this.myName = other.myName;
            this.myError = other.myError;
            for (Map.Entry<String, SsrpInstance> entry : other.myInstances.entrySet()) {
                this.myInstances.put(entry.getKey(), new SsrpInstance(entry.getValue()));
            }
        }

        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "setName"));
            }
            this.myName = name;
        }

        private void merge(@NotNull String[] split) throws SsrpConstants.SsrpException {
            if (split == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "split", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "merge"));
            }
            if (split.length >= 4 && split[2].equals(SsrpInfo.SSRP_ERROR)) {
                this.myError = split[3];
                return;
            }
            if (split.length < 4 || !split[2].equals(SsrpInfo.INSTANCE_NAME)) {
                SsrpInfo.expected(SsrpInfo.INSTANCE_NAME, split);
            }
            SsrpInstance instance = new SsrpInstance(split[3]);
            int i2 = 4;
            while (i2 + 1 < split.length) {
                instance.myAttributes.put(split[i2], split[i2 + 1]);
                ++i2;
            }
            this.myInstances.put(split[3], instance);
            this.myError = null;
        }

        @Nullable
        public String getError() {
            return this.myError;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "getName"));
            }
            return string;
        }

        @NotNull
        public Collection<SsrpInstance> getInstances() {
            Collection<SsrpInstance> collection = this.myInstances.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "getInstances"));
            }
            return collection;
        }

        @Nullable
        public SsrpInstance getInstance(@NotNull String instance) {
            if (instance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/database/vendors/mssql/ssrp/SsrpInfo$SsrpServer", "getInstance"));
            }
            return this.myInstances.get(instance);
        }
    }
}

