/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SelectInDatabaseView
implements SelectInTarget,
DumbAware {
    @NonNls
    public static final String DATABASE = DatabaseMessages.message((String)"select.in.database.view", (Object[])new Object[0]);
    public static final ExtensionPointName<Function<SelectInContext, DbElement>> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.database.selectInProvider");

    public String toString() {
        return DATABASE;
    }

    @Nullable
    public static DbElement askProviders(SelectInContext context) {
        DbElement element = SelectInDatabaseView.tryResolveSelector(context);
        if (element != null) {
            return element;
        }
        for (Function provider : (Function[])EXTENSION_POINT_NAME.getExtensions()) {
            DbElement cur = (DbElement)provider.fun((Object)context);
            if (element == null) {
                element = cur;
                continue;
            }
            if (cur == null || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)cur, (boolean)true)) continue;
            element = cur;
        }
        return element;
    }

    @Nullable
    private static DbElement tryResolveSelector(SelectInContext context) {
        PsiReference reference;
        if (!DbImplUtil.isSqlFileType(context.getVirtualFile().getFileType())) {
            return null;
        }
        Object selectorInFile = context.getSelectorInFile();
        if (!(selectorInFile instanceof PsiElement)) {
            return null;
        }
        PsiFile containingFile = ((PsiElement)selectorInFile).getContainingFile();
        PsiReference psiReference = reference = containingFile != null && selectorInFile != containingFile ? containingFile.findReferenceAt(((PsiElement)selectorInFile).getTextOffset()) : null;
        if (reference instanceof PsiPolyVariantReference) {
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                if (!(result.getElement() instanceof DbElement)) continue;
                return (DbElement)result.getElement();
            }
        }
        return null;
    }

    public boolean canSelect(SelectInContext context) {
        VirtualFile file = context.getVirtualFile();
        return !file.isDirectory() && SelectInDatabaseView.askProviders(context) != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        DbElement dbElement = SelectInDatabaseView.askProviders(context);
        if (dbElement != null) {
            DatabaseView.select(dbElement, requestFocus);
        }
    }

    public String getToolWindowId() {
        return ToolWindowId.DATABASE_VIEW;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.5f;
    }
}

