/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models.builder;

import com.intellij.database.model.DasIndex;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.build.DeBuilderBase;
import com.intellij.database.schemaEditor.model.build.DeKeyBuilder;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class KeyModelBuilder<Self extends KeyModelBuilder<?>>
extends DeBuilderBase<Self>
implements DeKeyBuilder<Self> {
    protected final TableKeyEditorModel myKeyModel;

    protected KeyModelBuilder(@NotNull TableKeyEditorModel indexModel) {
        if (indexModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexModel", "com/intellij/database/view/models/builder/KeyModelBuilder", "<init>"));
        }
        this.myKeyModel = indexModel;
    }

    @Override
    public Self addColumn(@NotNull DeColumn col) {
        if (col == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col", "com/intellij/database/view/models/builder/KeyModelBuilder", "addColumn"));
        }
        DeTable table = this.myKeyModel.getTable();
        this.myKeyModel.setColumns(ContainerUtil.append(this.myKeyModel.getColumns(), (Object[])new DeColumn[]{EditorModelUtil.stubbize(col, table, table.model)}));
        return (Self)((KeyModelBuilder)this.self());
    }

    public Self addColumns(@NotNull Iterable<DeColumn> cols3, @NotNull DasIndex.Sorting sorting) {
        if (cols3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols", "com/intellij/database/view/models/builder/KeyModelBuilder", "addColumns"));
        }
        if (sorting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorting", "com/intellij/database/view/models/builder/KeyModelBuilder", "addColumns"));
        }
        this.myKeyModel.setColumns(ContainerUtil.concat(this.myKeyModel.getColumns(), (List)JBIterable.from(cols3).toList()));
        return (Self)((KeyModelBuilder)this.self());
    }

    public Self commit() {
        this.myKeyModel.commit();
        return (Self)((KeyModelBuilder)this.self());
    }
}

