/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverPropertiesPanel {
    private static final String USER_DEFINED_DESCRIPTION = "user defined";
    private static final Set<String> PROHIBITED_PROPERTIES_NAMES = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE, (Object[])new String[]{"user", "password", "host", "port", "dbname", "pghost", "pgport", "pgdbname"});
    private final Project myProject;
    private final Configurable myOwner;
    private final DatabaseConfigEditor myController;
    private final JPanel myRootPanel;
    private final TableView<DriverPropertyInfo> myAdvancedPropertiesTable;
    private final JTextArea myPropertyDescriptionArea;
    private final RawCommandLineEditor myVMParameters;
    private final EnvironmentVariablesTextFieldWithBrowseButton myVMEnv;
    private final Map<String, String> myAdvancedValuesMap;
    private final List<DriverPropertyInfo> myUserProperties;
    private final JBLoadingPanel myLoadingPanel;
    private String myPropertiesDriverName;
    private List<SimpleClasspathElement> myClassPath;

    public DatabaseDriverPropertiesPanel(@NotNull Project project, @NotNull Map<String, String> properties, String vmOptions, @NotNull Configurable owner, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel", "<init>"));
        }
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel", "<init>"));
        }
        this.myRootPanel = new JPanel(new BorderLayout());
        this.myPropertyDescriptionArea = new JTextArea();
        this.myAdvancedValuesMap = ContainerUtil.newLinkedHashMap();
        this.myUserProperties = ContainerUtil.newArrayList();
        this.myClassPath = Collections.emptyList();
        this.myProject = project;
        this.myOwner = owner;
        this.myController = controller;
        this.myAdvancedPropertiesTable = new TableView();
        this.myAdvancedPropertiesTable.setEnableAntialiasing(true);
        this.myAdvancedPropertiesTable.setRowHeight(new JTextField((String)"").getPreferredSize().height);
        JPanel propPanel = new JPanel(new BorderLayout());
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)owner);
        propPanel.add((Component)this.myLoadingPanel, "Center");
        this.myLoadingPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myAdvancedPropertiesTable), (Object)"Center");
        propPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myPropertyDescriptionArea), "South");
        this.myPropertyDescriptionArea.setEditable(false);
        this.myPropertyDescriptionArea.setRows(3);
        this.myPropertyDescriptionArea.setWrapStyleWord(true);
        this.myPropertyDescriptionArea.setLineWrap(true);
        this.myPropertyDescriptionArea.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myRootPanel.add((Component)propPanel, "Center");
        ((JComponent)propPanel.getComponent(0)).setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        propPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        JPanel execProps = new JPanel((LayoutManager)new GridLayoutManager(2, 2, (Insets)JBUI.emptyInsets(), 5, 4));
        execProps.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        execProps.add((Component)new JBLabel("VM options:"), DatabaseDriverPropertiesPanel.createCell(0, 0, true));
        execProps.add((Component)new JBLabel("VM environment:"), DatabaseDriverPropertiesPanel.createCell(1, 0, true));
        this.myRootPanel.add((Component)execProps, "South");
        this.myPropertyDescriptionArea.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        new UiNotifyConnector(this.myAdvancedPropertiesTable, new Activatable(){

            public void showNotify() {
                DatabaseDriverPropertiesPanel.this.refreshAdvancedProperties();
            }

            public void hideNotify() {
            }
        });
        this.myAdvancedPropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel$2", "valueChanged"));
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable.getSelectionModel().getLeadSelectionIndex();
                if (index < 0) {
                    DatabaseDriverPropertiesPanel.this.myPropertyDescriptionArea.setText("");
                } else {
                    int modelIndex = DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable.convertRowIndexToModel(index);
                    DriverPropertyInfo info = (DriverPropertyInfo)DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable.getListTableModel().getItems().get(modelIndex);
                    DatabaseDriverPropertiesPanel.this.myPropertyDescriptionArea.setText(info.description);
                }
                DatabaseDriverPropertiesPanel.this.myPropertyDescriptionArea.setCaretPosition(0);
            }
        });
        this.myPropertyDescriptionArea.setBackground(this.myRootPanel.getBackground());
        for (String propertyName : properties.keySet()) {
            this.addUserDefinedProperty(propertyName, properties.get(propertyName), true);
        }
        this.ensureNewPropertyPresent();
        this.myVMParameters = new RawCommandLineEditor();
        this.myVMParameters.setDialogCaption("VM Options");
        this.myVMParameters.setText(StringUtil.notNullize((String)vmOptions));
        this.myVMEnv = new EnvironmentVariablesTextFieldWithBrowseButton();
        execProps.add((Component)this.myVMParameters, DatabaseDriverPropertiesPanel.createCell(0, 1, false));
        execProps.add((Component)this.myVMEnv, DatabaseDriverPropertiesPanel.createCell(1, 1, false));
        this.setupTableView();
    }

    private static GridConstraints createCell(int row, int column, boolean label) {
        return new GridConstraints(row, column, 1, 1, 8, label ? 0 : 3, label ? 0 : 7, 7, new Dimension(-1, -1), new Dimension(-1, -1), new Dimension(-1, -1));
    }

    private DriverPropertyInfo addUserDefinedProperty(String propertyName, String value, boolean changed) {
        DriverPropertyInfo property = new DriverPropertyInfo(propertyName, value);
        property.description = USER_DEFINED_DESCRIPTION;
        this.myUserProperties.add(property);
        if (changed) {
            this.myAdvancedValuesMap.put(property.name, property.value);
        }
        return property;
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public void refreshAdvancedProperties() {
        boolean emptyDriver;
        DatabaseDriver databaseDriver;
        if (this.myOwner instanceof DataSourceConfigurable) {
            databaseDriver = ((DataSourceConfigurable)this.myOwner).getTempDataSource().getDatabaseDriver();
        } else if (this.myOwner instanceof DatabaseDriverConfigurable) {
            databaseDriver = ((DatabaseDriverConfigurable)this.myOwner).getTempDriver();
        } else {
            throw new AssertionError(this.myOwner);
        }
        if (databaseDriver == null || databaseDriver.getClasspathElements().isEmpty()) {
            return;
        }
        LocalDataSource tempDataSource = new LocalDataSource(databaseDriver, DatabaseDriverPropertiesPanel.getTempUrl(databaseDriver));
        boolean bl = emptyDriver = StringUtil.isEmptyOrSpaces((String)tempDataSource.getDriverClass()) || tempDataSource.getClasspathElements().isEmpty();
        if (emptyDriver) {
            this.myAdvancedPropertiesTable.getEmptyText().setText("No Properties");
            this.myAdvancedPropertiesTable.getListTableModel().setItems(new ArrayList<DriverPropertyInfo>(this.myUserProperties));
            return;
        }
        if (this.isUpToDate(tempDataSource)) {
            return;
        }
        this.myAdvancedPropertiesTable.getEmptyText().setText("");
        this.myLoadingPanel.startLoading();
        this.myPropertiesDriverName = tempDataSource.getDriverClass();
        this.myClassPath = ContainerUtil.newArrayList(tempDataSource.getClasspathElements());
        ModalityState state = ModalityState.current();
        String url = this.myOwner instanceof DataSourceConfigurable ? ((DataSourceConfigurable)this.myOwner).getTempDataSource().getUrl() : tempDataSource.getUrl();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList<DriverPropertyInfo> rows = new ArrayList<DriverPropertyInfo>();
            Ref exRef = Ref.create(null);
            try {
                DriverPropertyInfo[] propertyInfo;
                Driver driver = DatabaseConnectionManager.getInstance().getDriver(this.myProject, tempDataSource);
                for (DriverPropertyInfo info : propertyInfo = driver.getPropertyInfo(url, new Properties())) {
                    if (PROHIBITED_PROPERTIES_NAMES.contains(info.name)) continue;
                    rows.add(info);
                }
            }
            catch (Exception e) {
                exRef.set((Object)e);
            }
            finally {
                Runnable runnable = () -> {
                    if (Disposer.isDisposed((Disposable)((Disposable)this.myOwner))) {
                        return;
                    }
                    if (!this.isUpToDate(tempDataSource)) {
                        return;
                    }
                    this.myLoadingPanel.stopLoading();
                    this.myAdvancedPropertiesTable.getEmptyText().setText(exRef.isNull() ? "No Properties Found" : "Error Requesting Properties from the Database Driver");
                    THashSet loadedNames = ContainerUtil.newTroveSet();
                    for (DriverPropertyInfo row : rows) {
                        loadedNames.add((Object)row.name);
                    }
                    for (DriverPropertyInfo property : this.myUserProperties) {
                        if (loadedNames.contains((Object)property.name)) continue;
                        rows.add(property);
                    }
                    this.myAdvancedPropertiesTable.getListTableModel().setItems((List)rows);
                    this.myController.showErrorNotification(this.myOwner, "PROPERTIES_LOAD_FAILED", (Exception)exRef.get());
                };
                if (this.myProject.isOpen()) {
                    DatabaseConnectionManager.getInstance().releaseDriver(this.myProject, tempDataSource);
                    ApplicationManager.getApplication().invokeLater(runnable, state);
                }
            }
        });
    }

    @NotNull
    public static String getTempUrl(DatabaseDriver driver) {
        String string = driver.getSampleUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel", "getTempUrl"));
        }
        return string;
    }

    private boolean isUpToDate(LocalDataSource tempDataSource) {
        return Comparing.equal((String)this.myPropertiesDriverName, (String)tempDataSource.getDriverClass()) && this.myClassPath.equals(tempDataSource.getClasspathElements());
    }

    private void setupTableView() {
        new TableSpeedSearch(this.myAdvancedPropertiesTable).setComparator(new SpeedSearchComparator(false));
        final Comparator comparator = (o1, o2) -> {
            if (o1.description == USER_DEFINED_DESCRIPTION && o2.description != USER_DEFINED_DESCRIPTION) {
                return 1;
            }
            if (o2.description == USER_DEFINED_DESCRIPTION && o1.description != USER_DEFINED_DESCRIPTION) {
                return -1;
            }
            if (StringUtil.isEmpty((String)o1.name) && !StringUtil.isEmpty((String)o2.name)) {
                return 1;
            }
            if (StringUtil.isEmpty((String)o2.name) && !StringUtil.isEmpty((String)o1.name)) {
                return -1;
            }
            return StringUtil.naturalCompare((String)o1.name, (String)o2.name);
        };
        final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            @NotNull
            public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel$3", "getTableCellRendererComponent"));
                }
                Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DriverPropertyInfo o = (DriverPropertyInfo)DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable.getListTableModel().getItems().get(DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable.convertRowIndexToModel(row));
                String propertyValue = (String)DatabaseDriverPropertiesPanel.this.myAdvancedValuesMap.get(o.name);
                result.setFont(result.getFont().deriveFont(propertyValue != null && !propertyValue.equals(o.value) ? 1 : 0));
                if (StringUtil.isEmpty((String)o.name) && StringUtil.isEmpty((String)o.value)) {
                    this.setText(column == 0 ? "<user defined>" : "<value>");
                }
                if (!isSelected) {
                    if (StringUtil.isEmpty((String)o.name)) {
                        result.setForeground(UIUtil.getInactiveTextColor());
                    } else if (o.description == DatabaseDriverPropertiesPanel.USER_DEFINED_DESCRIPTION) {
                        result.setForeground(PlatformColors.BLUE);
                    } else {
                        result.setForeground(UIUtil.getLabelForeground());
                    }
                }
                Component component = result;
                if (component == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel$3", "getTableCellRendererComponent"));
                }
                return component;
            }
        };
        JBTextField editor1Field = new JBTextField();
        editor1Field.setBorder(renderer.getBorder());
        final ComboBox editor2Combo = new ComboBox();
        editor2Combo.setBorder(null);
        editor2Combo.setEditable(false);
        final DefaultCellEditor editor1 = new DefaultCellEditor((JTextField)editor1Field);
        final DefaultCellEditor editor2 = new DefaultCellEditor((JComboBox<?>)editor2Combo);
        editor2Combo.registerTableCellEditor((TableCellEditor)editor2);
        editor1.setClickCountToStart(1);
        editor2.setClickCountToStart(1);
        this.myAdvancedPropertiesTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new ColumnInfo<DriverPropertyInfo, String>("Name"){

            public String valueOf(DriverPropertyInfo o) {
                return o.required ? o.name + " *" : o.name;
            }

            public TableCellRenderer getRenderer(DriverPropertyInfo driverPropertyInfo) {
                return renderer;
            }

            public Comparator<DriverPropertyInfo> getComparator() {
                return comparator;
            }

            public boolean isCellEditable(DriverPropertyInfo driverPropertyInfo) {
                return driverPropertyInfo.description == DatabaseDriverPropertiesPanel.USER_DEFINED_DESCRIPTION;
            }

            public void setValue(DriverPropertyInfo driverPropertyInfo, String value) {
                String prevName = driverPropertyInfo.name;
                driverPropertyInfo.name = value;
                String propValue = (String)DatabaseDriverPropertiesPanel.this.myAdvancedValuesMap.remove(prevName);
                if (StringUtil.isEmpty((String)value) && propValue != null) {
                    driverPropertyInfo.value = propValue;
                }
                if (StringUtil.isEmpty((String)driverPropertyInfo.value) || StringUtil.isEmpty((String)value)) {
                    DbUIUtil.invokeLater(() -> {
                        if (!DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable.isShowing()) {
                            return;
                        }
                        int index = DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable.getListTableModel().getItems().indexOf(driverPropertyInfo);
                        if (index < 0) {
                            return;
                        }
                        int row = DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable.convertRowIndexToView(index);
                        TableUtil.editCellAt((JTable)DatabaseDriverPropertiesPanel.this.myAdvancedPropertiesTable, (int)row, (int)1);
                    });
                }
                DatabaseDriverPropertiesPanel.this.ensureNewPropertyPresent();
            }

            @Nullable
            public TableCellEditor getEditor(DriverPropertyInfo info) {
                return editor1;
            }
        }, new ColumnInfo<DriverPropertyInfo, String>("Value"){

            public String valueOf(DriverPropertyInfo o) {
                String value = (String)DatabaseDriverPropertiesPanel.this.myAdvancedValuesMap.get(o.name);
                return value == null ? o.value : value;
            }

            public boolean isCellEditable(DriverPropertyInfo driverPropertyInfo) {
                return true;
            }

            public void setValue(DriverPropertyInfo driverPropertyInfo, String value) {
                if (driverPropertyInfo.description == DatabaseDriverPropertiesPanel.USER_DEFINED_DESCRIPTION && !DatabaseDriverPropertiesPanel.this.myAdvancedValuesMap.containsKey(driverPropertyInfo.name)) {
                    driverPropertyInfo.value = value;
                } else if (!Comparing.equal((String)StringUtil.nullize((String)driverPropertyInfo.value), (String)StringUtil.nullize((String)value))) {
                    DatabaseDriverPropertiesPanel.this.myAdvancedValuesMap.put(driverPropertyInfo.name, value);
                } else {
                    DatabaseDriverPropertiesPanel.this.myAdvancedValuesMap.remove(driverPropertyInfo.name);
                }
                DatabaseDriverPropertiesPanel.this.ensureNewPropertyPresent();
            }

            public TableCellRenderer getRenderer(DriverPropertyInfo driverPropertyInfo) {
                return renderer;
            }

            public TableCellEditor getEditor(DriverPropertyInfo o) {
                if (o.choices == null || o.choices.length == 0) {
                    return editor1;
                }
                editor2Combo.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(o.choices), (Object)o.value));
                return editor2;
            }
        }}, new ArrayList<DriverPropertyInfo>(this.myUserProperties), -1));
    }

    private void ensureNewPropertyPresent() {
        ArrayList<DriverPropertyInfo> emptyProperties = new ArrayList<DriverPropertyInfo>();
        for (DriverPropertyInfo property : this.myUserProperties) {
            if (!StringUtil.isEmpty((String)property.name) || !StringUtil.isEmpty((String)property.value)) continue;
            emptyProperties.add(property);
        }
        ArrayList<DriverPropertyInfo> toRemove = emptyProperties.isEmpty() ? emptyProperties : emptyProperties.subList(0, emptyProperties.size() - 1);
        this.myUserProperties.removeAll(toRemove);
        ListTableModel model = this.myAdvancedPropertiesTable.getListTableModel();
        List items = model.getItems();
        if (!toRemove.isEmpty()) {
            int row = Math.min(this.myAdvancedPropertiesTable.getSelectedRow(), model.getRowCount() - toRemove.size());
            for (DriverPropertyInfo property : toRemove) {
                model.removeRow(items.indexOf(property));
            }
            this.myAdvancedPropertiesTable.getSelectionModel().setSelectionInterval(row, row);
        }
        if (emptyProperties.isEmpty()) {
            DriverPropertyInfo property = this.addUserDefinedProperty("", "", false);
            model.addRow((Object)property);
            Rectangle rect = this.myAdvancedPropertiesTable.getCellRect(model.getRowCount() - 1, 0, false);
            this.myAdvancedPropertiesTable.scrollRectToVisible(rect);
        }
    }

    public void saveProperties(Map<String, String> driverProperties) {
        driverProperties.clear();
        driverProperties.putAll(this.myAdvancedValuesMap);
        List allProperties = this.myAdvancedPropertiesTable.getListTableModel().getItems();
        for (DriverPropertyInfo property : this.myUserProperties) {
            if (StringUtil.isEmpty((String)property.name) || this.myAdvancedValuesMap.containsKey(property.name) || !allProperties.contains(property)) continue;
            driverProperties.put(property.name, property.value);
        }
    }

    public String getVmOptions() {
        return this.myVMParameters.getText().trim();
    }

    public void setVmOptions(String options) {
        this.myVMParameters.setText(options);
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map map = this.myVMEnv.getEnvs();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel", "getVmEnv"));
        }
        return map;
    }

    public void setVmEnv(@NotNull Map<String, String> env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/database/view/ui/DatabaseDriverPropertiesPanel", "setVmEnv"));
        }
        this.myVMEnv.setEnvs(env);
    }
}

