/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTriggerStatementImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgCreateFunctionStatementImpl
extends SqlCreateFunctionStatementImpl {
    private SqlCreateTriggerStatementImpl.FakeSynonym myNew;
    private SqlCreateTriggerStatementImpl.FakeSynonym myOld;

    public PgCreateFunctionStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl", "<init>"));
        }
        super(node);
    }

    public PgCreateFunctionStatementImpl(SqlNamedElementStub<?> stub) {
        super(stub);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (lastParent.getParent() == this && lastParent instanceof LazyParseablePsiElement && PgCreateFunctionStatementImpl.isTriggerFunction(this) && !this.processTriggerDeclarations(processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public boolean processTriggerDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (!processor.execute((PsiElement)this.getOld(), state) || !processor.execute((PsiElement)this.getNew(), state)) {
            return false;
        }
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
        if (sqlProcessor != null) {
            for (DasObject entity : LazyData.TRIGGER_STRING_IMPLICITS.values()) {
                if (sqlProcessor.executeTarget(entity, place, (SqlType)SqlType.STRING, false, state)) continue;
                return false;
            }
            if (!sqlProcessor.executeTarget((DasObject)LazyData.RE_TG_NARGS, place, (SqlType)SqlType.INTEGER, false, state) || !sqlProcessor.executeTarget((DasObject)LazyData.RE_TG_ARGV, place, (SqlType)SqlType.ARRAY, false, state)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private SqlCreateTriggerStatementImpl.FakeSynonym getOld() {
        SqlCreateTriggerStatementImpl.FakeSynonym fakeSynonym = this.myOld == null ? (this.myOld = new PgFakeSynonym("old")) : this.myOld;
        if (fakeSynonym == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl", "getOld"));
        }
        return fakeSynonym;
    }

    @NotNull
    private SqlCreateTriggerStatementImpl.FakeSynonym getNew() {
        SqlCreateTriggerStatementImpl.FakeSynonym fakeSynonym = this.myNew == null ? (this.myNew = new PgFakeSynonym("new")) : this.myNew;
        if (fakeSynonym == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl", "getNew"));
        }
        return fakeSynonym;
    }

    @Nullable
    public SqlCreateTriggerStatement getTrigger() {
        return (SqlCreateTriggerStatement)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.findTrigger(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlCreateTriggerStatement findTrigger() {
        SqlCreateTriggerStatement statement = null;
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)this.getContainingFile(), SqlFile.class);
        if (file != null) {
            SqlCreateFunctionStatementImpl target = (SqlCreateFunctionStatementImpl)CompletionUtil.getOriginalOrSelf((PsiElement)this);
            statement = (SqlCreateTriggerStatement)PsiTreeUtil.getParentOfType((PsiElement)target, SqlCreateTriggerStatement.class);
            if (statement != null) {
                return statement;
            }
            for (SqlElement element : file.getDdl()) {
                SqlFunctionCallExpression call;
                SqlReferenceExpression ref;
                SqlCreateTriggerStatement trigger2 = (SqlCreateTriggerStatement)ObjectUtils.tryCast((Object)element, SqlCreateTriggerStatement.class);
                if (trigger2 == null || (ref = (call = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)trigger2.getTriggerProcedure(), SqlFunctionCallExpression.class)) == null ? null : call.getNameElement()) == null || !ref.getReference().isReferenceTo((PsiElement)target)) continue;
                statement = trigger2;
                break;
            }
        }
        return statement;
    }

    public static boolean isTriggerFunction(DasRoutine r) {
        DasArgument ret = r == null ? null : r.getReturnArgument();
        return ret != null && StringUtil.containsIgnoreCase((String)ret.getDataType().typeName, (String)"trigger");
    }

    private class PgFakeSynonym
    extends SqlCreateTriggerStatementImpl.FakeSynonym {
        public PgFakeSynonym(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl$PgFakeSynonym", "<init>"));
            }
            super((PsiElement)PgCreateFunctionStatementImpl.this, name);
        }

        @Override
        @Nullable
        public SqlReferenceExpression getTargetContextExpression() {
            SqlCreateTriggerStatement trigger2 = PgCreateFunctionStatementImpl.this.getTrigger();
            return trigger2 == null ? null : trigger2.getTargetContextExpression();
        }
    }

    private static class LazyData {
        static final Map<String, DasObject> TRIGGER_STRING_IMPLICITS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "tg_name", "tg_when", "tg_level", "tg_op", "tg_relid", "tg_relname", "tg_table_name", "tg_table_schema", "tg_tag", "tg_event");
        static final ReservedEntity RE_TG_NARGS = new ReservedEntity("tg_nargs", ObjectKind.COLUMN);
        static final ReservedEntity RE_TG_ARGV = new ReservedEntity("tg_argv", ObjectKind.COLUMN);

        private LazyData() {
        }
    }
}

