/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPartitionByClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAmbiguousColumnInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.ambiguous.column", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "createAnnotationVisitor"));
        }
        SqlInspectionBase.SqlAnnotationVisitor sqlAnnotationVisitor = new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            @Override
            protected boolean shouldNotCheckElement(@NotNull SqlElement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$1", "shouldNotCheckElement"));
                }
                if (o.getParent() instanceof SqlPartitionByClauseImpl) {
                    return true;
                }
                return super.shouldNotCheckElement(o);
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$1", "visitSqlReferenceExpression"));
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                ObjectKind type = o.getReferenceElementType().getTargetKind();
                if ((type == SqlDbElementType.ANY || type == ObjectKind.COLUMN) && o.getQualifierExpression() == null) {
                    SqlJoinExpression joinExpression;
                    SqlFromClause fromClause;
                    SqlClause clause = (SqlClause)PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{SqlQueryClause.class, SqlUsingClause.class});
                    if (clause instanceof SqlUsingClause) {
                        return;
                    }
                    SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlQueryExpression.class, (boolean)true);
                    SqlTableExpression tableExpression = queryExpression == null ? null : queryExpression.getTableExpression();
                    SqlType queryExpressionType = queryExpression != null ? queryExpression.getSqlType() : null;
                    SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
                    if (fromClause == null) {
                        return;
                    }
                    DatabaseFamilyId familyId = this.myDialect.getDatabaseDialect().getFamilyId();
                    SqlTableType tableType = clause instanceof SqlFromClause ? ((joinExpression = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlJoinExpression.class, (boolean)true)) == null ? tableExpression.getSqlType() : joinExpression.getSqlType()) : (clause instanceof SqlOrderByClause || clause instanceof SqlGroupByClause && familyId.isMysql() ? (queryExpressionType instanceof SqlTableType ? (SqlTableType)queryExpressionType : SqlTableTypeBase.EMPTY_TABLE) : tableExpression.getSqlType());
                    String columnName = o.getName();
                    int matchedAliases = 0;
                    int matchedColumns = 0;
                    int count = tableType.getColumnCount();
                    for (int i2 = 0; i2 < count; ++i2) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType.getColumnName(i2), (boolean)false)) continue;
                        if (tableType.getColumnElement(i2) instanceof SqlAsExpression) {
                            ++matchedAliases;
                            continue;
                        }
                        ++matchedColumns;
                    }
                    if (matchedAliases + matchedColumns <= 1) {
                        return;
                    }
                    if (clause instanceof SqlOrderByClause) {
                        if (familyId.isDb2() && matchedColumns == 1 && matchedAliases == 1) {
                            return;
                        }
                        if (familyId.isSybase() && matchedAliases == 0) {
                            return;
                        }
                    }
                    ArrayList names = ContainerUtil.newArrayListWithCapacity((int)(matchedAliases + matchedColumns));
                    int count2 = tableType.getColumnCount();
                    for (int i3 = 0; i3 < count2; ++i3) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType.getColumnName(i3), (boolean)false)) continue;
                        String tableAlias = tableType.getColumnTypeAlias(i3);
                        if (tableAlias != null) {
                            names.add(tableAlias + "." + columnName);
                            continue;
                        }
                        PsiElement c = tableType.getSourceColumnElement(i3);
                        names.add(c == null ? columnName : SqlAmbiguousColumnInspection.getQualifiedName(c));
                    }
                    Collections.sort(names);
                    for (SqlUsingClause usingClause : SqlAmbiguousColumnInspection.getAllUsingClauses(tableExpression)) {
                        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList(usingClause.getReferenceList());
                        if (referenceList.isEmpty()) continue;
                        if (names.isEmpty()) break;
                        for (SqlAsExpression expression : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)usingClause.getParent(), SqlAsExpression.class)) {
                            names.remove(expression.getName() + "." + columnName);
                        }
                        for (SqlReferenceExpression reference : referenceList) {
                            for (ResolveResult resolveResult : reference.multiResolve(false)) {
                                names.remove(SqlAmbiguousColumnInspection.getQualifiedName(resolveResult.getElement()));
                            }
                        }
                    }
                    if (names.size() > 1) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlMessages.message("ambiguous.column.short.reference", StringUtil.join((String[])ArrayUtil.toStringArray((Collection)names), (String)",\n")), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
            }
        };
        if (sqlAnnotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "createAnnotationVisitor"));
        }
        return sqlAnnotationVisitor;
    }

    @NotNull
    private static Collection<SqlUsingClause> getAllUsingClauses(@NotNull SqlTableExpression tableExpression) {
        if (tableExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableExpression", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getAllUsingClauses"));
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            List<SqlUsingClause> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getAllUsingClauses"));
            }
            return list;
        }
        final ArrayList result = ContainerUtil.newArrayList();
        fromClause.acceptChildren(new SqlVisitor(){

            public void visitSqlJoinExpression(@NotNull SqlJoinExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$2", "visitSqlJoinExpression"));
                }
                o.acceptChildren((SqlVisitor)this);
            }

            public void visitSqlUsingClause(SqlUsingClause o) {
                result.add(o);
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getAllUsingClauses"));
        }
        return arrayList;
    }

    @NotNull
    public static String getQualifiedName(@Nullable PsiElement element) {
        if (element == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getQualifiedName"));
            }
            return "";
        }
        if (element instanceof DbElement) {
            String string = QNameUtil.getQualifiedName((DbElement)element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getQualifiedName"));
            }
            return string;
        }
        if (element instanceof SqlDefinition) {
            String string = QNameUtil.getQualifiedName((DasObject)((SqlDefinition)element));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getQualifiedName"));
            }
            return string;
        }
        if (element instanceof PsiNamedElement) {
            String string = StringUtil.notNullize((String)((PsiNamedElement)element).getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getQualifiedName"));
            }
            return string;
        }
        String string = StringUtil.notNullize((String)element.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection", "getQualifiedName"));
        }
        return string;
    }
}

