/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.ApiTask;
import com.intellij.javaee.openshift.agent.cloud.OS3ApplicationBase;
import com.intellij.javaee.openshift.agent.cloud.OS3Context;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationProperty;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationPropertyImpl;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Pod;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogPipe;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPodLogRetrieval;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;

public class OS3PodImpl
extends OS3ApplicationBase
implements OS3Pod {
    private final IPod myPod;

    public OS3PodImpl(IPod pod, OS3Context context) {
        super((IResource)pod, context, OS3PodImpl.wrapSpecific(pod));
        this.myPod = pod;
    }

    public String getStatus() {
        return this.myPod.getStatus();
    }

    private static OS3ApplicationProperty[] wrapSpecific(IPod pod) {
        return new OS3ApplicationProperty[]{new OS3ApplicationPropertyImpl("Host", pod.getHost()), new OS3ApplicationPropertyImpl("Image(s)", pod.getImages().toString()), new OS3ApplicationPropertyImpl("IP", pod.getIP()), new OS3ApplicationPropertyImpl("Status", pod.getStatus())};
    }

    public void showLog(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTask<Object>(this.getContext().getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException {
                OS3PodImpl.this.doShowLog(OS3PodImpl.this.getName(), loggingHandler);
                return null;
            }
        }.perform();
    }

    protected void doShowLog(String pod, CloudAgentLoggingHandler loggingHandler) throws IOException {
        OS3LogPipe logPipe = new OS3LogPipe(pod, loggingHandler);
        this.getContext().getLogManager().startListeningLog(pod, deploymentName -> Collections.singletonList(logPipe));
    }

    private class OS3LogPipe
    extends LogPipe {
        public OS3LogPipe(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException {
            super(containerId, "Log", OS3PodImpl.this.getContext().getLogger(), loggingHandler);
        }

        protected InputStream createInputStream(String pod) {
            return (InputStream)OS3PodImpl.this.myPod.accept((CapabilityVisitor)new CapabilityVisitor<IPodLogRetrieval, InputStream>(){

                public InputStream visit(IPodLogRetrieval cap) {
                    return cap.getLogs(true, new IBinaryCapability.OpenShiftBinaryOption[0]);
                }
            }, null);
        }
    }
}

