/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceConfigurationEditorUtils {
    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceConfigurationEditorUtils", "createConfigurationFileTextField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceConfigurationEditorUtils", "lambda$createConfigurationFileTextField$1"));
            }
            List<VirtualFile> newFiles = TraceConfigurationEditorUtils.listPossibleConfigFilesInProject(project);
            List newFilePaths = ContainerUtil.map(newFiles, file -> FileUtil.toSystemDependentName((String)file.getPath()));
            Collections.sort(newFilePaths);
            return newFilePaths;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)TraceBundle.message("configuration.dialogTitle.config", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)JavaScriptFileType.INSTANCE));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceConfigurationEditorUtils", "createConfigurationFileTextField"));
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    public static void setTextAndAddToHistory(@NotNull TextFieldWithHistory textFieldWithHistory, @Nullable String text) {
        if (textFieldWithHistory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithHistory", "com/intellij/javascript/trace/execution/TraceConfigurationEditorUtils", "setTextAndAddToHistory"));
        }
        textFieldWithHistory.setText(text);
        textFieldWithHistory.getModel().setSelectedItem(text);
        textFieldWithHistory.addCurrentTextToHistory();
    }

    @NotNull
    private static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceConfigurationEditorUtils", "listPossibleConfigFilesInProject"));
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
        Collection files = FileTypeIndex.getFiles((FileType)JavaScriptFileType.INSTANCE, (GlobalSearchScope)scope);
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            if (!file.getName().endsWith(".conf.js")) continue;
            result.add(file);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceConfigurationEditorUtils", "listPossibleConfigFilesInProject"));
        }
        return arrayList;
    }
}

