/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.trace.execution.TraceConsoleProperties;
import com.intellij.javascript.trace.execution.TraceConsoleView;
import com.intellij.javascript.trace.execution.TraceRunConfiguration;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.session.TraceSessionImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceProfileState
implements RunProfileState {
    private Project myProject;
    private ExecutionEnvironment myEnvironment;

    public TraceProfileState(@NotNull Project project, @NotNull ExecutionEnvironment environment) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceProfileState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/trace/execution/TraceProfileState", "<init>"));
        }
        this.myProject = project;
        this.myEnvironment = environment;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/javascript/trace/execution/TraceProfileState", "execute"));
        }
        TraceRunConfiguration runConfiguration = (TraceRunConfiguration)this.myEnvironment.getRunProfile();
        TraceSessionImpl session = new TraceSessionImpl(runConfiguration, this.myProject);
        ProcessHandler processHandler = session.getProcessHandler();
        TraceConsoleProperties properties = new TraceConsoleProperties(this.myProject, (RunConfiguration)runConfiguration);
        TraceConsoleView traceConsoleView = new TraceConsoleView(properties, session, this.myEnvironment);
        processHandler.putUserData(TraceContext.KEY, (Object)traceConsoleView.getTracePanel());
        Disposer.register((Disposable)this.myProject, (Disposable)traceConsoleView);
        Disposer.register((Disposable)traceConsoleView, (Disposable)session);
        traceConsoleView.initUI();
        return new DefaultExecutionResult((ExecutionConsole)traceConsoleView, processHandler);
    }
}

