/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.context;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.context.AutoExpandableValue;
import com.intellij.javascript.trace.execution.context.ParameterValue;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import org.jetbrains.annotations.NotNull;

public class ArgumentsValue
extends XNamedValue
implements AutoExpandableValue {
    private RuntimeFunctionArgument[] myArguments;

    protected ArgumentsValue(RuntimeFunctionArgument[] arguments) {
        super(TraceBundle.message("console.trace.context.arguments", new Object[0]));
        this.myArguments = arguments;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/context/ArgumentsValue", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/javascript/trace/execution/context/ArgumentsValue", "computePresentation"));
        }
        node.setPresentation(AllIcons.Debugger.Db_array, (XValuePresentation)new XRegularValuePresentation(String.valueOf(this.myArguments.length), null), true);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/trace/execution/context/ArgumentsValue", "computeChildren"));
        }
        XValueChildrenList children = new XValueChildrenList();
        for (RuntimeFunctionArgument arg : this.myArguments) {
            children.add((XNamedValue)new ParameterValue(arg));
        }
        node.addChildren(children, true);
    }
}

